/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.RemoteException;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.maps.zzad;
import com.google.android.gms.maps.model.Cap;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PatternItem;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import java.util.List;

public final class Polyline {
    private final zzad zza;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove() {
        try {
            this.zza.zzd();
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    @RecentlyNonNull
    public String getId() {
        try {
            String this_ = ((Polyline)((Object)this_)).zza.zze();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return this_;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setPoints(@RecentlyNonNull List<LatLng> points) {
        RuntimeRemoteException runtimeRemoteException;
        Preconditions.checkNotNull(points, (Object)"points must not be null");
        try {
            this.zza.zzf((List<LatLng>)((Object)runtimeRemoteException));
            return;
        }
        catch (RemoteException remoteException) {
            runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    @RecentlyNonNull
    public List<LatLng> getPoints() {
        try {
            List<LatLng> this_ = ((Polyline)((Object)this_)).zza.zzg();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return this_;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setWidth(float width) {
        try {
            void var1_2;
            this.zza.zzh((float)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    public float getWidth() {
        float f;
        try {
            f = this.zza.zzi();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return f;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setColor(int color) {
        try {
            void var1_2;
            this.zza.zzj((int)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    public int getColor() {
        int n;
        try {
            n = this.zza.zzk();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setStartCap(@RecentlyNonNull Cap startCap) {
        RuntimeRemoteException runtimeRemoteException;
        Preconditions.checkNotNull((Object)((Object)startCap), (Object)"startCap must not be null");
        try {
            this.zza.zzv((Cap)((Object)runtimeRemoteException));
            return;
        }
        catch (RemoteException remoteException) {
            runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    @RecentlyNonNull
    public Cap getStartCap() {
        try {
            Object this_ = this_.zza.zzw().zza();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return this_;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setEndCap(@RecentlyNonNull Cap endCap) {
        RuntimeRemoteException runtimeRemoteException;
        Preconditions.checkNotNull((Object)((Object)endCap), (Object)"endCap must not be null");
        try {
            this.zza.zzx((Cap)((Object)runtimeRemoteException));
            return;
        }
        catch (RemoteException remoteException) {
            runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    @RecentlyNonNull
    public Cap getEndCap() {
        try {
            Object this_ = this_.zza.zzy().zza();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return this_;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setJointType(int jointType) {
        try {
            void var1_2;
            this.zza.zzz((int)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    public int getJointType() {
        int n;
        try {
            n = this.zza.zzA();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setPattern(@Nullable List<PatternItem> pattern) {
        RuntimeRemoteException runtimeRemoteException;
        try {
            this.zza.zzB((List<PatternItem>)((Object)runtimeRemoteException));
            return;
        }
        catch (RemoteException remoteException) {
            runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    @RecentlyNullable
    public List<PatternItem> getPattern() {
        try {
            List<PatternItem> this_ = ((Polyline)((Object)this_)).zza.zzC();
            this_ = PatternItem.zza(this_);
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return this_;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setZIndex(float zIndex) {
        try {
            void var1_2;
            this.zza.zzl((float)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    public float getZIndex() {
        float f;
        try {
            f = this.zza.zzm();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return f;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setVisible(boolean visible) {
        try {
            void var1_2;
            this.zza.zzn((boolean)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    public boolean isVisible() {
        boolean bl;
        try {
            bl = this.zza.zzo();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setGeodesic(boolean geodesic) {
        try {
            void var1_2;
            this.zza.zzp((boolean)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    public boolean isGeodesic() {
        boolean bl;
        try {
            bl = this.zza.zzq();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setClickable(boolean clickable) {
        try {
            void var1_2;
            this.zza.zzt((boolean)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    public boolean isClickable() {
        boolean bl;
        try {
            bl = this.zza.zzu();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setTag(@Nullable Object tag) {
        RuntimeRemoteException runtimeRemoteException;
        try {
            zzad this_ = ((Polyline)((Object)this_)).zza;
        }
        catch (RemoteException remoteException) {
            runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        {
            this_.zzD(ObjectWrapper.wrap((Object)runtimeRemoteException));
            return;
        }
    }

    @RecentlyNullable
    public Object getTag() {
        try {
            Object this_ = ((Polyline)this_).zza.zzE();
            this_ = ObjectWrapper.unwrap((IObjectWrapper)this_);
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return this_;
    }

    public boolean equals(@Nullable Object other) {
        boolean bl;
        RuntimeRemoteException runtimeRemoteException;
        if (!(other instanceof Polyline)) {
            return false;
        }
        try {
            bl = this.zza.zzr(((Polyline)((Object)runtimeRemoteException)).zza);
        }
        catch (RemoteException remoteException) {
            runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return bl;
    }

    public int hashCode() {
        int n;
        try {
            n = this.zza.zzs();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return n;
    }

    public Polyline(zzad zzad2) {
        this.zza = (zzad)Preconditions.checkNotNull((Object)zzad2);
    }
}

