/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PatternItem;
import com.google.android.gms.maps.model.zzl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="PolygonOptionsCreator")
public final class PolygonOptions
extends AbstractSafeParcelable {
    @RecentlyNonNull
    public static final Parcelable.Creator<PolygonOptions> CREATOR;
    @SafeParcelable.Field(id=2, getter="getPoints")
    private final List<LatLng> zza;
    @SafeParcelable.Field(id=3, getter="getHolesForParcel", type="java.util.List")
    private final List<List<LatLng>> zzb;
    @SafeParcelable.Field(id=4, getter="getStrokeWidth")
    private float zzc;
    @SafeParcelable.Field(id=5, getter="getStrokeColor")
    private int zzd;
    @SafeParcelable.Field(id=6, getter="getFillColor")
    private int zze;
    @SafeParcelable.Field(id=7, getter="getZIndex")
    private float zzf;
    @SafeParcelable.Field(id=8, getter="isVisible")
    private boolean zzg;
    @SafeParcelable.Field(id=9, getter="isGeodesic")
    private boolean zzh;
    @SafeParcelable.Field(id=10, getter="isClickable")
    private boolean zzi;
    @SafeParcelable.Field(id=11, getter="getStrokeJointType")
    private int zzj;
    @Nullable
    @SafeParcelable.Field(id=12, getter="getStrokePattern")
    private List<PatternItem> zzk;

    public PolygonOptions() {
        this.zzc = 10.0f;
        this.zzd = -16777216;
        this.zze = 0;
        this.zzf = 0.0f;
        this.zzg = true;
        this.zzh = false;
        this.zzi = false;
        this.zzj = 0;
        this.zzk = null;
        ArrayList<List<LatLng>> arrayList = new ArrayList<List<LatLng>>();
        this.zza = arrayList;
        arrayList = new ArrayList<List<LatLng>>();
        this.zzb = arrayList;
    }

    @SafeParcelable.Constructor
    PolygonOptions(@SafeParcelable.Param(id=2) List<LatLng> list, @SafeParcelable.Param(id=3) List list2, @SafeParcelable.Param(id=4) float f, @SafeParcelable.Param(id=5) int n, @SafeParcelable.Param(id=6) int n2, @SafeParcelable.Param(id=7) float f2, @SafeParcelable.Param(id=8) boolean bl, @SafeParcelable.Param(id=9) boolean bl2, @SafeParcelable.Param(id=10) boolean bl3, @SafeParcelable.Param(id=11) int n3, @SafeParcelable.Param(id=12) @Nullable List<PatternItem> list3) {
        this.zza = list;
        this.zzb = list2;
        this.zzc = f;
        this.zzd = n;
        this.zze = n2;
        this.zzf = f2;
        this.zzg = bl;
        this.zzh = bl2;
        this.zzi = bl3;
        this.zzj = n3;
        this.zzk = list3;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@RecentlyNonNull Parcel out, int n) {
        void var1_1;
        n = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeTypedList((Parcel)var1_1, (int)2, this.getPoints(), (boolean)false);
        SafeParcelWriter.writeList((Parcel)var1_1, (int)3, this.zzb, (boolean)false);
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)4, (float)this.getStrokeWidth());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)5, (int)this.getStrokeColor());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)6, (int)this.getFillColor());
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)7, (float)this.getZIndex());
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)8, (boolean)this.isVisible());
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)9, (boolean)this.isGeodesic());
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)10, (boolean)this.isClickable());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)11, (int)this.getStrokeJointType());
        SafeParcelWriter.writeTypedList((Parcel)var1_1, (int)12, this.getStrokePattern(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public PolygonOptions add(@RecentlyNonNull LatLng point) {
        void var1_1;
        Preconditions.checkNotNull((Object)((Object)point), (Object)"point must not be null.");
        this.zza.add((LatLng)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public PolygonOptions add(LatLng ... points) {
        void var1_1;
        Preconditions.checkNotNull((Object)points, (Object)"points must not be null.");
        this.zza.addAll(Arrays.asList(var1_1));
        return this;
    }

    @RecentlyNonNull
    public PolygonOptions addAll(@RecentlyNonNull Iterable<LatLng> points) {
        Iterator iterator;
        Preconditions.checkNotNull(points, (Object)"points must not be null.");
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            object = (LatLng)((Object)object);
            this.zza.add((LatLng)((Object)object));
        }
        return this;
    }

    @RecentlyNonNull
    public PolygonOptions addHole(@RecentlyNonNull Iterable<LatLng> points) {
        Iterator iterator;
        Preconditions.checkNotNull(points, (Object)"points must not be null.");
        ArrayList<LatLng> arrayList = new ArrayList<LatLng>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            arrayList.add((LatLng)((Object)iterator.next()));
        }
        this.zzb.add(arrayList);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public PolygonOptions strokeWidth(float width) {
        void var1_1;
        this.zzc = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public PolygonOptions strokeColor(int color) {
        void var1_1;
        this.zzd = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public PolygonOptions strokeJointType(int jointType) {
        void var1_1;
        this.zzj = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public PolygonOptions strokePattern(@Nullable List<PatternItem> pattern) {
        void var1_1;
        this.zzk = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public PolygonOptions fillColor(int color) {
        void var1_1;
        this.zze = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public PolygonOptions zIndex(float zIndex) {
        void var1_1;
        this.zzf = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public PolygonOptions visible(boolean visible) {
        void var1_1;
        this.zzg = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public PolygonOptions geodesic(boolean geodesic) {
        void var1_1;
        this.zzh = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public PolygonOptions clickable(boolean clickable) {
        void var1_1;
        this.zzi = var1_1;
        return this;
    }

    @RecentlyNonNull
    public List<LatLng> getPoints() {
        return this.zza;
    }

    @RecentlyNonNull
    public List<List<LatLng>> getHoles() {
        return this.zzb;
    }

    public float getStrokeWidth() {
        return this.zzc;
    }

    public int getStrokeColor() {
        return this.zzd;
    }

    public int getStrokeJointType() {
        return this.zzj;
    }

    @RecentlyNullable
    public List<PatternItem> getStrokePattern() {
        return this.zzk;
    }

    public int getFillColor() {
        return this.zze;
    }

    public float getZIndex() {
        return this.zzf;
    }

    public boolean isVisible() {
        return this.zzg;
    }

    public boolean isGeodesic() {
        return this.zzh;
    }

    public boolean isClickable() {
        return this.zzi;
    }

    static {
        zzl zzl2;
        CREATOR = zzl2 = new zzl();
    }
}

