/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.RemoteException;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.maps.zzaa;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PatternItem;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import java.util.List;

public final class Polygon {
    private final zzaa zza;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove() {
        try {
            this.zza.zzd();
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    @RecentlyNonNull
    public String getId() {
        try {
            String this_ = ((Polygon)((Object)this_)).zza.zze();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return this_;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setPoints(@RecentlyNonNull List<LatLng> points) {
        RuntimeRemoteException runtimeRemoteException;
        String string;
        try {
            string = "points must not be null.";
        }
        catch (RemoteException remoteException) {
            runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        {
            Preconditions.checkNotNull((Object)runtimeRemoteException, (Object)string);
            this.zza.zzf((List<LatLng>)((Object)runtimeRemoteException));
            return;
        }
    }

    @RecentlyNonNull
    public List<LatLng> getPoints() {
        try {
            List<LatLng> this_ = ((Polygon)((Object)this_)).zza.zzg();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return this_;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setHoles(@RecentlyNonNull List<? extends List<LatLng>> holes) {
        RuntimeRemoteException runtimeRemoteException;
        try {
            this.zza.zzh((List)((Object)runtimeRemoteException));
            return;
        }
        catch (RemoteException remoteException) {
            runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    @RecentlyNonNull
    public List<List<LatLng>> getHoles() {
        try {
            List this_ = ((Polygon)((Object)this_)).zza.zzi();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return this_;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setStrokeWidth(float width) {
        try {
            void var1_2;
            this.zza.zzj((float)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    public float getStrokeWidth() {
        float f;
        try {
            f = this.zza.zzk();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return f;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setStrokeColor(int color) {
        try {
            void var1_2;
            this.zza.zzl((int)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    public int getStrokeColor() {
        int n;
        try {
            n = this.zza.zzm();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setStrokeJointType(int jointType) {
        try {
            void var1_2;
            this.zza.zzz((int)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    public int getStrokeJointType() {
        int n;
        try {
            n = this.zza.zzA();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setStrokePattern(@Nullable List<PatternItem> pattern) {
        RuntimeRemoteException runtimeRemoteException;
        try {
            this.zza.zzB((List<PatternItem>)((Object)runtimeRemoteException));
            return;
        }
        catch (RemoteException remoteException) {
            runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    @RecentlyNullable
    public List<PatternItem> getStrokePattern() {
        try {
            List<PatternItem> this_ = ((Polygon)((Object)this_)).zza.zzC();
            this_ = PatternItem.zza(this_);
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return this_;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setFillColor(int color) {
        try {
            void var1_2;
            this.zza.zzn((int)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    public int getFillColor() {
        int n;
        try {
            n = this.zza.zzo();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setZIndex(float zIndex) {
        try {
            void var1_2;
            this.zza.zzp((float)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    public float getZIndex() {
        float f;
        try {
            f = this.zza.zzq();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return f;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setVisible(boolean visible) {
        try {
            void var1_2;
            this.zza.zzr((boolean)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    public boolean isVisible() {
        boolean bl;
        try {
            bl = this.zza.zzs();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setGeodesic(boolean geodesic) {
        try {
            void var1_2;
            this.zza.zzt((boolean)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    public boolean isGeodesic() {
        boolean bl;
        try {
            bl = this.zza.zzu();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setClickable(boolean clickable) {
        try {
            void var1_2;
            this.zza.zzx((boolean)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    public boolean isClickable() {
        boolean bl;
        try {
            bl = this.zza.zzy();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setTag(@Nullable Object tag) {
        RuntimeRemoteException runtimeRemoteException;
        try {
            zzaa this_ = ((Polygon)((Object)this_)).zza;
        }
        catch (RemoteException remoteException) {
            runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        {
            this_.zzD(ObjectWrapper.wrap((Object)runtimeRemoteException));
            return;
        }
    }

    @RecentlyNullable
    public Object getTag() {
        try {
            Object this_ = ((Polygon)this_).zza.zzE();
            this_ = ObjectWrapper.unwrap((IObjectWrapper)this_);
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return this_;
    }

    public boolean equals(@Nullable Object other) {
        boolean bl;
        RuntimeRemoteException runtimeRemoteException;
        if (!(other instanceof Polygon)) {
            return false;
        }
        try {
            bl = this.zza.zzv(((Polygon)((Object)runtimeRemoteException)).zza);
        }
        catch (RemoteException remoteException) {
            runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return bl;
    }

    public int hashCode() {
        int n;
        try {
            n = this.zza.zzw();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return n;
    }

    public Polygon(zzaa zzaa2) {
        this.zza = (zzaa)Preconditions.checkNotNull((Object)zzaa2);
    }
}

