/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.RemoteException;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.maps.zzo;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.RuntimeRemoteException;

public final class GroundOverlay {
    private final zzo zza;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove() {
        try {
            this.zza.zzd();
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    @RecentlyNonNull
    public String getId() {
        try {
            String this_ = ((GroundOverlay)((Object)this_)).zza.zze();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return this_;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setPosition(@RecentlyNonNull LatLng latLng) {
        RuntimeRemoteException runtimeRemoteException;
        try {
            this.zza.zzf((LatLng)((Object)runtimeRemoteException));
            return;
        }
        catch (RemoteException remoteException) {
            runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    @RecentlyNonNull
    public LatLng getPosition() {
        try {
            Object this_ = this_.zza.zzg();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return this_;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setImage(@RecentlyNonNull BitmapDescriptor imageDescriptor) {
        Object object;
        Preconditions.checkNotNull((Object)imageDescriptor, (Object)"imageDescriptor must not be null");
        try {
            object = object.zza();
            this.zza.zzx((IObjectWrapper)object);
            return;
        }
        catch (RemoteException remoteException) {
            object = new RuntimeRemoteException(remoteException);
            throw object;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setDimensions(float width) {
        try {
            void var1_2;
            this.zza.zzh((float)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setDimensions(float width, float height) {
        try {
            void var2_4;
            void var1_2;
            this.zza.zzi((float)var1_2, (float)var2_4);
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    public float getWidth() {
        float f;
        try {
            f = this.zza.zzj();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return f;
    }

    public float getHeight() {
        float f;
        try {
            f = this.zza.zzk();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return f;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setPositionFromBounds(@RecentlyNonNull LatLngBounds bounds) {
        RuntimeRemoteException runtimeRemoteException;
        try {
            this.zza.zzl((LatLngBounds)((Object)runtimeRemoteException));
            return;
        }
        catch (RemoteException remoteException) {
            runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    @RecentlyNonNull
    public LatLngBounds getBounds() {
        try {
            Object this_ = this_.zza.zzm();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return this_;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setBearing(float bearing) {
        try {
            void var1_2;
            this.zza.zzn((float)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    public float getBearing() {
        float f;
        try {
            f = this.zza.zzo();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return f;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setZIndex(float zIndex) {
        try {
            void var1_2;
            this.zza.zzp((float)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    public float getZIndex() {
        float f;
        try {
            f = this.zza.zzq();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return f;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setVisible(boolean visible) {
        try {
            void var1_2;
            this.zza.zzr((boolean)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    public boolean isVisible() {
        boolean bl;
        try {
            bl = this.zza.zzs();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setClickable(boolean clickable) {
        try {
            void var1_2;
            this.zza.zzy((boolean)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    public boolean isClickable() {
        boolean bl;
        try {
            bl = this.zza.zzz();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setTransparency(float transparency) {
        try {
            void var1_2;
            this.zza.zzt((float)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    public float getTransparency() {
        float f;
        try {
            f = this.zza.zzu();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return f;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setTag(@Nullable Object tag) {
        RuntimeRemoteException runtimeRemoteException;
        try {
            zzo this_ = ((GroundOverlay)((Object)this_)).zza;
        }
        catch (RemoteException remoteException) {
            runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        {
            this_.zzA(ObjectWrapper.wrap((Object)runtimeRemoteException));
            return;
        }
    }

    @RecentlyNullable
    public Object getTag() {
        try {
            Object this_ = ((GroundOverlay)this_).zza.zzB();
            this_ = ObjectWrapper.unwrap((IObjectWrapper)this_);
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return this_;
    }

    public boolean equals(@Nullable Object other) {
        boolean bl;
        RuntimeRemoteException runtimeRemoteException;
        if (!(other instanceof GroundOverlay)) {
            return false;
        }
        try {
            bl = this.zza.zzv(((GroundOverlay)((Object)runtimeRemoteException)).zza);
        }
        catch (RemoteException remoteException) {
            runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return bl;
    }

    public int hashCode() {
        int n;
        try {
            n = this.zza.zzw();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return n;
    }

    public GroundOverlay(zzo zzo2) {
        this.zza = (zzo)Preconditions.checkNotNull((Object)zzo2);
    }
}

