/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.ButtCap;
import com.google.android.gms.maps.model.CustomCap;
import com.google.android.gms.maps.model.RoundCap;
import com.google.android.gms.maps.model.SquareCap;
import com.google.android.gms.maps.model.zzb;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="CapCreator")
public class Cap
extends AbstractSafeParcelable {
    @RecentlyNonNull
    public static final Parcelable.Creator<Cap> CREATOR;
    private static final String zza;
    @SafeParcelable.Field(id=2, getter="getType")
    private final int zzb;
    @SafeParcelable.Field(id=3, getter="getWrappedBitmapDescriptorImplBinder", type="android.os.IBinder")
    @Nullable
    private final BitmapDescriptor zzc;
    @SafeParcelable.Field(id=4, getter="getBitmapRefWidth")
    @Nullable
    private final Float zzd;

    /*
     * Enabled aggressive block sorting
     */
    private Cap(int n, @Nullable BitmapDescriptor bitmapDescriptor, @Nullable Float f) {
        boolean bl;
        block4: {
            block5: {
                bl = f != null ? f.floatValue() > 0.0f : false;
                if (n != 3) break block5;
                if (bitmapDescriptor != null) {
                    if (bl) {
                        n = 3;
                        bl = true;
                        break block4;
                    } else {
                        n = 3;
                        bl = false;
                    }
                    break block4;
                } else {
                    n = 3;
                    bl = false;
                }
                break block4;
            }
            bl = true;
        }
        Object[] objectArray = new Object[]{n, bitmapDescriptor, f};
        Preconditions.checkArgument((boolean)bl, (Object)String.format("Invalid Cap: type=%s bitmapDescriptor=%s bitmapRefWidth=%s", objectArray));
        this.zzb = n;
        this.zzc = bitmapDescriptor;
        this.zzd = f;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @SafeParcelable.Constructor
    Cap(@SafeParcelable.Param(id=2) int n, @SafeParcelable.Param(id=3) @Nullable IBinder object, @SafeParcelable.Param(id=4) @Nullable Float f) {
        void var3_7;
        void var2_4;
        if (object == null) {
            Object var2_3 = null;
        } else {
            BitmapDescriptor bitmapDescriptor;
            IObjectWrapper iObjectWrapper = IObjectWrapper.Stub.asInterface((IBinder)object);
            BitmapDescriptor bitmapDescriptor2 = bitmapDescriptor = new BitmapDescriptor(iObjectWrapper);
        }
        this(n, (BitmapDescriptor)var2_4, (Float)var3_7);
    }

    /*
     * WARNING - void declaration
     */
    protected Cap(@RecentlyNonNull BitmapDescriptor bitmapDescriptor, float bitmapRefWidth) {
        this(3, (BitmapDescriptor)var1_1, Float.valueOf((float)var2_2));
        void var2_2;
        void var1_1;
    }

    protected Cap(int n) {
        this(n, (BitmapDescriptor)null, (Float)null);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void writeToParcel(@RecentlyNonNull Parcel out, int n) {
        void var1_1;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)2, (int)this.zzb);
        BitmapDescriptor bitmapDescriptor = this.zzc;
        bitmapDescriptor = bitmapDescriptor == null ? null : bitmapDescriptor.zza().asBinder();
        SafeParcelWriter.writeIBinder((Parcel)var1_1, (int)3, (IBinder)bitmapDescriptor, (boolean)false);
        SafeParcelWriter.writeFloatObject((Parcel)var1_1, (int)4, (Float)this.zzd, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n2);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.zzb, this.zzc, this.zzd};
        return Objects.hashCode((Object[])objectArray);
    }

    public boolean equals(@Nullable Object o) {
        Cap cap;
        if (this == cap) {
            return true;
        }
        if (!(cap instanceof Cap)) {
            return false;
        }
        cap = cap;
        return this.zzb == cap.zzb && Objects.equal((Object)this.zzc, (Object)cap.zzc) && Objects.equal((Object)this.zzd, (Object)cap.zzd);
    }

    @RecentlyNonNull
    public String toString() {
        int n = this.zzb;
        StringBuilder stringBuilder = new StringBuilder(23);
        stringBuilder.append("[Cap: type=");
        stringBuilder.append(n);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    static {
        zzb zzb2;
        zza = Cap.class.getSimpleName();
        CREATOR = zzb2 = new zzb();
    }

    /*
     * Enabled aggressive block sorting
     */
    final Cap zza() {
        switch (this.zzb) {
            case 3: {
                boolean bl = this.zzc != null;
                Preconditions.checkState((boolean)bl, (Object)"bitmapDescriptor must not be null");
                bl = this.zzd != null;
                Preconditions.checkState((boolean)bl, (Object)"bitmapRefWidth must not be null");
                return new CustomCap(this.zzc, this.zzd.floatValue());
            }
            default: {
                String string = zza;
                int n = this.zzb;
                StringBuilder stringBuilder = new StringBuilder(29);
                stringBuilder.append("Unknown Cap type: ");
                stringBuilder.append(n);
                Log.w((String)string, (String)stringBuilder.toString());
                return this;
            }
            case 2: {
                return new RoundCap();
            }
            case 1: {
                return new SquareCap();
            }
            case 0: 
        }
        return new ButtCap();
    }
}

