/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.graphics.Point;
import android.os.RemoteException;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.maps.internal.IProjectionDelegate;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import com.google.android.gms.maps.model.VisibleRegion;

public final class Projection {
    private final IProjectionDelegate zza;

    Projection(IProjectionDelegate iProjectionDelegate) {
        this.zza = iProjectionDelegate;
    }

    @RecentlyNonNull
    public LatLng fromScreenLocation(@RecentlyNonNull Point point) {
        RuntimeRemoteException runtimeRemoteException;
        Preconditions.checkNotNull((Object)point);
        try {
            Object object = ((Projection)object).zza;
            object = object.fromScreenLocation(ObjectWrapper.wrap((Object)runtimeRemoteException));
        }
        catch (RemoteException remoteException) {
            runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return object;
    }

    @RecentlyNonNull
    public Point toScreenLocation(@RecentlyNonNull LatLng location) {
        RuntimeRemoteException runtimeRemoteException;
        Preconditions.checkNotNull((Object)((Object)location));
        try {
            Projection projection = projection.zza.toScreenLocation((LatLng)((Object)runtimeRemoteException));
            projection = (Point)ObjectWrapper.unwrap((IObjectWrapper)projection);
        }
        catch (RemoteException remoteException) {
            runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return projection;
    }

    @RecentlyNonNull
    public VisibleRegion getVisibleRegion() {
        try {
            Object this_ = this_.zza.getVisibleRegion();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return this_;
    }
}

