/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.StrictMode;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.zzad;
import com.google.android.gms.maps.zzae;

@TargetApi(value=11)
public class MapFragment
extends Fragment {
    private final zzae zza;

    @RecentlyNonNull
    public static MapFragment newInstance() {
        MapFragment mapFragment = new MapFragment();
        return mapFragment;
    }

    @RecentlyNonNull
    public static MapFragment newInstance(@Nullable GoogleMapOptions options) {
        GoogleMapOptions googleMapOptions;
        MapFragment mapFragment = new MapFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("MapOptions", (Parcelable)googleMapOptions);
        mapFragment.setArguments(bundle);
        return mapFragment;
    }

    public MapFragment() {
        zzae zzae2;
        this.zza = zzae2 = new zzae(this);
    }

    /*
     * WARNING - void declaration
     */
    public void onAttach(@RecentlyNonNull Activity activity) {
        void var1_1;
        super.onAttach((Activity)var1_1);
        zzae.zzc(this.zza, (Activity)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"NewApi"})
    public void onInflate(@RecentlyNonNull Activity activity, @RecentlyNonNull AttributeSet attrs, @Nullable Bundle savedInstanceState) {
        StrictMode.ThreadPolicy threadPolicy = StrictMode.getThreadPolicy();
        Object object = new StrictMode.ThreadPolicy.Builder(threadPolicy);
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)object.permitAll().build());
        try {
            void var3_4;
            GoogleMapOptions googleMapOptions;
            void var1_2;
            super.onInflate((Activity)var1_2, (AttributeSet)googleMapOptions, (Bundle)var3_4);
            object = this.zza;
            zzae.zzc((zzae)((Object)object), (Activity)var1_2);
            googleMapOptions = GoogleMapOptions.createFromAttributes((Context)var1_2, (AttributeSet)googleMapOptions);
            object = new Bundle();
            object.putParcelable("MapOptions", (Parcelable)googleMapOptions);
            this.zza.onInflate((Activity)var1_2, (Bundle)object, (Bundle)var3_4);
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onCreate(@Nullable Bundle savedInstanceState) {
        void var1_1;
        super.onCreate((Bundle)var1_1);
        this.zza.onCreate((Bundle)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public View onCreateView(@RecentlyNonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        void var3_3;
        void var2_2;
        void var1_1;
        MapFragment this_ = this_.zza.onCreateView((LayoutInflater)var1_1, (ViewGroup)var2_2, (Bundle)var3_3);
        this_.setClickable(true);
        return this_;
    }

    public void onResume() {
        super.onResume();
        this.zza.onResume();
    }

    public void onPause() {
        this.zza.onPause();
        super.onPause();
    }

    public void onStart() {
        super.onStart();
        this.zza.onStart();
    }

    public void onStop() {
        this.zza.onStop();
        super.onStop();
    }

    public void onDestroyView() {
        this.zza.onDestroyView();
        super.onDestroyView();
    }

    public void onDestroy() {
        this.zza.onDestroy();
        super.onDestroy();
    }

    public void onLowMemory() {
        this.zza.onLowMemory();
        super.onLowMemory();
    }

    /*
     * WARNING - void declaration
     */
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        void var1_1;
        ClassLoader classLoader = MapFragment.class.getClassLoader();
        if (var1_1 != null && classLoader != null) {
            var1_1.setClassLoader(classLoader);
        }
        super.onActivityCreated((Bundle)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void onSaveInstanceState(@RecentlyNonNull Bundle outState) {
        void var1_1;
        ClassLoader classLoader = MapFragment.class.getClassLoader();
        if (var1_1 != null && classLoader != null) {
            var1_1.setClassLoader(classLoader);
        }
        super.onSaveInstanceState((Bundle)var1_1);
        this.zza.onSaveInstanceState((Bundle)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void onEnterAmbient(@Nullable Bundle ambientDetails) {
        Preconditions.checkMainThread((String)"onEnterAmbient must be called on the main thread.");
        Object object = object.zza;
        if (object.getDelegate() != null) {
            void var1_1;
            ((zzad)object.getDelegate()).zza((Bundle)var1_1);
            return;
        }
    }

    public final void onExitAmbient() {
        Preconditions.checkMainThread((String)"onExitAmbient must be called on the main thread.");
        Object object = object.zza;
        if (object.getDelegate() != null) {
            ((zzad)object.getDelegate()).zzb();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void getMapAsync(@RecentlyNonNull OnMapReadyCallback callback) {
        void var1_1;
        Preconditions.checkMainThread((String)"getMapAsync must be called on the main thread.");
        Preconditions.checkNotNull((Object)var1_1, (Object)"callback must not be null.");
        this.zza.zzb((OnMapReadyCallback)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setArguments(@Nullable Bundle args) {
        void var1_1;
        super.setArguments((Bundle)var1_1);
    }
}

