/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.graphics.Bitmap;
import android.location.Location;
import android.os.RemoteException;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.maps.zzag;
import com.google.android.gms.maps.CameraUpdate;
import com.google.android.gms.maps.LocationSource;
import com.google.android.gms.maps.Projection;
import com.google.android.gms.maps.UiSettings;
import com.google.android.gms.maps.internal.IGoogleMapDelegate;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.Circle;
import com.google.android.gms.maps.model.CircleOptions;
import com.google.android.gms.maps.model.GroundOverlay;
import com.google.android.gms.maps.model.GroundOverlayOptions;
import com.google.android.gms.maps.model.IndoorBuilding;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.MapStyleOptions;
import com.google.android.gms.maps.model.Marker;
import com.google.android.gms.maps.model.MarkerOptions;
import com.google.android.gms.maps.model.PointOfInterest;
import com.google.android.gms.maps.model.Polygon;
import com.google.android.gms.maps.model.PolygonOptions;
import com.google.android.gms.maps.model.Polyline;
import com.google.android.gms.maps.model.PolylineOptions;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import com.google.android.gms.maps.model.TileOverlay;
import com.google.android.gms.maps.model.TileOverlayOptions;
import com.google.android.gms.maps.zza;
import com.google.android.gms.maps.zzaa;
import com.google.android.gms.maps.zzb;
import com.google.android.gms.maps.zzc;
import com.google.android.gms.maps.zzd;
import com.google.android.gms.maps.zze;
import com.google.android.gms.maps.zzf;
import com.google.android.gms.maps.zzg;
import com.google.android.gms.maps.zzh;
import com.google.android.gms.maps.zzi;
import com.google.android.gms.maps.zzj;
import com.google.android.gms.maps.zzk;
import com.google.android.gms.maps.zzm;
import com.google.android.gms.maps.zzn;
import com.google.android.gms.maps.zzo;
import com.google.android.gms.maps.zzp;
import com.google.android.gms.maps.zzq;
import com.google.android.gms.maps.zzr;
import com.google.android.gms.maps.zzs;
import com.google.android.gms.maps.zzt;
import com.google.android.gms.maps.zzu;
import com.google.android.gms.maps.zzv;
import com.google.android.gms.maps.zzw;
import com.google.android.gms.maps.zzx;
import com.google.android.gms.maps.zzy;
import com.google.android.gms.maps.zzz;

public class GoogleMap {
    public static final int MAP_TYPE_NONE = 0;
    public static final int MAP_TYPE_NORMAL = 1;
    public static final int MAP_TYPE_SATELLITE = 2;
    public static final int MAP_TYPE_TERRAIN = 3;
    public static final int MAP_TYPE_HYBRID = 4;
    private final IGoogleMapDelegate zza;
    private UiSettings zzb;

    public GoogleMap(@RecentlyNonNull IGoogleMapDelegate iGoogleMapDelegate) {
        this.zza = (IGoogleMapDelegate)Preconditions.checkNotNull((Object)iGoogleMapDelegate);
    }

    @RecentlyNonNull
    public final CameraPosition getCameraPosition() {
        try {
            Object this_ = this_.zza.getCameraPosition();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return this_;
    }

    public final float getMaxZoomLevel() {
        float f;
        try {
            f = this.zza.getMaxZoomLevel();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return f;
    }

    public final float getMinZoomLevel() {
        float f;
        try {
            f = this.zza.getMinZoomLevel();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return f;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void moveCamera(@RecentlyNonNull CameraUpdate update) {
        RuntimeRemoteException runtimeRemoteException;
        String string;
        try {
            string = "CameraUpdate must not be null.";
        }
        catch (RemoteException remoteException) {
            runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        {
            Preconditions.checkNotNull((Object)runtimeRemoteException, (Object)string);
            this.zza.moveCamera(((CameraUpdate)((Object)runtimeRemoteException)).zza());
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void animateCamera(@RecentlyNonNull CameraUpdate update) {
        RuntimeRemoteException runtimeRemoteException;
        String string;
        try {
            string = "CameraUpdate must not be null.";
        }
        catch (RemoteException remoteException) {
            runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        {
            Preconditions.checkNotNull((Object)runtimeRemoteException, (Object)string);
            this.zza.animateCamera(((CameraUpdate)((Object)runtimeRemoteException)).zza());
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void animateCamera(@RecentlyNonNull CameraUpdate update, @Nullable CancelableCallback callback) {
        RuntimeRemoteException runtimeRemoteException;
        try {
            void var2_3;
            Object object = "CameraUpdate must not be null.";
            Preconditions.checkNotNull((Object)runtimeRemoteException, (Object)object);
            object = ((GoogleMap)object2).zza;
            runtimeRemoteException = ((CameraUpdate)((Object)runtimeRemoteException)).zza();
            Object object2 = var2_3 == null ? null : new zzaa((CancelableCallback)var2_3);
            object.animateCameraWithCallback((IObjectWrapper)runtimeRemoteException, (com.google.android.gms.maps.internal.zzd)object2);
            return;
        }
        catch (RemoteException remoteException) {
            runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void animateCamera(@RecentlyNonNull CameraUpdate update, int durationMs, @Nullable CancelableCallback callback) {
        RuntimeRemoteException runtimeRemoteException;
        try {
            void var2_3;
            void var3_4;
            Object object = "CameraUpdate must not be null.";
            Preconditions.checkNotNull((Object)runtimeRemoteException, (Object)object);
            object = ((GoogleMap)object2).zza;
            runtimeRemoteException = ((CameraUpdate)((Object)runtimeRemoteException)).zza();
            Object object2 = var3_4 == null ? null : new zzaa((CancelableCallback)var3_4);
            object.animateCameraWithDurationAndCallback((IObjectWrapper)runtimeRemoteException, (int)var2_3, (com.google.android.gms.maps.internal.zzd)object2);
            return;
        }
        catch (RemoteException remoteException) {
            runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void stopAnimation() {
        try {
            this.zza.stopAnimation();
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    @RecentlyNonNull
    public final Polyline addPolyline(@RecentlyNonNull PolylineOptions options) {
        RuntimeRemoteException runtimeRemoteException;
        Object object;
        try {
            object = "PolylineOptions must not be null";
            Preconditions.checkNotNull((Object)runtimeRemoteException, (Object)object);
            object = new Polyline(this.zza.addPolyline((PolylineOptions)((Object)runtimeRemoteException)));
        }
        catch (RemoteException remoteException) {
            runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return object;
    }

    @RecentlyNonNull
    public final Polygon addPolygon(@RecentlyNonNull PolygonOptions options) {
        RuntimeRemoteException runtimeRemoteException;
        Object object;
        try {
            object = "PolygonOptions must not be null";
            Preconditions.checkNotNull((Object)runtimeRemoteException, (Object)object);
            object = new Polygon(this.zza.addPolygon((PolygonOptions)((Object)runtimeRemoteException)));
        }
        catch (RemoteException remoteException) {
            runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return object;
    }

    @RecentlyNonNull
    public final Circle addCircle(@RecentlyNonNull CircleOptions options) {
        RuntimeRemoteException runtimeRemoteException;
        Object object;
        try {
            object = "CircleOptions must not be null.";
            Preconditions.checkNotNull((Object)runtimeRemoteException, (Object)object);
            object = new Circle(this.zza.addCircle((CircleOptions)((Object)runtimeRemoteException)));
        }
        catch (RemoteException remoteException) {
            runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return object;
    }

    @RecentlyNullable
    public final Marker addMarker(@RecentlyNonNull MarkerOptions options) {
        block3: {
            Object object;
            try {
                String string = "MarkerOptions must not be null.";
                Preconditions.checkNotNull((Object)object, (Object)string);
                com.google.android.gms.internal.maps.zzx zzx2 = ((GoogleMap)((Object)zzx2)).zza.addMarker((MarkerOptions)((Object)object));
                if (zzx2 == null) break block3;
            }
            catch (RemoteException remoteException) {
                object = new RuntimeRemoteException(remoteException);
                throw object;
            }
            object = new Marker(zzx2);
            return object;
        }
        return null;
    }

    @RecentlyNullable
    public final GroundOverlay addGroundOverlay(@RecentlyNonNull GroundOverlayOptions options) {
        block3: {
            Object object;
            try {
                String string = "GroundOverlayOptions must not be null.";
                Preconditions.checkNotNull((Object)object, (Object)string);
                com.google.android.gms.internal.maps.zzo zzo2 = ((GoogleMap)((Object)zzo2)).zza.addGroundOverlay((GroundOverlayOptions)((Object)object));
                if (zzo2 == null) break block3;
            }
            catch (RemoteException remoteException) {
                object = new RuntimeRemoteException(remoteException);
                throw object;
            }
            object = new GroundOverlay(zzo2);
            return object;
        }
        return null;
    }

    @RecentlyNullable
    public final TileOverlay addTileOverlay(@RecentlyNonNull TileOverlayOptions options) {
        block3: {
            Object object;
            try {
                String string = "TileOverlayOptions must not be null.";
                Preconditions.checkNotNull((Object)object, (Object)string);
                zzag zzag2 = ((GoogleMap)((Object)zzag2)).zza.addTileOverlay((TileOverlayOptions)((Object)object));
                if (zzag2 == null) break block3;
            }
            catch (RemoteException remoteException) {
                object = new RuntimeRemoteException(remoteException);
                throw object;
            }
            object = new TileOverlay(zzag2);
            return object;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void clear() {
        try {
            this.zza.clear();
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    @RecentlyNullable
    public IndoorBuilding getFocusedBuilding() {
        block3: {
            try {
                com.google.android.gms.internal.maps.zzr this_ = ((GoogleMap)((Object)this_)).zza.getFocusedBuilding();
                if (this_ == null) break block3;
            }
            catch (RemoteException remoteException) {
                RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
                throw runtimeRemoteException;
            }
            IndoorBuilding indoorBuilding = new IndoorBuilding(this_);
            return indoorBuilding;
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setOnIndoorStateChangeListener(@Nullable OnIndoorStateChangeListener listener) {
        if (listener != null) ** GOTO lbl5
        try {
            this.zza.setOnIndoorStateChangeListener(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            var1_2 = new RuntimeRemoteException(var0_1);
            throw var1_2;
        }
        {
            var3_4 = new zzk(this, (OnIndoorStateChangeListener)var1_2);
            var2_3.setOnIndoorStateChangeListener(var3_4);
            return;
        }
    }

    public final int getMapType() {
        int n;
        try {
            n = this.zza.getMapType();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setMapType(int type) {
        try {
            void var1_2;
            this.zza.setMapType((int)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    public final boolean isTrafficEnabled() {
        boolean bl;
        try {
            bl = this.zza.isTrafficEnabled();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setTrafficEnabled(boolean enabled) {
        try {
            void var1_2;
            this.zza.setTrafficEnabled((boolean)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    public final boolean isIndoorEnabled() {
        boolean bl;
        try {
            bl = this.zza.isIndoorEnabled();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean setIndoorEnabled(boolean enabled) {
        boolean bl;
        try {
            void var1_3;
            bl = this.zza.setIndoorEnabled((boolean)var1_3);
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return bl;
    }

    public final boolean isBuildingsEnabled() {
        boolean bl;
        try {
            bl = this.zza.isBuildingsEnabled();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setBuildingsEnabled(boolean enabled) {
        try {
            void var1_2;
            this.zza.setBuildingsEnabled((boolean)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    public final boolean isMyLocationEnabled() {
        boolean bl;
        try {
            bl = this.zza.isMyLocationEnabled();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public final void setMyLocationEnabled(boolean enabled) {
        try {
            void var1_2;
            this.zza.setMyLocationEnabled((boolean)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    @Deprecated
    @RecentlyNonNull
    public final Location getMyLocation() {
        try {
            GoogleMap this_ = this_.zza.getMyLocation();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return this_;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setLocationSource(@Nullable LocationSource source) {
        if (source != null) ** GOTO lbl5
        try {
            this.zza.setLocationSource(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            var1_2 = new RuntimeRemoteException(var0_1);
            throw var1_2;
        }
        {
            var3_4 = new zzs(this, (LocationSource)var1_2);
            var2_3.setLocationSource(var3_4);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RecentlyNonNull
    public final UiSettings getUiSettings() {
        Object object;
        try {
            object = ((GoogleMap)this).zzb;
            if (object != null) return ((GoogleMap)this).zzb;
        }
        catch (RemoteException remoteException) {
            object = new RuntimeRemoteException(remoteException);
            throw object;
        }
        ((GoogleMap)this).zzb = object = new UiSettings(((GoogleMap)this).zza.getUiSettings());
        return ((GoogleMap)this).zzb;
    }

    @RecentlyNonNull
    public final Projection getProjection() {
        Projection projection;
        try {
            projection = new Projection(this.zza.getProjection());
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return projection;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public final void setOnCameraChangeListener(@Nullable OnCameraChangeListener listener) {
        if (listener != null) ** GOTO lbl5
        try {
            this.zza.setOnCameraChangeListener(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            var1_2 = new RuntimeRemoteException(var0_1);
            throw var1_2;
        }
        {
            var3_4 = new zzt(this, (OnCameraChangeListener)var1_2);
            var2_3.setOnCameraChangeListener(var3_4);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setOnCameraMoveStartedListener(@Nullable OnCameraMoveStartedListener listener) {
        if (listener != null) ** GOTO lbl5
        try {
            this.zza.setOnCameraMoveStartedListener(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            var1_2 = new RuntimeRemoteException(var0_1);
            throw var1_2;
        }
        {
            var3_4 = new zzu(this, (OnCameraMoveStartedListener)var1_2);
            var2_3.setOnCameraMoveStartedListener(var3_4);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setOnCameraMoveListener(@Nullable OnCameraMoveListener listener) {
        if (listener != null) ** GOTO lbl5
        try {
            this.zza.setOnCameraMoveListener(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            var1_2 = new RuntimeRemoteException(var0_1);
            throw var1_2;
        }
        {
            var3_4 = new zzv(this, (OnCameraMoveListener)var1_2);
            var2_3.setOnCameraMoveListener(var3_4);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setOnCameraMoveCanceledListener(@Nullable OnCameraMoveCanceledListener listener) {
        if (listener != null) ** GOTO lbl5
        try {
            this.zza.setOnCameraMoveCanceledListener(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            var1_2 = new RuntimeRemoteException(var0_1);
            throw var1_2;
        }
        {
            var3_4 = new zzw(this, (OnCameraMoveCanceledListener)var1_2);
            var2_3.setOnCameraMoveCanceledListener(var3_4);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setOnCameraIdleListener(@Nullable OnCameraIdleListener listener) {
        if (listener != null) ** GOTO lbl5
        try {
            this.zza.setOnCameraIdleListener(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            var1_2 = new RuntimeRemoteException(var0_1);
            throw var1_2;
        }
        {
            var3_4 = new zzx(this, (OnCameraIdleListener)var1_2);
            var2_3.setOnCameraIdleListener(var3_4);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setOnMapClickListener(@Nullable OnMapClickListener listener) {
        if (listener != null) ** GOTO lbl5
        try {
            this.zza.setOnMapClickListener(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            var1_2 = new RuntimeRemoteException(var0_1);
            throw var1_2;
        }
        {
            var3_4 = new zzy(this, (OnMapClickListener)var1_2);
            var2_3.setOnMapClickListener(var3_4);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setOnMapLongClickListener(@Nullable OnMapLongClickListener listener) {
        if (listener != null) ** GOTO lbl5
        try {
            this.zza.setOnMapLongClickListener(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            var1_2 = new RuntimeRemoteException(var0_1);
            throw var1_2;
        }
        {
            var3_4 = new zzz(this, (OnMapLongClickListener)var1_2);
            var2_3.setOnMapLongClickListener(var3_4);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setOnMarkerClickListener(@Nullable OnMarkerClickListener listener) {
        if (listener != null) ** GOTO lbl5
        try {
            this.zza.setOnMarkerClickListener(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            var1_2 = new RuntimeRemoteException(var0_1);
            throw var1_2;
        }
        {
            var3_4 = new zza(this, (OnMarkerClickListener)var1_2);
            var2_3.setOnMarkerClickListener(var3_4);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setOnMarkerDragListener(@Nullable OnMarkerDragListener listener) {
        if (listener != null) ** GOTO lbl5
        try {
            this.zza.setOnMarkerDragListener(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            var1_2 = new RuntimeRemoteException(var0_1);
            throw var1_2;
        }
        {
            var3_4 = new zzb(this, (OnMarkerDragListener)var1_2);
            var2_3.setOnMarkerDragListener(var3_4);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setOnInfoWindowClickListener(@Nullable OnInfoWindowClickListener listener) {
        if (listener != null) ** GOTO lbl5
        try {
            this.zza.setOnInfoWindowClickListener(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            var1_2 = new RuntimeRemoteException(var0_1);
            throw var1_2;
        }
        {
            var3_4 = new zzc(this, (OnInfoWindowClickListener)var1_2);
            var2_3.setOnInfoWindowClickListener(var3_4);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setOnInfoWindowLongClickListener(@Nullable OnInfoWindowLongClickListener listener) {
        if (listener != null) ** GOTO lbl5
        try {
            this.zza.setOnInfoWindowLongClickListener(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            var1_2 = new RuntimeRemoteException(var0_1);
            throw var1_2;
        }
        {
            var3_4 = new zzd(this, (OnInfoWindowLongClickListener)var1_2);
            var2_3.setOnInfoWindowLongClickListener(var3_4);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setOnInfoWindowCloseListener(@Nullable OnInfoWindowCloseListener listener) {
        if (listener != null) ** GOTO lbl5
        try {
            this.zza.setOnInfoWindowCloseListener(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            var1_2 = new RuntimeRemoteException(var0_1);
            throw var1_2;
        }
        {
            var3_4 = new zze(this, (OnInfoWindowCloseListener)var1_2);
            var2_3.setOnInfoWindowCloseListener(var3_4);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setInfoWindowAdapter(@Nullable InfoWindowAdapter adapter) {
        if (adapter != null) ** GOTO lbl5
        try {
            this.zza.setInfoWindowAdapter(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            var1_2 = new RuntimeRemoteException(var0_1);
            throw var1_2;
        }
        {
            var3_4 = new zzf(this, (InfoWindowAdapter)var1_2);
            var2_3.setInfoWindowAdapter(var3_4);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public final void setOnMyLocationChangeListener(@Nullable OnMyLocationChangeListener listener) {
        if (listener != null) ** GOTO lbl5
        try {
            this.zza.setOnMyLocationChangeListener(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            var1_2 = new RuntimeRemoteException(var0_1);
            throw var1_2;
        }
        {
            var3_4 = new zzg(this, (OnMyLocationChangeListener)var1_2);
            var2_3.setOnMyLocationChangeListener(var3_4);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setOnMyLocationButtonClickListener(@Nullable OnMyLocationButtonClickListener listener) {
        if (listener != null) ** GOTO lbl5
        try {
            this.zza.setOnMyLocationButtonClickListener(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            var1_2 = new RuntimeRemoteException(var0_1);
            throw var1_2;
        }
        {
            var3_4 = new zzh(this, (OnMyLocationButtonClickListener)var1_2);
            var2_3.setOnMyLocationButtonClickListener(var3_4);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setOnMyLocationClickListener(@Nullable OnMyLocationClickListener listener) {
        if (listener != null) ** GOTO lbl5
        try {
            this.zza.setOnMyLocationClickListener(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            var1_2 = new RuntimeRemoteException(var0_1);
            throw var1_2;
        }
        {
            var3_4 = new zzi(this, (OnMyLocationClickListener)var1_2);
            var2_3.setOnMyLocationClickListener(var3_4);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setOnMapLoadedCallback(@Nullable OnMapLoadedCallback callback) {
        if (callback != null) ** GOTO lbl5
        try {
            this.zza.setOnMapLoadedCallback(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            var1_2 = new RuntimeRemoteException(var0_1);
            throw var1_2;
        }
        {
            var3_4 = new zzj(this, (OnMapLoadedCallback)var1_2);
            var2_3.setOnMapLoadedCallback(var3_4);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setOnGroundOverlayClickListener(@Nullable OnGroundOverlayClickListener listener) {
        if (listener != null) ** GOTO lbl5
        try {
            this.zza.setOnGroundOverlayClickListener(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            var1_2 = new RuntimeRemoteException(var0_1);
            throw var1_2;
        }
        {
            var3_4 = new zzm(this, (OnGroundOverlayClickListener)var1_2);
            var2_3.setOnGroundOverlayClickListener(var3_4);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setOnCircleClickListener(@Nullable OnCircleClickListener listener) {
        if (listener != null) ** GOTO lbl5
        try {
            this.zza.setOnCircleClickListener(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            var1_2 = new RuntimeRemoteException(var0_1);
            throw var1_2;
        }
        {
            var3_4 = new zzn(this, (OnCircleClickListener)var1_2);
            var2_3.setOnCircleClickListener(var3_4);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setOnPolygonClickListener(@Nullable OnPolygonClickListener listener) {
        if (listener != null) ** GOTO lbl5
        try {
            this.zza.setOnPolygonClickListener(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            var1_2 = new RuntimeRemoteException(var0_1);
            throw var1_2;
        }
        {
            var3_4 = new zzo(this, (OnPolygonClickListener)var1_2);
            var2_3.setOnPolygonClickListener(var3_4);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setOnPolylineClickListener(@Nullable OnPolylineClickListener listener) {
        if (listener != null) ** GOTO lbl5
        try {
            this.zza.setOnPolylineClickListener(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            var1_2 = new RuntimeRemoteException(var0_1);
            throw var1_2;
        }
        {
            var3_4 = new zzp(this, (OnPolylineClickListener)var1_2);
            var2_3.setOnPolylineClickListener(var3_4);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void snapshot(@RecentlyNonNull SnapshotReadyCallback callback) {
        void var1_1;
        Preconditions.checkNotNull((Object)callback, (Object)"Callback must not be null.");
        this.snapshot((SnapshotReadyCallback)var1_1, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void snapshot(@RecentlyNonNull SnapshotReadyCallback callback, @Nullable Bitmap bitmap) {
        RuntimeRemoteException runtimeRemoteException;
        IObjectWrapper iObjectWrapper;
        Preconditions.checkNotNull((Object)callback, (Object)"Callback must not be null.");
        iObjectWrapper = iObjectWrapper != null ? ObjectWrapper.wrap((Object)iObjectWrapper) : null;
        iObjectWrapper = (ObjectWrapper)iObjectWrapper;
        try {
            IGoogleMapDelegate iGoogleMapDelegate = this.zza;
            zzq zzq2 = new zzq(this, (SnapshotReadyCallback)((Object)runtimeRemoteException));
            iGoogleMapDelegate.snapshot(zzq2, iObjectWrapper);
            return;
        }
        catch (RemoteException remoteException) {
            runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setPadding(int left, int top, int right, int bottom) {
        try {
            void var4_6;
            void var3_5;
            void var2_4;
            void var1_2;
            this.zza.setPadding((int)var1_2, (int)var2_4, (int)var3_5, (int)var4_6);
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setContentDescription(@Nullable String description) {
        RuntimeRemoteException runtimeRemoteException;
        try {
            this.zza.setContentDescription((String)((Object)runtimeRemoteException));
            return;
        }
        catch (RemoteException remoteException) {
            runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setOnPoiClickListener(@Nullable OnPoiClickListener listener) {
        if (listener != null) ** GOTO lbl5
        try {
            this.zza.setOnPoiClickListener(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            var1_2 = new RuntimeRemoteException(var0_1);
            throw var1_2;
        }
        {
            var3_4 = new zzr(this, (OnPoiClickListener)var1_2);
            var2_3.setOnPoiClickListener(var3_4);
            return;
        }
    }

    public boolean setMapStyle(@Nullable MapStyleOptions style) {
        boolean bl;
        RuntimeRemoteException runtimeRemoteException;
        try {
            bl = this.zza.setMapStyle((MapStyleOptions)((Object)runtimeRemoteException));
        }
        catch (RemoteException remoteException) {
            runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setMinZoomPreference(float minZoomPreference) {
        try {
            void var1_2;
            this.zza.setMinZoomPreference((float)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setMaxZoomPreference(float maxZoomPreference) {
        try {
            void var1_2;
            this.zza.setMaxZoomPreference((float)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resetMinMaxZoomPreference() {
        try {
            this.zza.resetMinMaxZoomPreference();
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setLatLngBoundsForCameraTarget(@Nullable LatLngBounds bounds) {
        RuntimeRemoteException runtimeRemoteException;
        try {
            this.zza.setLatLngBoundsForCameraTarget((LatLngBounds)((Object)runtimeRemoteException));
            return;
        }
        catch (RemoteException remoteException) {
            runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    public static interface OnPoiClickListener {
        public void onPoiClick(@RecentlyNonNull PointOfInterest var1);
    }

    public static interface OnGroundOverlayClickListener {
        public void onGroundOverlayClick(@RecentlyNonNull GroundOverlay var1);
    }

    public static interface OnMapLoadedCallback {
        public void onMapLoaded();
    }

    public static interface OnMyLocationClickListener {
        public void onMyLocationClick(@RecentlyNonNull Location var1);
    }

    public static interface OnMyLocationButtonClickListener {
        public boolean onMyLocationButtonClick();
    }

    @Deprecated
    public static interface OnMyLocationChangeListener {
        public void onMyLocationChange(@RecentlyNonNull Location var1);
    }

    public static interface InfoWindowAdapter {
        @RecentlyNullable
        public View getInfoWindow(@RecentlyNonNull Marker var1);

        @RecentlyNullable
        public View getInfoContents(@RecentlyNonNull Marker var1);
    }

    public static interface SnapshotReadyCallback {
        public void onSnapshotReady(@Nullable Bitmap var1);
    }

    public static interface CancelableCallback {
        public void onFinish();

        public void onCancel();
    }

    public static interface OnInfoWindowCloseListener {
        public void onInfoWindowClose(@RecentlyNonNull Marker var1);
    }

    public static interface OnInfoWindowLongClickListener {
        public void onInfoWindowLongClick(@RecentlyNonNull Marker var1);
    }

    public static interface OnInfoWindowClickListener {
        public void onInfoWindowClick(@RecentlyNonNull Marker var1);
    }

    public static interface OnMarkerDragListener {
        public void onMarkerDragStart(@RecentlyNonNull Marker var1);

        public void onMarkerDrag(@RecentlyNonNull Marker var1);

        public void onMarkerDragEnd(@RecentlyNonNull Marker var1);
    }

    public static interface OnMarkerClickListener {
        public boolean onMarkerClick(@RecentlyNonNull Marker var1);
    }

    public static interface OnPolylineClickListener {
        public void onPolylineClick(@RecentlyNonNull Polyline var1);
    }

    public static interface OnPolygonClickListener {
        public void onPolygonClick(@RecentlyNonNull Polygon var1);
    }

    public static interface OnCircleClickListener {
        public void onCircleClick(@RecentlyNonNull Circle var1);
    }

    @Deprecated
    public static interface OnCameraChangeListener {
        public void onCameraChange(@RecentlyNonNull CameraPosition var1);
    }

    public static interface OnCameraIdleListener {
        public void onCameraIdle();
    }

    public static interface OnCameraMoveCanceledListener {
        public void onCameraMoveCanceled();
    }

    public static interface OnCameraMoveListener {
        public void onCameraMove();
    }

    public static interface OnCameraMoveStartedListener {
        public static final int REASON_GESTURE = 1;
        public static final int REASON_API_ANIMATION = 2;
        public static final int REASON_DEVELOPER_ANIMATION = 3;

        public void onCameraMoveStarted(int var1);
    }

    public static interface OnMapLongClickListener {
        public void onMapLongClick(@RecentlyNonNull LatLng var1);
    }

    public static interface OnMapClickListener {
        public void onMapClick(@RecentlyNonNull LatLng var1);
    }

    public static interface OnIndoorStateChangeListener {
        public void onIndoorBuildingFocused();

        public void onIndoorLevelActivated(@RecentlyNonNull IndoorBuilding var1);
    }
}

