/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.graphics.Point;
import android.os.RemoteException;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.maps.CameraUpdate;
import com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.RuntimeRemoteException;

public final class CameraUpdateFactory {
    private static ICameraUpdateFactoryDelegate zza;

    private CameraUpdateFactory() {
    }

    @RecentlyNonNull
    public static CameraUpdate zoomIn() {
        CameraUpdate cameraUpdate;
        try {
            cameraUpdate = new CameraUpdate(CameraUpdateFactory.zzb().zoomIn());
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return cameraUpdate;
    }

    @RecentlyNonNull
    public static CameraUpdate zoomOut() {
        CameraUpdate cameraUpdate;
        try {
            cameraUpdate = new CameraUpdate(CameraUpdateFactory.zzb().zoomOut());
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return cameraUpdate;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public static CameraUpdate scrollBy(float xPixel, float yPixel) {
        CameraUpdate cameraUpdate;
        try {
            void var1_2;
            float f;
            cameraUpdate = new CameraUpdate(CameraUpdateFactory.zzb().scrollBy(f, (float)var1_2));
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return cameraUpdate;
    }

    @RecentlyNonNull
    public static CameraUpdate zoomTo(float zoom) {
        CameraUpdate cameraUpdate;
        try {
            float f;
            cameraUpdate = new CameraUpdate(CameraUpdateFactory.zzb().zoomTo(f));
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return cameraUpdate;
    }

    @RecentlyNonNull
    public static CameraUpdate zoomBy(float amount) {
        CameraUpdate cameraUpdate;
        try {
            float f;
            cameraUpdate = new CameraUpdate(CameraUpdateFactory.zzb().zoomBy(f));
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return cameraUpdate;
    }

    @RecentlyNonNull
    public static CameraUpdate zoomBy(float amount, @RecentlyNonNull Point focus) {
        CameraUpdate cameraUpdate;
        RuntimeRemoteException runtimeRemoteException;
        Preconditions.checkNotNull((Object)focus, (Object)"focus must not be null");
        try {
            float f;
            cameraUpdate = new CameraUpdate(CameraUpdateFactory.zzb().zoomByWithFocus(f, ((Point)runtimeRemoteException).x, ((Point)runtimeRemoteException).y));
        }
        catch (RemoteException remoteException) {
            runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return cameraUpdate;
    }

    @RecentlyNonNull
    public static CameraUpdate newCameraPosition(@RecentlyNonNull CameraPosition cameraPosition) {
        CameraUpdate cameraUpdate;
        Preconditions.checkNotNull((Object)((Object)cameraPosition), (Object)"cameraPosition must not be null");
        try {
            CameraPosition cameraPosition2;
            cameraUpdate = new CameraUpdate(CameraUpdateFactory.zzb().newCameraPosition(cameraPosition2));
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return cameraUpdate;
    }

    @RecentlyNonNull
    public static CameraUpdate newLatLng(@RecentlyNonNull LatLng latLng) {
        CameraUpdate cameraUpdate;
        Preconditions.checkNotNull((Object)((Object)latLng), (Object)"latLng must not be null");
        try {
            LatLng latLng2;
            cameraUpdate = new CameraUpdate(CameraUpdateFactory.zzb().newLatLng(latLng2));
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return cameraUpdate;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public static CameraUpdate newLatLngZoom(@RecentlyNonNull LatLng latLng, float zoom) {
        CameraUpdate cameraUpdate;
        Preconditions.checkNotNull((Object)((Object)latLng), (Object)"latLng must not be null");
        try {
            void var1_2;
            LatLng latLng2;
            cameraUpdate = new CameraUpdate(CameraUpdateFactory.zzb().newLatLngZoom(latLng2, (float)var1_2));
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return cameraUpdate;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public static CameraUpdate newLatLngBounds(@RecentlyNonNull LatLngBounds bounds, int padding) {
        CameraUpdate cameraUpdate;
        Preconditions.checkNotNull((Object)((Object)bounds), (Object)"bounds must not be null");
        try {
            void var1_2;
            LatLngBounds latLngBounds;
            cameraUpdate = new CameraUpdate(CameraUpdateFactory.zzb().newLatLngBounds(latLngBounds, (int)var1_2));
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return cameraUpdate;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public static CameraUpdate newLatLngBounds(@RecentlyNonNull LatLngBounds bounds, int width, int height, int padding) {
        CameraUpdate cameraUpdate;
        Preconditions.checkNotNull((Object)((Object)bounds), (Object)"bounds must not be null");
        try {
            void var3_5;
            void var2_4;
            void var1_2;
            LatLngBounds latLngBounds;
            cameraUpdate = new CameraUpdate(CameraUpdateFactory.zzb().newLatLngBoundsWithSize(latLngBounds, (int)var1_2, (int)var2_4, (int)var3_5));
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return cameraUpdate;
    }

    private static ICameraUpdateFactoryDelegate zzb() {
        return (ICameraUpdateFactoryDelegate)Preconditions.checkNotNull((Object)zza, (Object)"CameraUpdateFactory is not initialized");
    }

    public static void zza(@RecentlyNonNull ICameraUpdateFactoryDelegate iCameraUpdateFactoryDelegate) {
        zza = (ICameraUpdateFactoryDelegate)Preconditions.checkNotNull((Object)iCameraUpdateFactoryDelegate);
    }
}

