/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.model.zzq;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="StreetViewSourceCreator")
public final class StreetViewSource
extends AbstractSafeParcelable {
    private static final String TAG = StreetViewSource.class.getSimpleName();
    public static final Parcelable.Creator<StreetViewSource> CREATOR = new zzq();
    public static final StreetViewSource DEFAULT = new StreetViewSource(0);
    public static final StreetViewSource OUTDOOR = new StreetViewSource(1);
    @SafeParcelable.Field(id=2, getter="getType")
    private final int type;

    @SafeParcelable.Constructor
    public StreetViewSource(@SafeParcelable.Param(id=2) int n) {
        this.type = n;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        StreetViewSource streetViewSource = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)2, (int)streetViewSource.type);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type});
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof StreetViewSource)) {
            return false;
        }
        StreetViewSource streetViewSource = (StreetViewSource)((Object)object);
        return this.type == streetViewSource.type;
    }

    public final String toString() {
        String string;
        switch (this.type) {
            case 0: {
                string = "DEFAULT";
                break;
            }
            case 1: {
                string = "OUTDOOR";
                break;
            }
            default: {
                string = String.format("UNKNOWN(%s)", this.type);
            }
        }
        return String.format("StreetViewSource:%s", string);
    }
}

