/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.internal;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.Nullable;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.maps.internal.zze;
import com.google.android.gms.maps.internal.zzf;
import com.google.android.gms.maps.model.RuntimeRemoteException;

public class zzbz {
    private static final String TAG = zzbz.class.getSimpleName();
    @Nullable
    @SuppressLint(value={"StaticFieldLeak"})
    private static Context zzck = null;
    private static zze zzcl;

    public static zze zza(Context context) throws GooglePlayServicesNotAvailableException {
        IInterface iInterface;
        Preconditions.checkNotNull((Object)context);
        if (zzcl != null) {
            return zzcl;
        }
        int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)context, (int)0xCC77C0);
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new GooglePlayServicesNotAvailableException(n);
            }
        }
        Context context2 = context;
        Log.i((String)TAG, (String)"Making Creator dynamically");
        IBinder iBinder = (IBinder)zzbz.zza(zzbz.zzb(context2).getClassLoader(), "com.google.android.gms.maps.internal.CreatorImpl");
        zzcl = iBinder == null ? null : ((iInterface = iBinder.queryLocalInterface("com.google.android.gms.maps.internal.ICreator")) instanceof zze ? (zze)iInterface : new zzf(iBinder));
        try {
            zzcl.zza(ObjectWrapper.wrap((Object)zzbz.zzb(context).getResources()), GooglePlayServicesUtil.GOOGLE_PLAY_SERVICES_VERSION_CODE);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return zzcl;
    }

    @Nullable
    private static Context zzb(Context context) {
        if (zzck != null) {
            return zzck;
        }
        zzck = zzbz.zzc(context);
        return zzck;
    }

    @Nullable
    private static Context zzc(Context context) {
        Context context2;
        try {
            context2 = DynamiteModule.load((Context)context, (DynamiteModule.VersionPolicy)DynamiteModule.PREFER_REMOTE, (String)"com.google.android.gms.maps_dynamite").getModuleContext();
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)"Failed to load maps module, use legacy", (Throwable)exception);
            context2 = GooglePlayServicesUtil.getRemoteContext((Context)context);
        }
        return context2;
    }

    private static <T> T zza(ClassLoader classLoader, String string) {
        try {
            return zzbz.zza(((ClassLoader)Preconditions.checkNotNull((Object)classLoader)).loadClass(string));
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string2 = String.valueOf(string);
            throw new IllegalStateException(string2.length() != 0 ? "Unable to find dynamic class ".concat(string2) : new String("Unable to find dynamic class "));
        }
    }

    private static <T> T zza(Class<?> clazz) {
        try {
            return (T)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            String string = String.valueOf(clazz.getName());
            throw new IllegalStateException(string.length() != 0 ? "Unable to instantiate the dynamic class ".concat(string) : new String("Unable to instantiate the dynamic class "));
        }
        catch (IllegalAccessException illegalAccessException) {
            String string = String.valueOf(clazz.getName());
            throw new IllegalStateException(string.length() != 0 ? "Unable to call the default constructor of ".concat(string) : new String("Unable to call the default constructor of "));
        }
    }
}

