/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.model.ButtCap;
import com.google.android.gms.maps.model.Cap;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PatternItem;
import com.google.android.gms.maps.model.zzl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="PolylineOptionsCreator")
public final class PolylineOptions
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<PolylineOptions> CREATOR = new zzl();
    @SafeParcelable.Field(id=2, getter="getPoints")
    private final List<LatLng> zzdx;
    @SafeParcelable.Field(id=3, getter="getWidth")
    private float width = 10.0f;
    @SafeParcelable.Field(id=4, getter="getColor")
    private int color = -16777216;
    @SafeParcelable.Field(id=5, getter="getZIndex")
    private float zzcs = 0.0f;
    @SafeParcelable.Field(id=6, getter="isVisible")
    private boolean zzct = true;
    @SafeParcelable.Field(id=7, getter="isGeodesic")
    private boolean zzdz = false;
    @SafeParcelable.Field(id=8, getter="isClickable")
    private boolean zzcu = false;
    @SafeParcelable.Field(id=9, getter="getStartCap")
    @NonNull
    private Cap zzec = new ButtCap();
    @SafeParcelable.Field(id=10, getter="getEndCap")
    @NonNull
    private Cap zzed = new ButtCap();
    @SafeParcelable.Field(id=11, getter="getJointType")
    private int zzee = 0;
    @Nullable
    @SafeParcelable.Field(id=12, getter="getPattern")
    private List<PatternItem> zzef = null;

    public PolylineOptions() {
        this.zzdx = new ArrayList<LatLng>();
    }

    @SafeParcelable.Constructor
    PolylineOptions(@SafeParcelable.Param(id=2) List list, @SafeParcelable.Param(id=3) float f, @SafeParcelable.Param(id=4) int n, @SafeParcelable.Param(id=5) float f2, @SafeParcelable.Param(id=6) boolean bl, @SafeParcelable.Param(id=7) boolean bl2, @SafeParcelable.Param(id=8) boolean bl3, @SafeParcelable.Param(id=9) @Nullable Cap cap, @SafeParcelable.Param(id=10) @Nullable Cap cap2, @SafeParcelable.Param(id=11) int n2, @SafeParcelable.Param(id=12) @Nullable List<PatternItem> list2) {
        this.zzdx = list;
        this.width = f;
        this.color = n;
        this.zzcs = f2;
        this.zzct = bl;
        this.zzdz = bl2;
        this.zzcu = bl3;
        if (cap != null) {
            this.zzec = cap;
        }
        if (cap2 != null) {
            this.zzed = cap2;
        }
        this.zzee = n2;
        this.zzef = list2;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PolylineOptions polylineOptions = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeTypedList((Parcel)parcel2, (int)2, polylineOptions.getPoints(), (boolean)false);
        SafeParcelWriter.writeFloat((Parcel)parcel2, (int)3, (float)polylineOptions.getWidth());
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)4, (int)polylineOptions.getColor());
        SafeParcelWriter.writeFloat((Parcel)parcel2, (int)5, (float)polylineOptions.getZIndex());
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)6, (boolean)polylineOptions.isVisible());
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)7, (boolean)polylineOptions.isGeodesic());
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)8, (boolean)polylineOptions.isClickable());
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)9, (Parcelable)polylineOptions.getStartCap(), (int)n, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)10, (Parcelable)polylineOptions.getEndCap(), (int)n, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)11, (int)polylineOptions.getJointType());
        SafeParcelWriter.writeTypedList((Parcel)parcel2, (int)12, polylineOptions.getPattern(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public final PolylineOptions add(LatLng latLng) {
        this.zzdx.add(latLng);
        return this;
    }

    public final PolylineOptions add(LatLng ... latLngArray) {
        this.zzdx.addAll(Arrays.asList(latLngArray));
        return this;
    }

    public final PolylineOptions addAll(Iterable<LatLng> iterable) {
        for (LatLng latLng : iterable) {
            this.zzdx.add(latLng);
        }
        return this;
    }

    public final PolylineOptions width(float f) {
        this.width = f;
        return this;
    }

    public final PolylineOptions color(int n) {
        this.color = n;
        return this;
    }

    public final PolylineOptions startCap(@NonNull Cap cap) {
        this.zzec = (Cap)((Object)Preconditions.checkNotNull((Object)((Object)cap), (Object)"startCap must not be null"));
        return this;
    }

    public final PolylineOptions endCap(@NonNull Cap cap) {
        this.zzed = (Cap)((Object)Preconditions.checkNotNull((Object)((Object)cap), (Object)"endCap must not be null"));
        return this;
    }

    public final PolylineOptions jointType(int n) {
        this.zzee = n;
        return this;
    }

    public final PolylineOptions pattern(@Nullable List<PatternItem> list) {
        this.zzef = list;
        return this;
    }

    public final PolylineOptions zIndex(float f) {
        this.zzcs = f;
        return this;
    }

    public final PolylineOptions visible(boolean bl) {
        this.zzct = bl;
        return this;
    }

    public final PolylineOptions geodesic(boolean bl) {
        this.zzdz = bl;
        return this;
    }

    public final PolylineOptions clickable(boolean bl) {
        this.zzcu = bl;
        return this;
    }

    public final List<LatLng> getPoints() {
        return this.zzdx;
    }

    public final float getWidth() {
        return this.width;
    }

    public final int getColor() {
        return this.color;
    }

    @NonNull
    public final Cap getStartCap() {
        return this.zzec;
    }

    @NonNull
    public final Cap getEndCap() {
        return this.zzed;
    }

    public final int getJointType() {
        return this.zzee;
    }

    @Nullable
    public final List<PatternItem> getPattern() {
        return this.zzef;
    }

    public final float getZIndex() {
        return this.zzcs;
    }

    public final boolean isVisible() {
        return this.zzct;
    }

    public final boolean isGeodesic() {
        return this.zzdz;
    }

    public final boolean isClickable() {
        return this.zzcu;
    }
}

