/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.maps.zzn;
import com.google.android.gms.internal.maps.zzq;
import com.google.android.gms.internal.maps.zzr;
import com.google.android.gms.maps.model.IndoorLevel;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import java.util.ArrayList;
import java.util.List;

public final class IndoorBuilding {
    @NonNull
    private final zzn zzdd;
    @NonNull
    private final zza zzde;

    public IndoorBuilding(@NonNull zzn zzn2) {
        this(zzn2, zza.zzdf);
    }

    @VisibleForTesting
    private IndoorBuilding(@NonNull zzn zzn2, @NonNull zza zza2) {
        this.zzdd = (zzn)Preconditions.checkNotNull((Object)zzn2, (Object)"delegate");
        this.zzde = (zza)Preconditions.checkNotNull((Object)zza2, (Object)"shim");
    }

    public final int getDefaultLevelIndex() {
        try {
            return this.zzdd.getDefaultLevelIndex();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final int getActiveLevelIndex() {
        try {
            return this.zzdd.getActiveLevelIndex();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final List<IndoorLevel> getLevels() {
        try {
            List<IBinder> list = this.zzdd.getLevels();
            ArrayList<IndoorLevel> arrayList = new ArrayList<IndoorLevel>(list.size());
            for (IBinder iBinder : list) {
                arrayList.add(zza.zza(zza.zza(iBinder)));
            }
            return arrayList;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean isUnderground() {
        try {
            return this.zzdd.isUnderground();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean equals(Object object) {
        if (!(object instanceof IndoorBuilding)) {
            return false;
        }
        try {
            return this.zzdd.zzb(((IndoorBuilding)object).zzdd);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final int hashCode() {
        try {
            return this.zzdd.zzj();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    @VisibleForTesting
    static final class zza {
        public static final zza zzdf = new zza();

        private zza() {
        }

        @NonNull
        public static IndoorLevel zza(@NonNull zzq zzq2) {
            return new IndoorLevel(zzq2);
        }

        @NonNull
        public static zzq zza(IBinder iBinder) {
            return zzr.zzf(iBinder);
        }
    }
}

