/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.zzd;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="GroundOverlayOptionsCreator")
public final class GroundOverlayOptions
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<GroundOverlayOptions> CREATOR = new zzd();
    public static final float NO_DIMENSION = -1.0f;
    @SafeParcelable.Field(id=2, getter="getWrappedImageDescriptorImplBinder", type="android.os.IBinder")
    @NonNull
    private BitmapDescriptor zzcx;
    @SafeParcelable.Field(id=3, getter="getLocation")
    private LatLng zzcy;
    @SafeParcelable.Field(id=4, getter="getWidth")
    private float width;
    @SafeParcelable.Field(id=5, getter="getHeight")
    private float height;
    @SafeParcelable.Field(id=6, getter="getBounds")
    private LatLngBounds zzcz;
    @SafeParcelable.Field(id=7, getter="getBearing")
    private float bearing;
    @SafeParcelable.Field(id=8, getter="getZIndex")
    private float zzcs;
    @SafeParcelable.Field(id=9, getter="isVisible")
    private boolean zzct = true;
    @SafeParcelable.Field(id=10, getter="getTransparency")
    private float zzda = 0.0f;
    @SafeParcelable.Field(id=11, getter="getAnchorU")
    private float zzdb = 0.5f;
    @SafeParcelable.Field(id=12, getter="getAnchorV")
    private float zzdc = 0.5f;
    @SafeParcelable.Field(id=13, getter="isClickable")
    private boolean zzcu = false;

    @SafeParcelable.Constructor
    GroundOverlayOptions(@SafeParcelable.Param(id=2) IBinder iBinder, @SafeParcelable.Param(id=3) LatLng latLng, @SafeParcelable.Param(id=4) float f, @SafeParcelable.Param(id=5) float f2, @SafeParcelable.Param(id=6) LatLngBounds latLngBounds, @SafeParcelable.Param(id=7) float f3, @SafeParcelable.Param(id=8) float f4, @SafeParcelable.Param(id=9) boolean bl, @SafeParcelable.Param(id=10) float f5, @SafeParcelable.Param(id=11) float f6, @SafeParcelable.Param(id=12) float f7, @SafeParcelable.Param(id=13) boolean bl2) {
        this.zzcx = new BitmapDescriptor(IObjectWrapper.Stub.asInterface((IBinder)iBinder));
        this.zzcy = latLng;
        this.width = f;
        this.height = f2;
        this.zzcz = latLngBounds;
        this.bearing = f3;
        this.zzcs = f4;
        this.zzct = bl;
        this.zzda = f5;
        this.zzdb = f6;
        this.zzdc = f7;
        this.zzcu = bl2;
    }

    public GroundOverlayOptions() {
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GroundOverlayOptions groundOverlayOptions = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeIBinder((Parcel)parcel2, (int)2, (IBinder)groundOverlayOptions.zzcx.zzb().asBinder(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)3, (Parcelable)groundOverlayOptions.getLocation(), (int)n, (boolean)false);
        SafeParcelWriter.writeFloat((Parcel)parcel2, (int)4, (float)groundOverlayOptions.getWidth());
        SafeParcelWriter.writeFloat((Parcel)parcel2, (int)5, (float)groundOverlayOptions.getHeight());
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)6, (Parcelable)groundOverlayOptions.getBounds(), (int)n, (boolean)false);
        SafeParcelWriter.writeFloat((Parcel)parcel2, (int)7, (float)groundOverlayOptions.getBearing());
        SafeParcelWriter.writeFloat((Parcel)parcel2, (int)8, (float)groundOverlayOptions.getZIndex());
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)9, (boolean)groundOverlayOptions.isVisible());
        SafeParcelWriter.writeFloat((Parcel)parcel2, (int)10, (float)groundOverlayOptions.getTransparency());
        SafeParcelWriter.writeFloat((Parcel)parcel2, (int)11, (float)groundOverlayOptions.getAnchorU());
        SafeParcelWriter.writeFloat((Parcel)parcel2, (int)12, (float)groundOverlayOptions.getAnchorV());
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)13, (boolean)groundOverlayOptions.isClickable());
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public final GroundOverlayOptions image(@NonNull BitmapDescriptor bitmapDescriptor) {
        Preconditions.checkNotNull((Object)bitmapDescriptor, (Object)"imageDescriptor must not be null");
        this.zzcx = bitmapDescriptor;
        return this;
    }

    public final GroundOverlayOptions anchor(float f, float f2) {
        this.zzdb = f;
        this.zzdc = f2;
        return this;
    }

    public final GroundOverlayOptions position(LatLng latLng, float f) {
        Preconditions.checkState((this.zzcz == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        Preconditions.checkArgument((latLng != null ? 1 : 0) != 0, (Object)"Location must be specified");
        Preconditions.checkArgument((f >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        return this.zza(latLng, f, -1.0f);
    }

    public final GroundOverlayOptions position(LatLng latLng, float f, float f2) {
        Preconditions.checkState((this.zzcz == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        Preconditions.checkArgument((latLng != null ? 1 : 0) != 0, (Object)"Location must be specified");
        Preconditions.checkArgument((f >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        Preconditions.checkArgument((f2 >= 0.0f ? 1 : 0) != 0, (Object)"Height must be non-negative");
        return this.zza(latLng, f, f2);
    }

    private final GroundOverlayOptions zza(LatLng latLng, float f, float f2) {
        this.zzcy = latLng;
        this.width = f;
        this.height = f2;
        return this;
    }

    public final GroundOverlayOptions positionFromBounds(LatLngBounds latLngBounds) {
        String string = String.valueOf((Object)this.zzcy);
        Preconditions.checkState((this.zzcy == null ? 1 : 0) != 0, (Object)new StringBuilder(46 + String.valueOf(string).length()).append("Position has already been set using position: ").append(string).toString());
        this.zzcz = latLngBounds;
        return this;
    }

    public final GroundOverlayOptions bearing(float f) {
        this.bearing = (f % 360.0f + 360.0f) % 360.0f;
        return this;
    }

    public final GroundOverlayOptions zIndex(float f) {
        this.zzcs = f;
        return this;
    }

    public final GroundOverlayOptions visible(boolean bl) {
        this.zzct = bl;
        return this;
    }

    public final GroundOverlayOptions transparency(float f) {
        Preconditions.checkArgument((f >= 0.0f && f <= 1.0f ? 1 : 0) != 0, (Object)"Transparency must be in the range [0..1]");
        this.zzda = f;
        return this;
    }

    public final GroundOverlayOptions clickable(boolean bl) {
        this.zzcu = bl;
        return this;
    }

    public final BitmapDescriptor getImage() {
        return this.zzcx;
    }

    public final LatLng getLocation() {
        return this.zzcy;
    }

    public final float getWidth() {
        return this.width;
    }

    public final float getHeight() {
        return this.height;
    }

    public final LatLngBounds getBounds() {
        return this.zzcz;
    }

    public final float getBearing() {
        return this.bearing;
    }

    public final float getZIndex() {
        return this.zzcs;
    }

    public final float getTransparency() {
        return this.zzda;
    }

    public final float getAnchorU() {
        return this.zzdb;
    }

    public final float getAnchorV() {
        return this.zzdc;
    }

    public final boolean isVisible() {
        return this.zzct;
    }

    public final boolean isClickable() {
        return this.zzcu;
    }
}

