/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.StrictMode;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.DeferredLifecycleHelper;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.dynamic.OnDelegateCreatedListener;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.OnStreetViewPanoramaReadyCallback;
import com.google.android.gms.maps.StreetViewPanoramaOptions;
import com.google.android.gms.maps.internal.IStreetViewPanoramaViewDelegate;
import com.google.android.gms.maps.internal.StreetViewLifecycleDelegate;
import com.google.android.gms.maps.internal.zzby;
import com.google.android.gms.maps.internal.zzbz;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import com.google.android.gms.maps.zzaj;
import java.util.ArrayList;
import java.util.List;

public class StreetViewPanoramaView
extends FrameLayout {
    private final zzb zzcc;

    public StreetViewPanoramaView(Context context) {
        super(context);
        this.zzcc = new zzb((ViewGroup)this, context, null);
    }

    public StreetViewPanoramaView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.zzcc = new zzb((ViewGroup)this, context, null);
    }

    public StreetViewPanoramaView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.zzcc = new zzb((ViewGroup)this, context, null);
    }

    public StreetViewPanoramaView(Context context, StreetViewPanoramaOptions streetViewPanoramaOptions) {
        super(context);
        this.zzcc = new zzb((ViewGroup)this, context, streetViewPanoramaOptions);
    }

    public final void onCreate(Bundle bundle) {
        StrictMode.ThreadPolicy threadPolicy = StrictMode.getThreadPolicy();
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)new StrictMode.ThreadPolicy.Builder(threadPolicy).permitAll().build());
        try {
            this.zzcc.onCreate(bundle);
            if (this.zzcc.getDelegate() == null) {
                DeferredLifecycleHelper.showGooglePlayUnavailableMessage((FrameLayout)this);
            }
            return;
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
    }

    public void onStart() {
        this.zzcc.onStart();
    }

    public void onResume() {
        this.zzcc.onResume();
    }

    public final void onPause() {
        this.zzcc.onPause();
    }

    public void onStop() {
        this.zzcc.onStop();
    }

    public void onDestroy() {
        this.zzcc.onDestroy();
    }

    public final void onLowMemory() {
        this.zzcc.onLowMemory();
    }

    public final void onSaveInstanceState(Bundle bundle) {
        this.zzcc.onSaveInstanceState(bundle);
    }

    public void getStreetViewPanoramaAsync(OnStreetViewPanoramaReadyCallback onStreetViewPanoramaReadyCallback) {
        Preconditions.checkMainThread((String)"getStreetViewPanoramaAsync() must be called on the main thread");
        this.zzcc.getStreetViewPanoramaAsync(onStreetViewPanoramaReadyCallback);
    }

    @VisibleForTesting
    static final class zzb
    extends DeferredLifecycleHelper<zza> {
        private final ViewGroup zzbi;
        private final Context zzbj;
        private OnDelegateCreatedListener<zza> zzbc;
        private final StreetViewPanoramaOptions zzcf;
        private final List<OnStreetViewPanoramaReadyCallback> zzbv = new ArrayList<OnStreetViewPanoramaReadyCallback>();

        @VisibleForTesting
        zzb(ViewGroup viewGroup, Context context, StreetViewPanoramaOptions streetViewPanoramaOptions) {
            this.zzbi = viewGroup;
            this.zzbj = context;
            this.zzcf = streetViewPanoramaOptions;
        }

        protected final void createDelegate(OnDelegateCreatedListener<zza> onDelegateCreatedListener) {
            this.zzbc = onDelegateCreatedListener;
            zzb zzb2 = this;
            if (zzb2.zzbc != null && zzb2.getDelegate() == null) {
                try {
                    MapsInitializer.initialize(zzb2.zzbj);
                    IStreetViewPanoramaViewDelegate iStreetViewPanoramaViewDelegate = zzbz.zza(zzb2.zzbj).zza(ObjectWrapper.wrap((Object)zzb2.zzbj), zzb2.zzcf);
                    zzb2.zzbc.onDelegateCreated((LifecycleDelegate)new zza(zzb2.zzbi, iStreetViewPanoramaViewDelegate));
                    for (OnStreetViewPanoramaReadyCallback onStreetViewPanoramaReadyCallback : zzb2.zzbv) {
                        ((zza)zzb2.getDelegate()).getStreetViewPanoramaAsync(onStreetViewPanoramaReadyCallback);
                    }
                    zzb2.zzbv.clear();
                    return;
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeRemoteException(remoteException);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {}
            }
        }

        public final void getStreetViewPanoramaAsync(OnStreetViewPanoramaReadyCallback onStreetViewPanoramaReadyCallback) {
            if (this.getDelegate() != null) {
                ((zza)this.getDelegate()).getStreetViewPanoramaAsync(onStreetViewPanoramaReadyCallback);
                return;
            }
            this.zzbv.add(onStreetViewPanoramaReadyCallback);
        }
    }

    @VisibleForTesting
    static final class zza
    implements StreetViewLifecycleDelegate {
        private final ViewGroup parent;
        private final IStreetViewPanoramaViewDelegate zzcd;
        private View zzce;

        public zza(ViewGroup viewGroup, IStreetViewPanoramaViewDelegate iStreetViewPanoramaViewDelegate) {
            this.zzcd = (IStreetViewPanoramaViewDelegate)Preconditions.checkNotNull((Object)iStreetViewPanoramaViewDelegate);
            this.parent = (ViewGroup)Preconditions.checkNotNull((Object)viewGroup);
        }

        public final void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            throw new UnsupportedOperationException("onInflate not allowed on StreetViewPanoramaViewDelegate");
        }

        public final void onCreate(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzby.zza(bundle, bundle2);
                this.zzcd.onCreate(bundle2);
                zzby.zza(bundle2, bundle);
                this.zzce = (View)ObjectWrapper.unwrap((IObjectWrapper)this.zzcd.getView());
                this.parent.removeAllViews();
                this.parent.addView(this.zzce);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            throw new UnsupportedOperationException("onCreateView not allowed on StreetViewPanoramaViewDelegate");
        }

        public final void onStart() {
            try {
                this.zzcd.onStart();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onResume() {
            try {
                this.zzcd.onResume();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onPause() {
            try {
                this.zzcd.onPause();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onStop() {
            try {
                this.zzcd.onStop();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onDestroyView() {
            throw new UnsupportedOperationException("onDestroyView not allowed on StreetViewPanoramaViewDelegate");
        }

        public final void onDestroy() {
            try {
                this.zzcd.onDestroy();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onLowMemory() {
            try {
                this.zzcd.onLowMemory();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onSaveInstanceState(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzby.zza(bundle, bundle2);
                this.zzcd.onSaveInstanceState(bundle2);
                zzby.zza(bundle2, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public final void getStreetViewPanoramaAsync(OnStreetViewPanoramaReadyCallback onStreetViewPanoramaReadyCallback) {
            try {
                this.zzcd.getStreetViewPanoramaAsync(new zzaj(this, onStreetViewPanoramaReadyCallback));
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }
    }
}

