/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.content.Context;
import android.content.res.Resources;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.IOUtils;
import com.google.android.gms.maps.model.zzg;
import java.io.IOException;
import java.io.InputStream;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="MapStyleOptionsCreator")
public final class MapStyleOptions
extends AbstractSafeParcelable {
    private static final String TAG = MapStyleOptions.class.getSimpleName();
    public static final Parcelable.Creator<MapStyleOptions> CREATOR = new zzg();
    @SafeParcelable.Field(id=2, getter="getJson")
    private String zzdk;

    @SafeParcelable.Constructor
    public MapStyleOptions(@SafeParcelable.Param(id=2) String string) {
        this.zzdk = string;
    }

    public static MapStyleOptions loadRawResourceStyle(Context context, int n) throws Resources.NotFoundException {
        InputStream inputStream = context.getResources().openRawResource(n);
        try {
            byte[] byArray = IOUtils.readInputStreamFully((InputStream)inputStream);
            String string = new String(byArray, "UTF-8");
            return new MapStyleOptions(string);
        }
        catch (IOException iOException) {
            String string = String.valueOf(iOException);
            throw new Resources.NotFoundException(new StringBuilder(37 + String.valueOf(string).length()).append("Failed to read resource ").append(n).append(": ").append(string).toString());
        }
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        MapStyleOptions mapStyleOptions = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)mapStyleOptions.zzdk, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }
}

