/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import com.google.android.gms.maps.model.internal.zzp;

public final class Marker {
    private final zzp zzjdu;

    @Hide
    public Marker(zzp zzp2) {
        this.zzjdu = (zzp)zzbq.checkNotNull((Object)zzp2);
    }

    public final void remove() {
        try {
            this.zzjdu.remove();
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final String getId() {
        try {
            return this.zzjdu.getId();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setPosition(@NonNull LatLng latLng) {
        if (latLng == null) {
            throw new IllegalArgumentException("latlng cannot be null - a position is required.");
        }
        try {
            this.zzjdu.setPosition(latLng);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final LatLng getPosition() {
        try {
            return this.zzjdu.getPosition();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setZIndex(float f) {
        try {
            this.zzjdu.setZIndex(f);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final float getZIndex() {
        try {
            return this.zzjdu.getZIndex();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setIcon(@Nullable BitmapDescriptor bitmapDescriptor) {
        try {
            if (bitmapDescriptor == null) {
                this.zzjdu.zzae(null);
                return;
            }
            IObjectWrapper iObjectWrapper = bitmapDescriptor.zzaxq();
            this.zzjdu.zzae(iObjectWrapper);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setAnchor(float f, float f2) {
        try {
            this.zzjdu.setAnchor(f, f2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setInfoWindowAnchor(float f, float f2) {
        try {
            this.zzjdu.setInfoWindowAnchor(f, f2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setTitle(@Nullable String string) {
        try {
            this.zzjdu.setTitle(string);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final String getTitle() {
        try {
            return this.zzjdu.getTitle();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setSnippet(@Nullable String string) {
        try {
            this.zzjdu.setSnippet(string);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final String getSnippet() {
        try {
            return this.zzjdu.getSnippet();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setDraggable(boolean bl) {
        try {
            this.zzjdu.setDraggable(bl);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean isDraggable() {
        try {
            return this.zzjdu.isDraggable();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void showInfoWindow() {
        try {
            this.zzjdu.showInfoWindow();
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void hideInfoWindow() {
        try {
            this.zzjdu.hideInfoWindow();
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean isInfoWindowShown() {
        try {
            return this.zzjdu.isInfoWindowShown();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setVisible(boolean bl) {
        try {
            this.zzjdu.setVisible(bl);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean isVisible() {
        try {
            return this.zzjdu.isVisible();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setFlat(boolean bl) {
        try {
            this.zzjdu.setFlat(bl);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean isFlat() {
        try {
            return this.zzjdu.isFlat();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setRotation(float f) {
        try {
            this.zzjdu.setRotation(f);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final float getRotation() {
        try {
            return this.zzjdu.getRotation();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setAlpha(float f) {
        try {
            this.zzjdu.setAlpha(f);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final float getAlpha() {
        try {
            return this.zzjdu.getAlpha();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setTag(@Nullable Object object) {
        try {
            this.zzjdu.setTag(zzn.zzz((Object)object));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    @Nullable
    public final Object getTag() {
        try {
            return zzn.zzy((IObjectWrapper)this.zzjdu.getTag());
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean equals(Object object) {
        if (!(object instanceof Marker)) {
            return false;
        }
        try {
            return this.zzjdu.zzj(((Marker)object).zzjdu);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final int hashCode() {
        try {
            return this.zzjdu.hashCodeRemote();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }
}

