/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import com.google.android.gms.maps.model.ButtCap;
import com.google.android.gms.maps.model.Cap;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PatternItem;
import com.google.android.gms.maps.model.zzl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class PolylineOptions
extends zzbfm {
    public static final Parcelable.Creator<PolylineOptions> CREATOR = new zzl();
    private final List<LatLng> zzivo;
    private float zziut = 10.0f;
    private int mColor = -16777216;
    private float zzium = 0.0f;
    private boolean zziun = true;
    private boolean zzivq = false;
    private boolean zziuo = false;
    @NonNull
    private Cap zzivt = new ButtCap();
    @NonNull
    private Cap zzivu = new ButtCap();
    private int zzivv = 0;
    @Nullable
    private List<PatternItem> zzivw = null;

    public PolylineOptions() {
        this.zzivo = new ArrayList<LatLng>();
    }

    PolylineOptions(List list, float f, int n, float f2, boolean bl, boolean bl2, boolean bl3, @Nullable Cap cap, @Nullable Cap cap2, int n2, @Nullable List<PatternItem> list2) {
        this.zzivo = list;
        this.zziut = f;
        this.mColor = n;
        this.zzium = f2;
        this.zziun = bl;
        this.zzivq = bl2;
        this.zziuo = bl3;
        if (cap != null) {
            this.zzivt = cap;
        }
        if (cap2 != null) {
            this.zzivu = cap2;
        }
        this.zzivv = n2;
        this.zzivw = list2;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PolylineOptions polylineOptions = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zzc((Parcel)parcel2, (int)2, polylineOptions.getPoints(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)3, (float)polylineOptions.getWidth());
        zzbfp.zzc((Parcel)parcel2, (int)4, (int)polylineOptions.getColor());
        zzbfp.zza((Parcel)parcel2, (int)5, (float)polylineOptions.getZIndex());
        zzbfp.zza((Parcel)parcel2, (int)6, (boolean)polylineOptions.isVisible());
        zzbfp.zza((Parcel)parcel2, (int)7, (boolean)polylineOptions.isGeodesic());
        zzbfp.zza((Parcel)parcel2, (int)8, (boolean)polylineOptions.isClickable());
        zzbfp.zza((Parcel)parcel2, (int)9, (Parcelable)polylineOptions.getStartCap(), (int)n, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)10, (Parcelable)polylineOptions.getEndCap(), (int)n, (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)11, (int)polylineOptions.getJointType());
        zzbfp.zzc((Parcel)parcel2, (int)12, polylineOptions.getPattern(), (boolean)false);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }

    public final PolylineOptions add(LatLng latLng) {
        this.zzivo.add(latLng);
        return this;
    }

    public final PolylineOptions add(LatLng ... latLngArray) {
        this.zzivo.addAll(Arrays.asList(latLngArray));
        return this;
    }

    public final PolylineOptions addAll(Iterable<LatLng> iterable) {
        for (LatLng latLng : iterable) {
            this.zzivo.add(latLng);
        }
        return this;
    }

    public final PolylineOptions width(float f) {
        this.zziut = f;
        return this;
    }

    public final PolylineOptions color(int n) {
        this.mColor = n;
        return this;
    }

    public final PolylineOptions startCap(@NonNull Cap cap) {
        this.zzivt = (Cap)((Object)zzbq.checkNotNull((Object)((Object)cap), (Object)"startCap must not be null"));
        return this;
    }

    public final PolylineOptions endCap(@NonNull Cap cap) {
        this.zzivu = (Cap)((Object)zzbq.checkNotNull((Object)((Object)cap), (Object)"endCap must not be null"));
        return this;
    }

    public final PolylineOptions jointType(int n) {
        this.zzivv = n;
        return this;
    }

    public final PolylineOptions pattern(@Nullable List<PatternItem> list) {
        this.zzivw = list;
        return this;
    }

    public final PolylineOptions zIndex(float f) {
        this.zzium = f;
        return this;
    }

    public final PolylineOptions visible(boolean bl) {
        this.zziun = bl;
        return this;
    }

    public final PolylineOptions geodesic(boolean bl) {
        this.zzivq = bl;
        return this;
    }

    public final PolylineOptions clickable(boolean bl) {
        this.zziuo = bl;
        return this;
    }

    public final List<LatLng> getPoints() {
        return this.zzivo;
    }

    public final float getWidth() {
        return this.zziut;
    }

    public final int getColor() {
        return this.mColor;
    }

    @NonNull
    public final Cap getStartCap() {
        return this.zzivt;
    }

    @NonNull
    public final Cap getEndCap() {
        return this.zzivu;
    }

    public final int getJointType() {
        return this.zzivv;
    }

    @Nullable
    public final List<PatternItem> getPattern() {
        return this.zzivw;
    }

    public final float getZIndex() {
        return this.zzium;
    }

    public final boolean isVisible() {
        return this.zziun;
    }

    public final boolean isGeodesic() {
        return this.zzivq;
    }

    public final boolean isClickable() {
        return this.zziuo;
    }
}

