/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.zzd;

public final class GroundOverlayOptions
extends zzbfm {
    public static final Parcelable.Creator<GroundOverlayOptions> CREATOR = new zzd();
    public static final float NO_DIMENSION = -1.0f;
    @NonNull
    private BitmapDescriptor zziur;
    private LatLng zzius;
    private float zziut;
    private float zziuu;
    private LatLngBounds zziqr;
    private float zziuh;
    private float zzium;
    private boolean zziun = true;
    private float zziuv = 0.0f;
    private float zziuw = 0.5f;
    private float zziux = 0.5f;
    private boolean zziuo = false;

    GroundOverlayOptions(IBinder iBinder, LatLng latLng, float f, float f2, LatLngBounds latLngBounds, float f3, float f4, boolean bl, float f5, float f6, float f7, boolean bl2) {
        this.zziur = new BitmapDescriptor(IObjectWrapper.zza.zzaq((IBinder)iBinder));
        this.zzius = latLng;
        this.zziut = f;
        this.zziuu = f2;
        this.zziqr = latLngBounds;
        this.zziuh = f3;
        this.zzium = f4;
        this.zziun = bl;
        this.zziuv = f5;
        this.zziuw = f6;
        this.zziux = f7;
        this.zziuo = bl2;
    }

    public GroundOverlayOptions() {
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GroundOverlayOptions groundOverlayOptions = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zza((Parcel)parcel2, (int)2, (IBinder)groundOverlayOptions.zziur.zzavz().asBinder(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)3, (Parcelable)groundOverlayOptions.getLocation(), (int)n, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)4, (float)groundOverlayOptions.getWidth());
        zzbfp.zza((Parcel)parcel2, (int)5, (float)groundOverlayOptions.getHeight());
        zzbfp.zza((Parcel)parcel2, (int)6, (Parcelable)groundOverlayOptions.getBounds(), (int)n, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)7, (float)groundOverlayOptions.getBearing());
        zzbfp.zza((Parcel)parcel2, (int)8, (float)groundOverlayOptions.getZIndex());
        zzbfp.zza((Parcel)parcel2, (int)9, (boolean)groundOverlayOptions.isVisible());
        zzbfp.zza((Parcel)parcel2, (int)10, (float)groundOverlayOptions.getTransparency());
        zzbfp.zza((Parcel)parcel2, (int)11, (float)groundOverlayOptions.getAnchorU());
        zzbfp.zza((Parcel)parcel2, (int)12, (float)groundOverlayOptions.getAnchorV());
        zzbfp.zza((Parcel)parcel2, (int)13, (boolean)groundOverlayOptions.isClickable());
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }

    public final GroundOverlayOptions image(@NonNull BitmapDescriptor bitmapDescriptor) {
        zzbq.checkNotNull((Object)bitmapDescriptor, (Object)"imageDescriptor must not be null");
        this.zziur = bitmapDescriptor;
        return this;
    }

    public final GroundOverlayOptions anchor(float f, float f2) {
        this.zziuw = f;
        this.zziux = f2;
        return this;
    }

    public final GroundOverlayOptions position(LatLng latLng, float f) {
        zzbq.zza((this.zziqr == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        zzbq.checkArgument((latLng != null ? 1 : 0) != 0, (Object)"Location must be specified");
        zzbq.checkArgument((f >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        return this.zza(latLng, f, -1.0f);
    }

    public final GroundOverlayOptions position(LatLng latLng, float f, float f2) {
        zzbq.zza((this.zziqr == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        zzbq.checkArgument((latLng != null ? 1 : 0) != 0, (Object)"Location must be specified");
        zzbq.checkArgument((f >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        zzbq.checkArgument((f2 >= 0.0f ? 1 : 0) != 0, (Object)"Height must be non-negative");
        return this.zza(latLng, f, f2);
    }

    private final GroundOverlayOptions zza(LatLng latLng, float f, float f2) {
        this.zzius = latLng;
        this.zziut = f;
        this.zziuu = f2;
        return this;
    }

    public final GroundOverlayOptions positionFromBounds(LatLngBounds latLngBounds) {
        String string = String.valueOf((Object)this.zzius);
        zzbq.zza((this.zzius == null ? 1 : 0) != 0, (Object)new StringBuilder(46 + String.valueOf(string).length()).append("Position has already been set using position: ").append(string).toString());
        this.zziqr = latLngBounds;
        return this;
    }

    public final GroundOverlayOptions bearing(float f) {
        this.zziuh = (f % 360.0f + 360.0f) % 360.0f;
        return this;
    }

    public final GroundOverlayOptions zIndex(float f) {
        this.zzium = f;
        return this;
    }

    public final GroundOverlayOptions visible(boolean bl) {
        this.zziun = bl;
        return this;
    }

    public final GroundOverlayOptions transparency(float f) {
        zzbq.checkArgument((f >= 0.0f && f <= 1.0f ? 1 : 0) != 0, (Object)"Transparency must be in the range [0..1]");
        this.zziuv = f;
        return this;
    }

    public final GroundOverlayOptions clickable(boolean bl) {
        this.zziuo = bl;
        return this;
    }

    public final BitmapDescriptor getImage() {
        return this.zziur;
    }

    public final LatLng getLocation() {
        return this.zzius;
    }

    public final float getWidth() {
        return this.zziut;
    }

    public final float getHeight() {
        return this.zziuu;
    }

    public final LatLngBounds getBounds() {
        return this.zziqr;
    }

    public final float getBearing() {
        return this.zziuh;
    }

    public final float getZIndex() {
        return this.zzium;
    }

    public final float getTransparency() {
        return this.zziuv;
    }

    public final float getAnchorU() {
        return this.zziuw;
    }

    public final float getAnchorV() {
        return this.zziux;
    }

    public final boolean isVisible() {
        return this.zziun;
    }

    public final boolean isClickable() {
        return this.zziuo;
    }
}

