/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbej;
import com.google.android.gms.internal.zzbem;
import com.google.android.gms.maps.model.ButtCap;
import com.google.android.gms.maps.model.Cap;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PatternItem;
import com.google.android.gms.maps.model.zzl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class PolylineOptions
extends zzbej {
    public static final Parcelable.Creator<PolylineOptions> CREATOR = new zzl();
    private final List<LatLng> zzist;
    private float zziry = 10.0f;
    private int mColor = -16777216;
    private float zzirr = 0.0f;
    private boolean zzirs = true;
    private boolean zzisv = false;
    private boolean zzirt = false;
    @NonNull
    private Cap zzisy = new ButtCap();
    @NonNull
    private Cap zzisz = new ButtCap();
    private int zzita = 0;
    @Nullable
    private List<PatternItem> zzitb = null;

    public PolylineOptions() {
        this.zzist = new ArrayList<LatLng>();
    }

    PolylineOptions(List list, float f, int n, float f2, boolean bl, boolean bl2, boolean bl3, @Nullable Cap cap, @Nullable Cap cap2, int n2, @Nullable List<PatternItem> list2) {
        this.zzist = list;
        this.zziry = f;
        this.mColor = n;
        this.zzirr = f2;
        this.zzirs = bl;
        this.zzisv = bl2;
        this.zzirt = bl3;
        if (cap != null) {
            this.zzisy = cap;
        }
        if (cap2 != null) {
            this.zzisz = cap2;
        }
        this.zzita = n2;
        this.zzitb = list2;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PolylineOptions polylineOptions = this;
        int n2 = zzbem.zze((Parcel)parcel2);
        zzbem.zzc((Parcel)parcel2, (int)2, polylineOptions.getPoints(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)3, (float)polylineOptions.getWidth());
        zzbem.zzc((Parcel)parcel2, (int)4, (int)polylineOptions.getColor());
        zzbem.zza((Parcel)parcel2, (int)5, (float)polylineOptions.getZIndex());
        zzbem.zza((Parcel)parcel2, (int)6, (boolean)polylineOptions.isVisible());
        zzbem.zza((Parcel)parcel2, (int)7, (boolean)polylineOptions.isGeodesic());
        zzbem.zza((Parcel)parcel2, (int)8, (boolean)polylineOptions.isClickable());
        zzbem.zza((Parcel)parcel2, (int)9, (Parcelable)polylineOptions.getStartCap(), (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)10, (Parcelable)polylineOptions.getEndCap(), (int)n, (boolean)false);
        zzbem.zzc((Parcel)parcel2, (int)11, (int)polylineOptions.getJointType());
        zzbem.zzc((Parcel)parcel2, (int)12, polylineOptions.getPattern(), (boolean)false);
        zzbem.zzai((Parcel)parcel2, (int)n2);
    }

    public final PolylineOptions add(LatLng latLng) {
        this.zzist.add(latLng);
        return this;
    }

    public final PolylineOptions add(LatLng ... latLngArray) {
        this.zzist.addAll(Arrays.asList(latLngArray));
        return this;
    }

    public final PolylineOptions addAll(Iterable<LatLng> iterable) {
        for (LatLng latLng : iterable) {
            this.zzist.add(latLng);
        }
        return this;
    }

    public final PolylineOptions width(float f) {
        this.zziry = f;
        return this;
    }

    public final PolylineOptions color(int n) {
        this.mColor = n;
        return this;
    }

    public final PolylineOptions startCap(@NonNull Cap cap) {
        this.zzisy = (Cap)((Object)zzbq.checkNotNull((Object)((Object)cap), (Object)"startCap must not be null"));
        return this;
    }

    public final PolylineOptions endCap(@NonNull Cap cap) {
        this.zzisz = (Cap)((Object)zzbq.checkNotNull((Object)((Object)cap), (Object)"endCap must not be null"));
        return this;
    }

    public final PolylineOptions jointType(int n) {
        this.zzita = n;
        return this;
    }

    public final PolylineOptions pattern(@Nullable List<PatternItem> list) {
        this.zzitb = list;
        return this;
    }

    public final PolylineOptions zIndex(float f) {
        this.zzirr = f;
        return this;
    }

    public final PolylineOptions visible(boolean bl) {
        this.zzirs = bl;
        return this;
    }

    public final PolylineOptions geodesic(boolean bl) {
        this.zzisv = bl;
        return this;
    }

    public final PolylineOptions clickable(boolean bl) {
        this.zzirt = bl;
        return this;
    }

    public final List<LatLng> getPoints() {
        return this.zzist;
    }

    public final float getWidth() {
        return this.zziry;
    }

    public final int getColor() {
        return this.mColor;
    }

    @NonNull
    public final Cap getStartCap() {
        return this.zzisy;
    }

    @NonNull
    public final Cap getEndCap() {
        return this.zzisz;
    }

    public final int getJointType() {
        return this.zzita;
    }

    @Nullable
    public final List<PatternItem> getPattern() {
        return this.zzitb;
    }

    public final float getZIndex() {
        return this.zzirr;
    }

    public final boolean isVisible() {
        return this.zzirs;
    }

    public final boolean isGeodesic() {
        return this.zzisv;
    }

    public final boolean isClickable() {
        return this.zzirt;
    }
}

