/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.graphics.Point;
import android.os.RemoteException;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.maps.CameraUpdate;
import com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.RuntimeRemoteException;

public final class CameraUpdateFactory {
    private static ICameraUpdateFactoryDelegate zzioc;

    private CameraUpdateFactory() {
    }

    private static ICameraUpdateFactoryDelegate zzavo() {
        return (ICameraUpdateFactoryDelegate)zzbq.checkNotNull((Object)zzioc, (Object)"CameraUpdateFactory is not initialized");
    }

    public static void zza(ICameraUpdateFactoryDelegate iCameraUpdateFactoryDelegate) {
        zzioc = (ICameraUpdateFactoryDelegate)zzbq.checkNotNull((Object)iCameraUpdateFactoryDelegate);
    }

    public static CameraUpdate zoomIn() {
        try {
            return new CameraUpdate(CameraUpdateFactory.zzavo().zoomIn());
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public static CameraUpdate zoomOut() {
        try {
            return new CameraUpdate(CameraUpdateFactory.zzavo().zoomOut());
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public static CameraUpdate scrollBy(float f, float f2) {
        try {
            return new CameraUpdate(CameraUpdateFactory.zzavo().scrollBy(f, f2));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public static CameraUpdate zoomTo(float f) {
        try {
            return new CameraUpdate(CameraUpdateFactory.zzavo().zoomTo(f));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public static CameraUpdate zoomBy(float f) {
        try {
            return new CameraUpdate(CameraUpdateFactory.zzavo().zoomBy(f));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public static CameraUpdate zoomBy(float f, Point point) {
        try {
            return new CameraUpdate(CameraUpdateFactory.zzavo().zoomByWithFocus(f, point.x, point.y));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public static CameraUpdate newCameraPosition(CameraPosition cameraPosition) {
        try {
            return new CameraUpdate(CameraUpdateFactory.zzavo().newCameraPosition(cameraPosition));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public static CameraUpdate newLatLng(LatLng latLng) {
        try {
            return new CameraUpdate(CameraUpdateFactory.zzavo().newLatLng(latLng));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public static CameraUpdate newLatLngZoom(LatLng latLng, float f) {
        try {
            return new CameraUpdate(CameraUpdateFactory.zzavo().newLatLngZoom(latLng, f));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public static CameraUpdate newLatLngBounds(LatLngBounds latLngBounds, int n) {
        try {
            return new CameraUpdate(CameraUpdateFactory.zzavo().newLatLngBounds(latLngBounds, n));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public static CameraUpdate newLatLngBounds(LatLngBounds latLngBounds, int n, int n2, int n3) {
        try {
            return new CameraUpdate(CameraUpdateFactory.zzavo().newLatLngBoundsWithSize(latLngBounds, n, n2, n3));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }
}

