/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbej;
import com.google.android.gms.internal.zzbem;
import com.google.android.gms.maps.model.StreetViewPanoramaOrientation;
import com.google.android.gms.maps.model.zzm;
import java.util.Arrays;

public class StreetViewPanoramaCamera
extends zzbej
implements ReflectedParcelable {
    public static final Parcelable.Creator<StreetViewPanoramaCamera> CREATOR = new zzm();
    public final float zoom;
    public final float tilt;
    public final float bearing;
    @NonNull
    private final StreetViewPanoramaOrientation zzitc;

    public StreetViewPanoramaCamera(float f, float f2, float f3) {
        zzbq.checkArgument((-90.0f <= f2 && f2 <= 90.0f ? 1 : 0) != 0, (Object)new StringBuilder(62).append("Tilt needs to be between -90 and 90 inclusive: ").append(f2).toString());
        this.zoom = (double)f <= 0.0 ? 0.0f : f;
        this.tilt = f2 + 0.0f;
        this.bearing = ((double)f3 <= 0.0 ? f3 % 360.0f + 360.0f : f3) % 360.0f;
        this.zzitc = new StreetViewPanoramaOrientation.Builder().tilt(f2).bearing(f3).build();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        StreetViewPanoramaCamera streetViewPanoramaCamera = this;
        int n2 = zzbem.zze((Parcel)parcel2);
        zzbem.zza((Parcel)parcel2, (int)2, (float)streetViewPanoramaCamera.zoom);
        zzbem.zza((Parcel)parcel2, (int)3, (float)streetViewPanoramaCamera.tilt);
        zzbem.zza((Parcel)parcel2, (int)4, (float)streetViewPanoramaCamera.bearing);
        zzbem.zzai((Parcel)parcel2, (int)n2);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(@NonNull StreetViewPanoramaCamera streetViewPanoramaCamera) {
        return new Builder(streetViewPanoramaCamera);
    }

    @NonNull
    public StreetViewPanoramaOrientation getOrientation() {
        return this.zzitc;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{Float.valueOf(this.zoom), Float.valueOf(this.tilt), Float.valueOf(this.bearing)});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof StreetViewPanoramaCamera)) {
            return false;
        }
        StreetViewPanoramaCamera streetViewPanoramaCamera = (StreetViewPanoramaCamera)((Object)object);
        return Float.floatToIntBits(this.zoom) == Float.floatToIntBits(streetViewPanoramaCamera.zoom) && Float.floatToIntBits(this.tilt) == Float.floatToIntBits(streetViewPanoramaCamera.tilt) && Float.floatToIntBits(this.bearing) == Float.floatToIntBits(streetViewPanoramaCamera.bearing);
    }

    public String toString() {
        return zzbg.zzw((Object)((Object)this)).zzg("zoom", (Object)Float.valueOf(this.zoom)).zzg("tilt", (Object)Float.valueOf(this.tilt)).zzg("bearing", (Object)Float.valueOf(this.bearing)).toString();
    }

    public static final class Builder {
        public float bearing;
        public float tilt;
        public float zoom;

        public Builder() {
        }

        public Builder(@NonNull StreetViewPanoramaCamera streetViewPanoramaCamera) {
            zzbq.checkNotNull((Object)((Object)streetViewPanoramaCamera), (Object)"StreetViewPanoramaCamera");
            this.zoom = streetViewPanoramaCamera.zoom;
            this.bearing = streetViewPanoramaCamera.bearing;
            this.tilt = streetViewPanoramaCamera.tilt;
        }

        public final Builder zoom(float f) {
            this.zoom = f;
            return this;
        }

        public final Builder orientation(StreetViewPanoramaOrientation streetViewPanoramaOrientation) {
            zzbq.checkNotNull((Object)((Object)streetViewPanoramaOrientation), (Object)"StreetViewPanoramaOrientation");
            this.tilt = streetViewPanoramaOrientation.tilt;
            this.bearing = streetViewPanoramaOrientation.bearing;
            return this;
        }

        public final Builder tilt(float f) {
            this.tilt = f;
            return this;
        }

        public final Builder bearing(float f) {
            this.bearing = f;
            return this;
        }

        public final StreetViewPanoramaCamera build() {
            return new StreetViewPanoramaCamera(this.zoom, this.tilt, this.bearing);
        }
    }
}

