/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.StrictMode;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.dynamic.zzo;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.OnStreetViewPanoramaReadyCallback;
import com.google.android.gms.maps.StreetViewPanoramaOptions;
import com.google.android.gms.maps.internal.IStreetViewPanoramaViewDelegate;
import com.google.android.gms.maps.internal.StreetViewLifecycleDelegate;
import com.google.android.gms.maps.internal.zzby;
import com.google.android.gms.maps.internal.zzbz;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import com.google.android.gms.maps.zzaj;
import java.util.ArrayList;
import java.util.List;

public class StreetViewPanoramaView
extends FrameLayout {
    private final zzb zziqz;

    public StreetViewPanoramaView(Context context) {
        super(context);
        this.zziqz = new zzb((ViewGroup)this, context, null);
    }

    public StreetViewPanoramaView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.zziqz = new zzb((ViewGroup)this, context, null);
    }

    public StreetViewPanoramaView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.zziqz = new zzb((ViewGroup)this, context, null);
    }

    public StreetViewPanoramaView(Context context, StreetViewPanoramaOptions streetViewPanoramaOptions) {
        super(context);
        this.zziqz = new zzb((ViewGroup)this, context, streetViewPanoramaOptions);
    }

    public final void onCreate(Bundle bundle) {
        StrictMode.ThreadPolicy threadPolicy = StrictMode.getThreadPolicy();
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)new StrictMode.ThreadPolicy.Builder(threadPolicy).permitAll().build());
        try {
            this.zziqz.onCreate(bundle);
            if (this.zziqz.zzapk() == null) {
                com.google.android.gms.dynamic.zza.zzb((FrameLayout)this);
            }
            return;
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
    }

    public final void onResume() {
        this.zziqz.onResume();
    }

    public final void onPause() {
        this.zziqz.onPause();
    }

    public final void onDestroy() {
        this.zziqz.onDestroy();
    }

    public final void onLowMemory() {
        this.zziqz.onLowMemory();
    }

    public final void onSaveInstanceState(Bundle bundle) {
        this.zziqz.onSaveInstanceState(bundle);
    }

    public void getStreetViewPanoramaAsync(OnStreetViewPanoramaReadyCallback onStreetViewPanoramaReadyCallback) {
        zzbq.zzfz((String)"getStreetViewPanoramaAsync() must be called on the main thread");
        this.zziqz.getStreetViewPanoramaAsync(onStreetViewPanoramaReadyCallback);
    }

    static final class zzb
    extends com.google.android.gms.dynamic.zza<zza> {
        private final ViewGroup zziqf;
        private final Context zziqg;
        private zzo<zza> zzipz;
        private final StreetViewPanoramaOptions zzirc;
        private final List<OnStreetViewPanoramaReadyCallback> zziqr = new ArrayList<OnStreetViewPanoramaReadyCallback>();

        zzb(ViewGroup viewGroup, Context context, StreetViewPanoramaOptions streetViewPanoramaOptions) {
            this.zziqf = viewGroup;
            this.zziqg = context;
            this.zzirc = streetViewPanoramaOptions;
        }

        protected final void zza(zzo<zza> zzo2) {
            this.zzipz = zzo2;
            zzb zzb2 = this;
            if (zzb2.zzipz != null && zzb2.zzapk() == null) {
                try {
                    MapsInitializer.initialize(zzb2.zziqg);
                    IStreetViewPanoramaViewDelegate iStreetViewPanoramaViewDelegate = zzbz.zzdq(zzb2.zziqg).zza(zzn.zzy((Object)zzb2.zziqg), zzb2.zzirc);
                    zzb2.zzipz.zza((LifecycleDelegate)new zza(zzb2.zziqf, iStreetViewPanoramaViewDelegate));
                    for (OnStreetViewPanoramaReadyCallback onStreetViewPanoramaReadyCallback : zzb2.zziqr) {
                        ((zza)zzb2.zzapk()).getStreetViewPanoramaAsync(onStreetViewPanoramaReadyCallback);
                    }
                    zzb2.zziqr.clear();
                    return;
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeRemoteException(remoteException);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {}
            }
        }

        public final void getStreetViewPanoramaAsync(OnStreetViewPanoramaReadyCallback onStreetViewPanoramaReadyCallback) {
            if (this.zzapk() != null) {
                ((zza)this.zzapk()).getStreetViewPanoramaAsync(onStreetViewPanoramaReadyCallback);
                return;
            }
            this.zziqr.add(onStreetViewPanoramaReadyCallback);
        }
    }

    static final class zza
    implements StreetViewLifecycleDelegate {
        private final ViewGroup zziqc;
        private final IStreetViewPanoramaViewDelegate zzira;
        private View zzirb;

        public zza(ViewGroup viewGroup, IStreetViewPanoramaViewDelegate iStreetViewPanoramaViewDelegate) {
            this.zzira = (IStreetViewPanoramaViewDelegate)zzbq.checkNotNull((Object)iStreetViewPanoramaViewDelegate);
            this.zziqc = (ViewGroup)zzbq.checkNotNull((Object)viewGroup);
        }

        public final void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            throw new UnsupportedOperationException("onInflate not allowed on StreetViewPanoramaViewDelegate");
        }

        public final void onCreate(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzby.zzd(bundle, bundle2);
                this.zzira.onCreate(bundle2);
                zzby.zzd(bundle2, bundle);
                this.zzirb = (View)zzn.zzx((IObjectWrapper)this.zzira.getView());
                this.zziqc.removeAllViews();
                this.zziqc.addView(this.zzirb);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            throw new UnsupportedOperationException("onCreateView not allowed on StreetViewPanoramaViewDelegate");
        }

        public final void onStart() {
        }

        public final void onResume() {
            try {
                this.zzira.onResume();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onPause() {
            try {
                this.zzira.onPause();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onStop() {
        }

        public final void onDestroyView() {
            throw new UnsupportedOperationException("onDestroyView not allowed on StreetViewPanoramaViewDelegate");
        }

        public final void onDestroy() {
            try {
                this.zzira.onDestroy();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onLowMemory() {
            try {
                this.zzira.onLowMemory();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onSaveInstanceState(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzby.zzd(bundle, bundle2);
                this.zzira.onSaveInstanceState(bundle2);
                zzby.zzd(bundle2, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public final void getStreetViewPanoramaAsync(OnStreetViewPanoramaReadyCallback onStreetViewPanoramaReadyCallback) {
            try {
                this.zzira.getStreetViewPanoramaAsync(new zzaj(this, onStreetViewPanoramaReadyCallback));
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }
    }
}

