/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.graphics.Bitmap;
import android.location.Location;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresPermission;
import android.view.View;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.maps.CameraUpdate;
import com.google.android.gms.maps.LocationSource;
import com.google.android.gms.maps.Projection;
import com.google.android.gms.maps.UiSettings;
import com.google.android.gms.maps.internal.IGoogleMapDelegate;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.Circle;
import com.google.android.gms.maps.model.CircleOptions;
import com.google.android.gms.maps.model.GroundOverlay;
import com.google.android.gms.maps.model.GroundOverlayOptions;
import com.google.android.gms.maps.model.IndoorBuilding;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.MapStyleOptions;
import com.google.android.gms.maps.model.Marker;
import com.google.android.gms.maps.model.MarkerOptions;
import com.google.android.gms.maps.model.PointOfInterest;
import com.google.android.gms.maps.model.Polygon;
import com.google.android.gms.maps.model.PolygonOptions;
import com.google.android.gms.maps.model.Polyline;
import com.google.android.gms.maps.model.PolylineOptions;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import com.google.android.gms.maps.model.TileOverlay;
import com.google.android.gms.maps.model.TileOverlayOptions;
import com.google.android.gms.maps.model.internal.zzg;
import com.google.android.gms.maps.model.internal.zzj;
import com.google.android.gms.maps.model.internal.zzw;
import com.google.android.gms.maps.zzb;
import com.google.android.gms.maps.zzc;
import com.google.android.gms.maps.zzd;
import com.google.android.gms.maps.zze;
import com.google.android.gms.maps.zzf;
import com.google.android.gms.maps.zzh;
import com.google.android.gms.maps.zzi;
import com.google.android.gms.maps.zzk;
import com.google.android.gms.maps.zzl;
import com.google.android.gms.maps.zzn;
import com.google.android.gms.maps.zzo;
import com.google.android.gms.maps.zzp;
import com.google.android.gms.maps.zzq;
import com.google.android.gms.maps.zzr;
import com.google.android.gms.maps.zzs;
import com.google.android.gms.maps.zzt;
import com.google.android.gms.maps.zzu;
import com.google.android.gms.maps.zzv;
import com.google.android.gms.maps.zzx;
import com.google.android.gms.maps.zzy;
import com.google.android.gms.maps.zzz;

public final class GoogleMap {
    public static final int MAP_TYPE_NONE = 0;
    public static final int MAP_TYPE_NORMAL = 1;
    public static final int MAP_TYPE_SATELLITE = 2;
    public static final int MAP_TYPE_TERRAIN = 3;
    public static final int MAP_TYPE_HYBRID = 4;
    private final IGoogleMapDelegate zziod;
    private UiSettings zzioe;

    public GoogleMap(IGoogleMapDelegate iGoogleMapDelegate) {
        this.zziod = (IGoogleMapDelegate)zzbq.checkNotNull((Object)iGoogleMapDelegate);
    }

    public final CameraPosition getCameraPosition() {
        try {
            return this.zziod.getCameraPosition();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final float getMaxZoomLevel() {
        try {
            return this.zziod.getMaxZoomLevel();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final float getMinZoomLevel() {
        try {
            return this.zziod.getMinZoomLevel();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void moveCamera(CameraUpdate cameraUpdate) {
        try {
            this.zziod.moveCamera(cameraUpdate.zzavn());
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void animateCamera(CameraUpdate cameraUpdate) {
        try {
            this.zziod.animateCamera(cameraUpdate.zzavn());
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void animateCamera(CameraUpdate cameraUpdate, CancelableCallback cancelableCallback) {
        try {
            this.zziod.animateCameraWithCallback(cameraUpdate.zzavn(), cancelableCallback == null ? null : new zza(cancelableCallback));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void animateCamera(CameraUpdate cameraUpdate, int n, CancelableCallback cancelableCallback) {
        try {
            this.zziod.animateCameraWithDurationAndCallback(cameraUpdate.zzavn(), n, cancelableCallback == null ? null : new zza(cancelableCallback));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void stopAnimation() {
        try {
            this.zziod.stopAnimation();
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final Polyline addPolyline(PolylineOptions polylineOptions) {
        try {
            return new Polyline(this.zziod.addPolyline(polylineOptions));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final Polygon addPolygon(PolygonOptions polygonOptions) {
        try {
            return new Polygon(this.zziod.addPolygon(polygonOptions));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final Circle addCircle(CircleOptions circleOptions) {
        try {
            return new Circle(this.zziod.addCircle(circleOptions));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final Marker addMarker(MarkerOptions markerOptions) {
        try {
            com.google.android.gms.maps.model.internal.zzp zzp2 = this.zziod.addMarker(markerOptions);
            if (zzp2 != null) {
                return new Marker(zzp2);
            }
            return null;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final GroundOverlay addGroundOverlay(GroundOverlayOptions groundOverlayOptions) {
        try {
            zzg zzg2 = this.zziod.addGroundOverlay(groundOverlayOptions);
            if (zzg2 != null) {
                return new GroundOverlay(zzg2);
            }
            return null;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final TileOverlay addTileOverlay(TileOverlayOptions tileOverlayOptions) {
        try {
            zzw zzw2 = this.zziod.addTileOverlay(tileOverlayOptions);
            if (zzw2 != null) {
                return new TileOverlay(zzw2);
            }
            return null;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void clear() {
        try {
            this.zziod.clear();
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final IndoorBuilding getFocusedBuilding() {
        try {
            zzj zzj2 = this.zziod.getFocusedBuilding();
            if (zzj2 != null) {
                return new IndoorBuilding(zzj2);
            }
            return null;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnIndoorStateChangeListener(OnIndoorStateChangeListener onIndoorStateChangeListener) {
        try {
            if (onIndoorStateChangeListener == null) {
                this.zziod.setOnIndoorStateChangeListener(null);
                return;
            }
            this.zziod.setOnIndoorStateChangeListener(new com.google.android.gms.maps.zza(this, onIndoorStateChangeListener));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final int getMapType() {
        try {
            return this.zziod.getMapType();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setMapType(int n) {
        try {
            this.zziod.setMapType(n);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean isTrafficEnabled() {
        try {
            return this.zziod.isTrafficEnabled();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setTrafficEnabled(boolean bl) {
        try {
            this.zziod.setTrafficEnabled(bl);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean isIndoorEnabled() {
        try {
            return this.zziod.isIndoorEnabled();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean setIndoorEnabled(boolean bl) {
        try {
            return this.zziod.setIndoorEnabled(bl);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean isBuildingsEnabled() {
        try {
            return this.zziod.isBuildingsEnabled();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setBuildingsEnabled(boolean bl) {
        try {
            this.zziod.setBuildingsEnabled(bl);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean isMyLocationEnabled() {
        try {
            return this.zziod.isMyLocationEnabled();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public final void setMyLocationEnabled(boolean bl) {
        try {
            this.zziod.setMyLocationEnabled(bl);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    @Deprecated
    public final Location getMyLocation() {
        try {
            return this.zziod.getMyLocation();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setLocationSource(LocationSource locationSource) {
        try {
            if (locationSource == null) {
                this.zziod.setLocationSource(null);
                return;
            }
            this.zziod.setLocationSource(new zzl(this, locationSource));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final UiSettings getUiSettings() {
        try {
            if (this.zzioe == null) {
                this.zzioe = new UiSettings(this.zziod.getUiSettings());
            }
            return this.zzioe;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final Projection getProjection() {
        try {
            return new Projection(this.zziod.getProjection());
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    @Deprecated
    public final void setOnCameraChangeListener(OnCameraChangeListener onCameraChangeListener) {
        try {
            if (onCameraChangeListener == null) {
                this.zziod.setOnCameraChangeListener(null);
                return;
            }
            this.zziod.setOnCameraChangeListener(new zzt(this, onCameraChangeListener));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnCameraMoveStartedListener(OnCameraMoveStartedListener onCameraMoveStartedListener) {
        try {
            if (onCameraMoveStartedListener == null) {
                this.zziod.setOnCameraMoveStartedListener(null);
                return;
            }
            this.zziod.setOnCameraMoveStartedListener(new zzu(this, onCameraMoveStartedListener));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnCameraMoveListener(OnCameraMoveListener onCameraMoveListener) {
        try {
            if (onCameraMoveListener == null) {
                this.zziod.setOnCameraMoveListener(null);
                return;
            }
            this.zziod.setOnCameraMoveListener(new zzv(this, onCameraMoveListener));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnCameraMoveCanceledListener(OnCameraMoveCanceledListener onCameraMoveCanceledListener) {
        try {
            if (onCameraMoveCanceledListener == null) {
                this.zziod.setOnCameraMoveCanceledListener(null);
                return;
            }
            this.zziod.setOnCameraMoveCanceledListener(new com.google.android.gms.maps.zzw(this, onCameraMoveCanceledListener));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnCameraIdleListener(OnCameraIdleListener onCameraIdleListener) {
        try {
            if (onCameraIdleListener == null) {
                this.zziod.setOnCameraIdleListener(null);
                return;
            }
            this.zziod.setOnCameraIdleListener(new zzx(this, onCameraIdleListener));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnMapClickListener(OnMapClickListener onMapClickListener) {
        try {
            if (onMapClickListener == null) {
                this.zziod.setOnMapClickListener(null);
                return;
            }
            this.zziod.setOnMapClickListener(new zzy(this, onMapClickListener));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnMapLongClickListener(OnMapLongClickListener onMapLongClickListener) {
        try {
            if (onMapLongClickListener == null) {
                this.zziod.setOnMapLongClickListener(null);
                return;
            }
            this.zziod.setOnMapLongClickListener(new zzz(this, onMapLongClickListener));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnMarkerClickListener(OnMarkerClickListener onMarkerClickListener) {
        try {
            if (onMarkerClickListener == null) {
                this.zziod.setOnMarkerClickListener(null);
                return;
            }
            this.zziod.setOnMarkerClickListener(new zzb(this, onMarkerClickListener));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnMarkerDragListener(OnMarkerDragListener onMarkerDragListener) {
        try {
            if (onMarkerDragListener == null) {
                this.zziod.setOnMarkerDragListener(null);
                return;
            }
            this.zziod.setOnMarkerDragListener(new zzc(this, onMarkerDragListener));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnInfoWindowClickListener(OnInfoWindowClickListener onInfoWindowClickListener) {
        try {
            if (onInfoWindowClickListener == null) {
                this.zziod.setOnInfoWindowClickListener(null);
                return;
            }
            this.zziod.setOnInfoWindowClickListener(new zzd(this, onInfoWindowClickListener));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnInfoWindowLongClickListener(OnInfoWindowLongClickListener onInfoWindowLongClickListener) {
        try {
            if (onInfoWindowLongClickListener == null) {
                this.zziod.setOnInfoWindowLongClickListener(null);
                return;
            }
            this.zziod.setOnInfoWindowLongClickListener(new zze(this, onInfoWindowLongClickListener));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnInfoWindowCloseListener(OnInfoWindowCloseListener onInfoWindowCloseListener) {
        try {
            if (onInfoWindowCloseListener == null) {
                this.zziod.setOnInfoWindowCloseListener(null);
                return;
            }
            this.zziod.setOnInfoWindowCloseListener(new zzf(this, onInfoWindowCloseListener));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setInfoWindowAdapter(InfoWindowAdapter infoWindowAdapter) {
        try {
            if (infoWindowAdapter == null) {
                this.zziod.setInfoWindowAdapter(null);
                return;
            }
            this.zziod.setInfoWindowAdapter(new com.google.android.gms.maps.zzg(this, infoWindowAdapter));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    @Deprecated
    public final void setOnMyLocationChangeListener(OnMyLocationChangeListener onMyLocationChangeListener) {
        try {
            if (onMyLocationChangeListener == null) {
                this.zziod.setOnMyLocationChangeListener(null);
                return;
            }
            this.zziod.setOnMyLocationChangeListener(new zzh(this, onMyLocationChangeListener));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnMyLocationButtonClickListener(OnMyLocationButtonClickListener onMyLocationButtonClickListener) {
        try {
            if (onMyLocationButtonClickListener == null) {
                this.zziod.setOnMyLocationButtonClickListener(null);
                return;
            }
            this.zziod.setOnMyLocationButtonClickListener(new zzi(this, onMyLocationButtonClickListener));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnMyLocationClickListener(OnMyLocationClickListener onMyLocationClickListener) {
        try {
            if (onMyLocationClickListener == null) {
                this.zziod.setOnMyLocationClickListener(null);
                return;
            }
            this.zziod.setOnMyLocationClickListener(new com.google.android.gms.maps.zzj(this, onMyLocationClickListener));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnMapLoadedCallback(OnMapLoadedCallback onMapLoadedCallback) {
        try {
            if (onMapLoadedCallback == null) {
                this.zziod.setOnMapLoadedCallback(null);
                return;
            }
            this.zziod.setOnMapLoadedCallback(new zzk(this, onMapLoadedCallback));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnGroundOverlayClickListener(OnGroundOverlayClickListener onGroundOverlayClickListener) {
        try {
            if (onGroundOverlayClickListener == null) {
                this.zziod.setOnGroundOverlayClickListener(null);
                return;
            }
            this.zziod.setOnGroundOverlayClickListener(new zzn(this, onGroundOverlayClickListener));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnCircleClickListener(OnCircleClickListener onCircleClickListener) {
        try {
            if (onCircleClickListener == null) {
                this.zziod.setOnCircleClickListener(null);
                return;
            }
            this.zziod.setOnCircleClickListener(new zzo(this, onCircleClickListener));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnPolygonClickListener(OnPolygonClickListener onPolygonClickListener) {
        try {
            if (onPolygonClickListener == null) {
                this.zziod.setOnPolygonClickListener(null);
                return;
            }
            this.zziod.setOnPolygonClickListener(new zzp(this, onPolygonClickListener));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnPolylineClickListener(OnPolylineClickListener onPolylineClickListener) {
        try {
            if (onPolylineClickListener == null) {
                this.zziod.setOnPolylineClickListener(null);
                return;
            }
            this.zziod.setOnPolylineClickListener(new zzq(this, onPolylineClickListener));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void snapshot(SnapshotReadyCallback snapshotReadyCallback) {
        this.snapshot(snapshotReadyCallback, null);
    }

    public final void snapshot(SnapshotReadyCallback snapshotReadyCallback, Bitmap bitmap) {
        com.google.android.gms.dynamic.zzn zzn2 = (com.google.android.gms.dynamic.zzn)(bitmap != null ? com.google.android.gms.dynamic.zzn.zzy((Object)bitmap) : null);
        try {
            this.zziod.snapshot(new zzr(this, snapshotReadyCallback), (IObjectWrapper)zzn2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setPadding(int n, int n2, int n3, int n4) {
        try {
            this.zziod.setPadding(n, n2, n3, n4);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setContentDescription(String string) {
        try {
            this.zziod.setContentDescription(string);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnPoiClickListener(OnPoiClickListener onPoiClickListener) {
        try {
            if (onPoiClickListener == null) {
                this.zziod.setOnPoiClickListener(null);
                return;
            }
            this.zziod.setOnPoiClickListener(new zzs(this, onPoiClickListener));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean setMapStyle(MapStyleOptions mapStyleOptions) {
        try {
            return this.zziod.setMapStyle(mapStyleOptions);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setMinZoomPreference(float f) {
        try {
            this.zziod.setMinZoomPreference(f);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setMaxZoomPreference(float f) {
        try {
            this.zziod.setMaxZoomPreference(f);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void resetMinMaxZoomPreference() {
        try {
            this.zziod.resetMinMaxZoomPreference();
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setLatLngBoundsForCameraTarget(LatLngBounds latLngBounds) {
        try {
            this.zziod.setLatLngBoundsForCameraTarget(latLngBounds);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public static interface OnPoiClickListener {
        public void onPoiClick(PointOfInterest var1);
    }

    static final class zza
    extends com.google.android.gms.maps.internal.zzd {
        private final CancelableCallback zzipf;

        zza(CancelableCallback cancelableCallback) {
            this.zzipf = cancelableCallback;
        }

        @Override
        public final void onFinish() {
            this.zzipf.onFinish();
        }

        @Override
        public final void onCancel() {
            this.zzipf.onCancel();
        }
    }

    public static interface OnGroundOverlayClickListener {
        public void onGroundOverlayClick(GroundOverlay var1);
    }

    public static interface OnMapLoadedCallback {
        public void onMapLoaded();
    }

    public static interface OnMyLocationClickListener {
        public void onMyLocationClick(@NonNull Location var1);
    }

    public static interface OnMyLocationButtonClickListener {
        public boolean onMyLocationButtonClick();
    }

    @Deprecated
    public static interface OnMyLocationChangeListener {
        public void onMyLocationChange(Location var1);
    }

    public static interface InfoWindowAdapter {
        public View getInfoWindow(Marker var1);

        public View getInfoContents(Marker var1);
    }

    public static interface SnapshotReadyCallback {
        public void onSnapshotReady(Bitmap var1);
    }

    public static interface CancelableCallback {
        public void onFinish();

        public void onCancel();
    }

    public static interface OnInfoWindowCloseListener {
        public void onInfoWindowClose(Marker var1);
    }

    public static interface OnInfoWindowLongClickListener {
        public void onInfoWindowLongClick(Marker var1);
    }

    public static interface OnInfoWindowClickListener {
        public void onInfoWindowClick(Marker var1);
    }

    public static interface OnMarkerDragListener {
        public void onMarkerDragStart(Marker var1);

        public void onMarkerDrag(Marker var1);

        public void onMarkerDragEnd(Marker var1);
    }

    public static interface OnMarkerClickListener {
        public boolean onMarkerClick(Marker var1);
    }

    public static interface OnPolylineClickListener {
        public void onPolylineClick(Polyline var1);
    }

    public static interface OnPolygonClickListener {
        public void onPolygonClick(Polygon var1);
    }

    public static interface OnCircleClickListener {
        public void onCircleClick(Circle var1);
    }

    @Deprecated
    public static interface OnCameraChangeListener {
        public void onCameraChange(CameraPosition var1);
    }

    public static interface OnCameraIdleListener {
        public void onCameraIdle();
    }

    public static interface OnCameraMoveCanceledListener {
        public void onCameraMoveCanceled();
    }

    public static interface OnCameraMoveListener {
        public void onCameraMove();
    }

    public static interface OnCameraMoveStartedListener {
        public static final int REASON_GESTURE = 1;
        public static final int REASON_API_ANIMATION = 2;
        public static final int REASON_DEVELOPER_ANIMATION = 3;

        public void onCameraMoveStarted(int var1);
    }

    public static interface OnMapLongClickListener {
        public void onMapLongClick(LatLng var1);
    }

    public static interface OnMapClickListener {
        public void onMapClick(LatLng var1);
    }

    public static interface OnIndoorStateChangeListener {
        public void onIndoorBuildingFocused();

        public void onIndoorLevelActivated(IndoorBuilding var1);
    }
}

