/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.internal.zzbej;
import com.google.android.gms.internal.zzbem;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PatternItem;
import com.google.android.gms.maps.model.zzk;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class PolygonOptions
extends zzbej {
    public static final Parcelable.Creator<PolygonOptions> CREATOR = new zzk();
    private final List<LatLng> zzitd;
    private final List<List<LatLng>> zzite;
    private float mStrokeWidth = 10.0f;
    private int mStrokeColor = -16777216;
    private int mFillColor = 0;
    private float zzisb = 0.0f;
    private boolean zzisc = true;
    private boolean zzitf = false;
    private boolean zzisd = false;
    private int zzitg = 0;
    @Nullable
    private List<PatternItem> zzise = null;

    public PolygonOptions() {
        this.zzitd = new ArrayList<LatLng>();
        this.zzite = new ArrayList<List<LatLng>>();
    }

    PolygonOptions(List<LatLng> list, List list2, float f, int n, int n2, float f2, boolean bl, boolean bl2, boolean bl3, int n3, @Nullable List<PatternItem> list3) {
        this.zzitd = list;
        this.zzite = list2;
        this.mStrokeWidth = f;
        this.mStrokeColor = n;
        this.mFillColor = n2;
        this.zzisb = f2;
        this.zzisc = bl;
        this.zzitf = bl2;
        this.zzisd = bl3;
        this.zzitg = n3;
        this.zzise = list3;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PolygonOptions polygonOptions = this;
        int n2 = zzbem.zze((Parcel)parcel2);
        zzbem.zzc((Parcel)parcel2, (int)2, polygonOptions.getPoints(), (boolean)false);
        zzbem.zzd((Parcel)parcel2, (int)3, polygonOptions.zzite, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)4, (float)polygonOptions.getStrokeWidth());
        zzbem.zzc((Parcel)parcel2, (int)5, (int)polygonOptions.getStrokeColor());
        zzbem.zzc((Parcel)parcel2, (int)6, (int)polygonOptions.getFillColor());
        zzbem.zza((Parcel)parcel2, (int)7, (float)polygonOptions.getZIndex());
        zzbem.zza((Parcel)parcel2, (int)8, (boolean)polygonOptions.isVisible());
        zzbem.zza((Parcel)parcel2, (int)9, (boolean)polygonOptions.isGeodesic());
        zzbem.zza((Parcel)parcel2, (int)10, (boolean)polygonOptions.isClickable());
        zzbem.zzc((Parcel)parcel2, (int)11, (int)polygonOptions.getStrokeJointType());
        zzbem.zzc((Parcel)parcel2, (int)12, polygonOptions.getStrokePattern(), (boolean)false);
        zzbem.zzai((Parcel)parcel2, (int)n2);
    }

    public final PolygonOptions add(LatLng latLng) {
        this.zzitd.add(latLng);
        return this;
    }

    public final PolygonOptions add(LatLng ... latLngArray) {
        this.zzitd.addAll(Arrays.asList(latLngArray));
        return this;
    }

    public final PolygonOptions addAll(Iterable<LatLng> iterable) {
        for (LatLng latLng : iterable) {
            this.zzitd.add(latLng);
        }
        return this;
    }

    public final PolygonOptions addHole(Iterable<LatLng> iterable) {
        ArrayList<LatLng> arrayList = new ArrayList<LatLng>();
        for (LatLng latLng : iterable) {
            arrayList.add(latLng);
        }
        this.zzite.add(arrayList);
        return this;
    }

    public final PolygonOptions strokeWidth(float f) {
        this.mStrokeWidth = f;
        return this;
    }

    public final PolygonOptions strokeColor(int n) {
        this.mStrokeColor = n;
        return this;
    }

    public final PolygonOptions strokeJointType(int n) {
        this.zzitg = n;
        return this;
    }

    public final PolygonOptions strokePattern(@Nullable List<PatternItem> list) {
        this.zzise = list;
        return this;
    }

    public final PolygonOptions fillColor(int n) {
        this.mFillColor = n;
        return this;
    }

    public final PolygonOptions zIndex(float f) {
        this.zzisb = f;
        return this;
    }

    public final PolygonOptions visible(boolean bl) {
        this.zzisc = bl;
        return this;
    }

    public final PolygonOptions geodesic(boolean bl) {
        this.zzitf = bl;
        return this;
    }

    public final PolygonOptions clickable(boolean bl) {
        this.zzisd = bl;
        return this;
    }

    public final List<LatLng> getPoints() {
        return this.zzitd;
    }

    public final List<List<LatLng>> getHoles() {
        return this.zzite;
    }

    public final float getStrokeWidth() {
        return this.mStrokeWidth;
    }

    public final int getStrokeColor() {
        return this.mStrokeColor;
    }

    public final int getStrokeJointType() {
        return this.zzitg;
    }

    @Nullable
    public final List<PatternItem> getStrokePattern() {
        return this.zzise;
    }

    public final int getFillColor() {
        return this.mFillColor;
    }

    public final float getZIndex() {
        return this.zzisb;
    }

    public final boolean isVisible() {
        return this.zzisc;
    }

    public final boolean isGeodesic() {
        return this.zzitf;
    }

    public final boolean isClickable() {
        return this.zzisd;
    }
}

