/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbej;
import com.google.android.gms.internal.zzbem;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.zze;
import java.util.Arrays;

public final class LatLngBounds
extends zzbej
implements ReflectedParcelable {
    public static final Parcelable.Creator<LatLngBounds> CREATOR = new zze();
    public final LatLng southwest;
    public final LatLng northeast;

    public LatLngBounds(LatLng latLng, LatLng latLng2) {
        zzbq.checkNotNull((Object)((Object)latLng), (Object)"null southwest");
        zzbq.checkNotNull((Object)((Object)latLng2), (Object)"null northeast");
        zzbq.zzb((latLng2.latitude >= latLng.latitude ? 1 : 0) != 0, (String)"southern latitude exceeds northern latitude (%s > %s)", (Object[])new Object[]{latLng.latitude, latLng2.latitude});
        this.southwest = latLng;
        this.northeast = latLng2;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        LatLngBounds latLngBounds = this;
        int n2 = zzbem.zze((Parcel)parcel2);
        zzbem.zza((Parcel)parcel2, (int)2, (Parcelable)latLngBounds.southwest, (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)3, (Parcelable)latLngBounds.northeast, (int)n, (boolean)false);
        zzbem.zzai((Parcel)parcel2, (int)n2);
    }

    public static Builder builder() {
        return new Builder();
    }

    public final boolean contains(LatLng latLng) {
        LatLngBounds latLngBounds;
        LatLng latLng2 = latLng;
        double d = latLng2.latitude;
        LatLngBounds latLngBounds2 = this;
        return latLngBounds.southwest.latitude <= d && d <= latLngBounds2.northeast.latitude && this.zzg(latLng2.longitude);
    }

    public final LatLngBounds including(LatLng latLng) {
        LatLng latLng2 = latLng;
        double d = Math.min(this.southwest.latitude, latLng2.latitude);
        double d2 = Math.max(this.northeast.latitude, latLng2.latitude);
        double d3 = this.northeast.longitude;
        double d4 = this.southwest.longitude;
        double d5 = latLng2.longitude;
        if (!this.zzg(d5)) {
            if (LatLngBounds.zza(d4, d5) < LatLngBounds.zzb(d3, d5)) {
                d4 = d5;
            } else {
                d3 = d5;
            }
        }
        return new LatLngBounds(new LatLng(d, d4), new LatLng(d2, d3));
    }

    public final LatLng getCenter() {
        double d;
        double d2 = (this.southwest.latitude + this.northeast.latitude) / 2.0;
        double d3 = this.northeast.longitude;
        double d4 = this.southwest.longitude;
        double d5 = d <= d3 ? (d3 + d4) / 2.0 : (d3 + 360.0 + d4) / 2.0;
        return new LatLng(d2, d5);
    }

    private static double zza(double d, double d2) {
        return (d - d2 + 360.0) % 360.0;
    }

    private static double zzb(double d, double d2) {
        return (d2 - d + 360.0) % 360.0;
    }

    private final boolean zzg(double d) {
        if (this.southwest.longitude <= this.northeast.longitude) {
            return this.southwest.longitude <= d && d <= this.northeast.longitude;
        }
        return this.southwest.longitude <= d || d <= this.northeast.longitude;
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.southwest, this.northeast});
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LatLngBounds)) {
            return false;
        }
        LatLngBounds latLngBounds = (LatLngBounds)((Object)object);
        return this.southwest.equals((Object)latLngBounds.southwest) && this.northeast.equals((Object)latLngBounds.northeast);
    }

    public final String toString() {
        return zzbg.zzw((Object)((Object)this)).zzg("southwest", (Object)this.southwest).zzg("northeast", (Object)this.northeast).toString();
    }

    public static LatLngBounds createFromAttributes(Context context, AttributeSet attributeSet) {
        if (context == null || attributeSet == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attributeSet, R.styleable.MapAttrs);
        Float f = null;
        Float f2 = null;
        if (typedArray.hasValue(R.styleable.MapAttrs_latLngBoundsSouthWestLatitude)) {
            f = Float.valueOf(typedArray.getFloat(R.styleable.MapAttrs_latLngBoundsSouthWestLatitude, 0.0f));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_latLngBoundsSouthWestLongitude)) {
            f2 = Float.valueOf(typedArray.getFloat(R.styleable.MapAttrs_latLngBoundsSouthWestLongitude, 0.0f));
        }
        Float f3 = null;
        Float f4 = null;
        if (typedArray.hasValue(R.styleable.MapAttrs_latLngBoundsNorthEastLatitude)) {
            f3 = Float.valueOf(typedArray.getFloat(R.styleable.MapAttrs_latLngBoundsNorthEastLatitude, 0.0f));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_latLngBoundsNorthEastLongitude)) {
            f4 = Float.valueOf(typedArray.getFloat(R.styleable.MapAttrs_latLngBoundsNorthEastLongitude, 0.0f));
        }
        if (f == null || f2 == null || f3 == null || f4 == null) {
            return null;
        }
        LatLng latLng = new LatLng(f.floatValue(), f2.floatValue());
        LatLng latLng2 = new LatLng(f3.floatValue(), f4.floatValue());
        return new LatLngBounds(latLng, latLng2);
    }

    public static final class Builder {
        private double zzisp = Double.POSITIVE_INFINITY;
        private double zzisq = Double.NEGATIVE_INFINITY;
        private double zzisr = Double.NaN;
        private double zziss = Double.NaN;

        public Builder() {
        }

        /*
         * Enabled aggressive block sorting
         */
        public final Builder include(LatLng latLng) {
            this.zzisp = Math.min(this.zzisp, latLng.latitude);
            this.zzisq = Math.max(this.zzisq, latLng.latitude);
            double d = latLng.longitude;
            if (Double.isNaN(this.zzisr)) {
                this.zzisr = d;
            } else {
                Builder builder;
                Builder builder2 = this;
                if (builder.zzisr <= builder2.zziss ? builder2.zzisr <= d && d <= builder2.zziss : builder2.zzisr <= d || d <= builder2.zziss) return this;
                if (LatLngBounds.zza(this.zzisr, d) < LatLngBounds.zzb(this.zziss, d)) {
                    this.zzisr = d;
                    return this;
                }
            }
            this.zziss = d;
            return this;
        }

        public final LatLngBounds build() {
            zzbq.zza((!Double.isNaN(this.zzisr) ? 1 : 0) != 0, (Object)"no included points");
            return new LatLngBounds(new LatLng(this.zzisp, this.zzisr), new LatLng(this.zzisq, this.zziss));
        }
    }
}

