/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.internal.zzbej;
import com.google.android.gms.internal.zzbem;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.zzd;

public final class GroundOverlayOptions
extends zzbej {
    public static final Parcelable.Creator<GroundOverlayOptions> CREATOR = new zzd();
    public static final float NO_DIMENSION = -1.0f;
    @NonNull
    private BitmapDescriptor zzisg;
    private LatLng zzish;
    private float zzisi;
    private float zzisj;
    private LatLngBounds zziog;
    private float zzirw;
    private float zzisb;
    private boolean zzisc = true;
    private float zzisk = 0.0f;
    private float zzisl = 0.5f;
    private float zzism = 0.5f;
    private boolean zzisd = false;

    GroundOverlayOptions(IBinder iBinder, LatLng latLng, float f, float f2, LatLngBounds latLngBounds, float f3, float f4, boolean bl, float f5, float f6, float f7, boolean bl2) {
        this.zzisg = new BitmapDescriptor(IObjectWrapper.zza.zzap((IBinder)iBinder));
        this.zzish = latLng;
        this.zzisi = f;
        this.zzisj = f2;
        this.zziog = latLngBounds;
        this.zzirw = f3;
        this.zzisb = f4;
        this.zzisc = bl;
        this.zzisk = f5;
        this.zzisl = f6;
        this.zzism = f7;
        this.zzisd = bl2;
    }

    public GroundOverlayOptions() {
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GroundOverlayOptions groundOverlayOptions = this;
        int n2 = zzbem.zze((Parcel)parcel2);
        zzbem.zza((Parcel)parcel2, (int)2, (IBinder)groundOverlayOptions.zzisg.zzavo().asBinder(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)3, (Parcelable)groundOverlayOptions.getLocation(), (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)4, (float)groundOverlayOptions.getWidth());
        zzbem.zza((Parcel)parcel2, (int)5, (float)groundOverlayOptions.getHeight());
        zzbem.zza((Parcel)parcel2, (int)6, (Parcelable)groundOverlayOptions.getBounds(), (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)7, (float)groundOverlayOptions.getBearing());
        zzbem.zza((Parcel)parcel2, (int)8, (float)groundOverlayOptions.getZIndex());
        zzbem.zza((Parcel)parcel2, (int)9, (boolean)groundOverlayOptions.isVisible());
        zzbem.zza((Parcel)parcel2, (int)10, (float)groundOverlayOptions.getTransparency());
        zzbem.zza((Parcel)parcel2, (int)11, (float)groundOverlayOptions.getAnchorU());
        zzbem.zza((Parcel)parcel2, (int)12, (float)groundOverlayOptions.getAnchorV());
        zzbem.zza((Parcel)parcel2, (int)13, (boolean)groundOverlayOptions.isClickable());
        zzbem.zzai((Parcel)parcel2, (int)n2);
    }

    public final GroundOverlayOptions image(@NonNull BitmapDescriptor bitmapDescriptor) {
        zzbq.checkNotNull((Object)bitmapDescriptor, (Object)"imageDescriptor must not be null");
        this.zzisg = bitmapDescriptor;
        return this;
    }

    public final GroundOverlayOptions anchor(float f, float f2) {
        this.zzisl = f;
        this.zzism = f2;
        return this;
    }

    public final GroundOverlayOptions position(LatLng latLng, float f) {
        zzbq.zza((this.zziog == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        zzbq.checkArgument((latLng != null ? 1 : 0) != 0, (Object)"Location must be specified");
        zzbq.checkArgument((f >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        return this.zza(latLng, f, -1.0f);
    }

    public final GroundOverlayOptions position(LatLng latLng, float f, float f2) {
        zzbq.zza((this.zziog == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        zzbq.checkArgument((latLng != null ? 1 : 0) != 0, (Object)"Location must be specified");
        zzbq.checkArgument((f >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        zzbq.checkArgument((f2 >= 0.0f ? 1 : 0) != 0, (Object)"Height must be non-negative");
        return this.zza(latLng, f, f2);
    }

    private final GroundOverlayOptions zza(LatLng latLng, float f, float f2) {
        this.zzish = latLng;
        this.zzisi = f;
        this.zzisj = f2;
        return this;
    }

    public final GroundOverlayOptions positionFromBounds(LatLngBounds latLngBounds) {
        String string = String.valueOf((Object)this.zzish);
        zzbq.zza((this.zzish == null ? 1 : 0) != 0, (Object)new StringBuilder(46 + String.valueOf(string).length()).append("Position has already been set using position: ").append(string).toString());
        this.zziog = latLngBounds;
        return this;
    }

    public final GroundOverlayOptions bearing(float f) {
        this.zzirw = (f % 360.0f + 360.0f) % 360.0f;
        return this;
    }

    public final GroundOverlayOptions zIndex(float f) {
        this.zzisb = f;
        return this;
    }

    public final GroundOverlayOptions visible(boolean bl) {
        this.zzisc = bl;
        return this;
    }

    public final GroundOverlayOptions transparency(float f) {
        zzbq.checkArgument((f >= 0.0f && f <= 1.0f ? 1 : 0) != 0, (Object)"Transparency must be in the range [0..1]");
        this.zzisk = f;
        return this;
    }

    public final GroundOverlayOptions clickable(boolean bl) {
        this.zzisd = bl;
        return this;
    }

    public final BitmapDescriptor getImage() {
        return this.zzisg;
    }

    public final LatLng getLocation() {
        return this.zzish;
    }

    public final float getWidth() {
        return this.zzisi;
    }

    public final float getHeight() {
        return this.zzisj;
    }

    public final LatLngBounds getBounds() {
        return this.zziog;
    }

    public final float getBearing() {
        return this.zzirw;
    }

    public final float getZIndex() {
        return this.zzisb;
    }

    public final float getTransparency() {
        return this.zzisk;
    }

    public final float getAnchorU() {
        return this.zzisl;
    }

    public final float getAnchorV() {
        return this.zzism;
    }

    public final boolean isVisible() {
        return this.zzisc;
    }

    public final boolean isClickable() {
        return this.zzisd;
    }
}

