/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.StrictMode;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.dynamic.zzo;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.OnStreetViewPanoramaReadyCallback;
import com.google.android.gms.maps.StreetViewPanoramaOptions;
import com.google.android.gms.maps.internal.IStreetViewPanoramaViewDelegate;
import com.google.android.gms.maps.internal.StreetViewLifecycleDelegate;
import com.google.android.gms.maps.internal.zzby;
import com.google.android.gms.maps.internal.zzbz;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import com.google.android.gms.maps.zzaj;
import java.util.ArrayList;
import java.util.List;

public class StreetViewPanoramaView
extends FrameLayout {
    private final zzb zzirj;

    public StreetViewPanoramaView(Context context) {
        super(context);
        this.zzirj = new zzb((ViewGroup)this, context, null);
    }

    public StreetViewPanoramaView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.zzirj = new zzb((ViewGroup)this, context, null);
    }

    public StreetViewPanoramaView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.zzirj = new zzb((ViewGroup)this, context, null);
    }

    public StreetViewPanoramaView(Context context, StreetViewPanoramaOptions streetViewPanoramaOptions) {
        super(context);
        this.zzirj = new zzb((ViewGroup)this, context, streetViewPanoramaOptions);
    }

    public final void onCreate(Bundle bundle) {
        StrictMode.ThreadPolicy threadPolicy = StrictMode.getThreadPolicy();
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)new StrictMode.ThreadPolicy.Builder(threadPolicy).permitAll().build());
        try {
            this.zzirj.onCreate(bundle);
            if (this.zzirj.zzapl() == null) {
                com.google.android.gms.dynamic.zza.zzb((FrameLayout)this);
            }
            return;
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
    }

    public final void onResume() {
        this.zzirj.onResume();
    }

    public final void onPause() {
        this.zzirj.onPause();
    }

    public final void onDestroy() {
        this.zzirj.onDestroy();
    }

    public final void onLowMemory() {
        this.zzirj.onLowMemory();
    }

    public final void onSaveInstanceState(Bundle bundle) {
        this.zzirj.onSaveInstanceState(bundle);
    }

    public void getStreetViewPanoramaAsync(OnStreetViewPanoramaReadyCallback onStreetViewPanoramaReadyCallback) {
        zzbq.zzga((String)"getStreetViewPanoramaAsync() must be called on the main thread");
        this.zzirj.getStreetViewPanoramaAsync(onStreetViewPanoramaReadyCallback);
    }

    static final class zzb
    extends com.google.android.gms.dynamic.zza<zza> {
        private final ViewGroup zziqp;
        private final Context zziqq;
        private zzo<zza> zziqj;
        private final StreetViewPanoramaOptions zzirm;
        private final List<OnStreetViewPanoramaReadyCallback> zzirb = new ArrayList<OnStreetViewPanoramaReadyCallback>();

        zzb(ViewGroup viewGroup, Context context, StreetViewPanoramaOptions streetViewPanoramaOptions) {
            this.zziqp = viewGroup;
            this.zziqq = context;
            this.zzirm = streetViewPanoramaOptions;
        }

        protected final void zza(zzo<zza> zzo2) {
            this.zziqj = zzo2;
            zzb zzb2 = this;
            if (zzb2.zziqj != null && zzb2.zzapl() == null) {
                try {
                    MapsInitializer.initialize(zzb2.zziqq);
                    IStreetViewPanoramaViewDelegate iStreetViewPanoramaViewDelegate = zzbz.zzdq(zzb2.zziqq).zza(zzn.zzy((Object)zzb2.zziqq), zzb2.zzirm);
                    zzb2.zziqj.zza((LifecycleDelegate)new zza(zzb2.zziqp, iStreetViewPanoramaViewDelegate));
                    for (OnStreetViewPanoramaReadyCallback onStreetViewPanoramaReadyCallback : zzb2.zzirb) {
                        ((zza)zzb2.zzapl()).getStreetViewPanoramaAsync(onStreetViewPanoramaReadyCallback);
                    }
                    zzb2.zzirb.clear();
                    return;
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeRemoteException(remoteException);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {}
            }
        }

        public final void getStreetViewPanoramaAsync(OnStreetViewPanoramaReadyCallback onStreetViewPanoramaReadyCallback) {
            if (this.zzapl() != null) {
                ((zza)this.zzapl()).getStreetViewPanoramaAsync(onStreetViewPanoramaReadyCallback);
                return;
            }
            this.zzirb.add(onStreetViewPanoramaReadyCallback);
        }
    }

    static final class zza
    implements StreetViewLifecycleDelegate {
        private final ViewGroup zziqm;
        private final IStreetViewPanoramaViewDelegate zzirk;
        private View zzirl;

        public zza(ViewGroup viewGroup, IStreetViewPanoramaViewDelegate iStreetViewPanoramaViewDelegate) {
            this.zzirk = (IStreetViewPanoramaViewDelegate)zzbq.checkNotNull((Object)iStreetViewPanoramaViewDelegate);
            this.zziqm = (ViewGroup)zzbq.checkNotNull((Object)viewGroup);
        }

        public final void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            throw new UnsupportedOperationException("onInflate not allowed on StreetViewPanoramaViewDelegate");
        }

        public final void onCreate(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzby.zzd(bundle, bundle2);
                this.zzirk.onCreate(bundle2);
                zzby.zzd(bundle2, bundle);
                this.zzirl = (View)zzn.zzx((IObjectWrapper)this.zzirk.getView());
                this.zziqm.removeAllViews();
                this.zziqm.addView(this.zzirl);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            throw new UnsupportedOperationException("onCreateView not allowed on StreetViewPanoramaViewDelegate");
        }

        public final void onStart() {
        }

        public final void onResume() {
            try {
                this.zzirk.onResume();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onPause() {
            try {
                this.zzirk.onPause();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onStop() {
        }

        public final void onDestroyView() {
            throw new UnsupportedOperationException("onDestroyView not allowed on StreetViewPanoramaViewDelegate");
        }

        public final void onDestroy() {
            try {
                this.zzirk.onDestroy();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onLowMemory() {
            try {
                this.zzirk.onLowMemory();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onSaveInstanceState(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzby.zzd(bundle, bundle2);
                this.zzirk.onSaveInstanceState(bundle2);
                zzby.zzd(bundle2, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public final void getStreetViewPanoramaAsync(OnStreetViewPanoramaReadyCallback onStreetViewPanoramaReadyCallback) {
            try {
                this.zzirk.getStreetViewPanoramaAsync(new zzaj(this, onStreetViewPanoramaReadyCallback));
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }
    }
}

