/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.internal.zzbej;
import com.google.android.gms.internal.zzbem;
import com.google.android.gms.maps.internal.zza;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.zzaa;

public final class GoogleMapOptions
extends zzbej
implements ReflectedParcelable {
    public static final Parcelable.Creator<GoogleMapOptions> CREATOR = new zzaa();
    private Boolean zzipq;
    private Boolean zzipr;
    private int zzips = -1;
    private CameraPosition zzipt;
    private Boolean zzipu;
    private Boolean zzipv;
    private Boolean zzipw;
    private Boolean zzipx;
    private Boolean zzipy;
    private Boolean zzipz;
    private Boolean zziqa;
    private Boolean zziqb;
    private Boolean zziqc;
    private Float zziqd = null;
    private Float zziqe = null;
    private LatLngBounds zziqf = null;

    GoogleMapOptions(byte by, byte by2, int n, CameraPosition cameraPosition, byte by3, byte by4, byte by5, byte by6, byte by7, byte by8, byte by9, byte by10, byte by11, Float f, Float f2, LatLngBounds latLngBounds) {
        this.zzipq = zza.zza(by);
        this.zzipr = zza.zza(by2);
        this.zzips = n;
        this.zzipt = cameraPosition;
        this.zzipu = zza.zza(by3);
        this.zzipv = zza.zza(by4);
        this.zzipw = zza.zza(by5);
        this.zzipx = zza.zza(by6);
        this.zzipy = zza.zza(by7);
        this.zzipz = zza.zza(by8);
        this.zziqa = zza.zza(by9);
        this.zziqb = zza.zza(by10);
        this.zziqc = zza.zza(by11);
        this.zziqd = f;
        this.zziqe = f2;
        this.zziqf = latLngBounds;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GoogleMapOptions googleMapOptions = this;
        int n2 = zzbem.zze((Parcel)parcel2);
        zzbem.zza((Parcel)parcel2, (int)2, (byte)zza.zzb(googleMapOptions.zzipq));
        zzbem.zza((Parcel)parcel2, (int)3, (byte)zza.zzb(googleMapOptions.zzipr));
        zzbem.zzc((Parcel)parcel2, (int)4, (int)googleMapOptions.getMapType());
        zzbem.zza((Parcel)parcel2, (int)5, (Parcelable)googleMapOptions.getCamera(), (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)6, (byte)zza.zzb(googleMapOptions.zzipu));
        zzbem.zza((Parcel)parcel2, (int)7, (byte)zza.zzb(googleMapOptions.zzipv));
        zzbem.zza((Parcel)parcel2, (int)8, (byte)zza.zzb(googleMapOptions.zzipw));
        zzbem.zza((Parcel)parcel2, (int)9, (byte)zza.zzb(googleMapOptions.zzipx));
        zzbem.zza((Parcel)parcel2, (int)10, (byte)zza.zzb(googleMapOptions.zzipy));
        zzbem.zza((Parcel)parcel2, (int)11, (byte)zza.zzb(googleMapOptions.zzipz));
        zzbem.zza((Parcel)parcel2, (int)12, (byte)zza.zzb(googleMapOptions.zziqa));
        zzbem.zza((Parcel)parcel2, (int)14, (byte)zza.zzb(googleMapOptions.zziqb));
        zzbem.zza((Parcel)parcel2, (int)15, (byte)zza.zzb(googleMapOptions.zziqc));
        zzbem.zza((Parcel)parcel2, (int)16, (Float)googleMapOptions.getMinZoomPreference(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)17, (Float)googleMapOptions.getMaxZoomPreference(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)18, (Parcelable)googleMapOptions.getLatLngBoundsForCameraTarget(), (int)n, (boolean)false);
        zzbem.zzai((Parcel)parcel2, (int)n2);
    }

    public GoogleMapOptions() {
    }

    public final GoogleMapOptions zOrderOnTop(boolean bl) {
        this.zzipq = bl;
        return this;
    }

    public final GoogleMapOptions useViewLifecycleInFragment(boolean bl) {
        this.zzipr = bl;
        return this;
    }

    public final GoogleMapOptions mapType(int n) {
        this.zzips = n;
        return this;
    }

    public final GoogleMapOptions camera(CameraPosition cameraPosition) {
        this.zzipt = cameraPosition;
        return this;
    }

    public final GoogleMapOptions zoomControlsEnabled(boolean bl) {
        this.zzipu = bl;
        return this;
    }

    public final GoogleMapOptions compassEnabled(boolean bl) {
        this.zzipv = bl;
        return this;
    }

    public final GoogleMapOptions scrollGesturesEnabled(boolean bl) {
        this.zzipw = bl;
        return this;
    }

    public final GoogleMapOptions zoomGesturesEnabled(boolean bl) {
        this.zzipx = bl;
        return this;
    }

    public final GoogleMapOptions tiltGesturesEnabled(boolean bl) {
        this.zzipy = bl;
        return this;
    }

    public final GoogleMapOptions rotateGesturesEnabled(boolean bl) {
        this.zzipz = bl;
        return this;
    }

    public final GoogleMapOptions liteMode(boolean bl) {
        this.zziqa = bl;
        return this;
    }

    public final GoogleMapOptions mapToolbarEnabled(boolean bl) {
        this.zziqb = bl;
        return this;
    }

    public final GoogleMapOptions ambientEnabled(boolean bl) {
        this.zziqc = bl;
        return this;
    }

    public final GoogleMapOptions minZoomPreference(float f) {
        this.zziqd = Float.valueOf(f);
        return this;
    }

    public final GoogleMapOptions maxZoomPreference(float f) {
        this.zziqe = Float.valueOf(f);
        return this;
    }

    public final GoogleMapOptions latLngBoundsForCameraTarget(LatLngBounds latLngBounds) {
        this.zziqf = latLngBounds;
        return this;
    }

    public final Boolean getZOrderOnTop() {
        return this.zzipq;
    }

    public final Boolean getUseViewLifecycleInFragment() {
        return this.zzipr;
    }

    public final int getMapType() {
        return this.zzips;
    }

    public final CameraPosition getCamera() {
        return this.zzipt;
    }

    public final Boolean getZoomControlsEnabled() {
        return this.zzipu;
    }

    public final Boolean getCompassEnabled() {
        return this.zzipv;
    }

    public final Boolean getScrollGesturesEnabled() {
        return this.zzipw;
    }

    public final Boolean getZoomGesturesEnabled() {
        return this.zzipx;
    }

    public final Boolean getTiltGesturesEnabled() {
        return this.zzipy;
    }

    public final Boolean getRotateGesturesEnabled() {
        return this.zzipz;
    }

    public final Boolean getLiteMode() {
        return this.zziqa;
    }

    public final Boolean getMapToolbarEnabled() {
        return this.zziqb;
    }

    public final Boolean getAmbientEnabled() {
        return this.zziqc;
    }

    public final Float getMinZoomPreference() {
        return this.zziqd;
    }

    public final Float getMaxZoomPreference() {
        return this.zziqe;
    }

    public final LatLngBounds getLatLngBoundsForCameraTarget() {
        return this.zziqf;
    }

    public static GoogleMapOptions createFromAttributes(Context context, AttributeSet attributeSet) {
        if (attributeSet == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attributeSet, R.styleable.MapAttrs);
        GoogleMapOptions googleMapOptions = new GoogleMapOptions();
        if (typedArray.hasValue(R.styleable.MapAttrs_mapType)) {
            googleMapOptions.mapType(typedArray.getInt(R.styleable.MapAttrs_mapType, -1));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_zOrderOnTop)) {
            googleMapOptions.zOrderOnTop(typedArray.getBoolean(R.styleable.MapAttrs_zOrderOnTop, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_useViewLifecycle)) {
            googleMapOptions.useViewLifecycleInFragment(typedArray.getBoolean(R.styleable.MapAttrs_useViewLifecycle, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiCompass)) {
            googleMapOptions.compassEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiCompass, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiRotateGestures)) {
            googleMapOptions.rotateGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiRotateGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiScrollGestures)) {
            googleMapOptions.scrollGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiScrollGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiTiltGestures)) {
            googleMapOptions.tiltGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiTiltGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomGestures)) {
            googleMapOptions.zoomGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomControls)) {
            googleMapOptions.zoomControlsEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomControls, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_liteMode)) {
            googleMapOptions.liteMode(typedArray.getBoolean(R.styleable.MapAttrs_liteMode, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiMapToolbar)) {
            googleMapOptions.mapToolbarEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiMapToolbar, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_ambientEnabled)) {
            googleMapOptions.ambientEnabled(typedArray.getBoolean(R.styleable.MapAttrs_ambientEnabled, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraMinZoomPreference)) {
            googleMapOptions.minZoomPreference(typedArray.getFloat(R.styleable.MapAttrs_cameraMinZoomPreference, Float.NEGATIVE_INFINITY));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraMinZoomPreference)) {
            googleMapOptions.maxZoomPreference(typedArray.getFloat(R.styleable.MapAttrs_cameraMaxZoomPreference, Float.POSITIVE_INFINITY));
        }
        LatLngBounds latLngBounds = LatLngBounds.createFromAttributes(context, attributeSet);
        googleMapOptions.latLngBoundsForCameraTarget(latLngBounds);
        CameraPosition cameraPosition = CameraPosition.createFromAttributes(context, attributeSet);
        googleMapOptions.camera(cameraPosition);
        typedArray.recycle();
        return googleMapOptions;
    }

    public final String toString() {
        return zzbg.zzw((Object)((Object)this)).zzg("MapType", (Object)this.zzips).zzg("LiteMode", (Object)this.zziqa).zzg("Camera", (Object)this.zzipt).zzg("CompassEnabled", (Object)this.zzipv).zzg("ZoomControlsEnabled", (Object)this.zzipu).zzg("ScrollGesturesEnabled", (Object)this.zzipw).zzg("ZoomGesturesEnabled", (Object)this.zzipx).zzg("TiltGesturesEnabled", (Object)this.zzipy).zzg("RotateGesturesEnabled", (Object)this.zzipz).zzg("MapToolbarEnabled", (Object)this.zziqb).zzg("AmbientEnabled", (Object)this.zziqc).zzg("MinZoomPreference", (Object)this.zziqd).zzg("MaxZoomPreference", (Object)this.zziqe).zzg("LatLngBoundsForCameraTarget", (Object)this.zziqf).zzg("ZOrderOnTop", (Object)this.zzipq).zzg("UseViewLifecycleInFragment", (Object)this.zzipr).toString();
    }
}

