/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.RemoteException;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.maps.model.IndoorLevel;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import com.google.android.gms.maps.model.internal.zzj;
import com.google.android.gms.maps.model.internal.zzn;
import java.util.ArrayList;
import java.util.List;

public final class IndoorBuilding {
    private final zzj zzija;

    public IndoorBuilding(zzj zzj2) {
        this.zzija = (zzj)zzbp.zzu((Object)zzj2);
    }

    public final int getDefaultLevelIndex() {
        try {
            return this.zzija.getActiveLevelIndex();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final int getActiveLevelIndex() {
        try {
            return this.zzija.getActiveLevelIndex();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final List<IndoorLevel> getLevels() {
        try {
            List<IBinder> list = this.zzija.getLevels();
            ArrayList<IndoorLevel> arrayList = new ArrayList<IndoorLevel>(list.size());
            for (IBinder iBinder : list) {
                arrayList.add(new IndoorLevel(zzn.zzbg(iBinder)));
            }
            return arrayList;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean isUnderground() {
        try {
            return this.zzija.isUnderground();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean equals(Object object) {
        if (!(object instanceof IndoorBuilding)) {
            return false;
        }
        try {
            return this.zzija.zzb(((IndoorBuilding)object).zzija);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final int hashCode() {
        try {
            return this.zzija.hashCodeRemote();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }
}

