/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzbcn;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.zza;
import java.util.Arrays;

public final class CameraPosition
extends zzbck
implements ReflectedParcelable {
    public static final Parcelable.Creator<CameraPosition> CREATOR = new zza();
    public final LatLng target;
    public final float zoom;
    public final float tilt;
    public final float bearing;

    public CameraPosition(LatLng latLng, float f, float f2, float f3) {
        zzbp.zzb((Object)((Object)latLng), (Object)"null camera target");
        zzbp.zzb((0.0f <= f2 && f2 <= 90.0f ? 1 : 0) != 0, (String)"Tilt needs to be between 0 and 90 inclusive: %s", (Object[])new Object[]{Float.valueOf(f2)});
        this.target = latLng;
        this.zoom = f;
        this.tilt = f2 + 0.0f;
        this.bearing = ((double)f3 <= 0.0 ? f3 % 360.0f + 360.0f : f3) % 360.0f;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        CameraPosition cameraPosition = this;
        int n2 = zzbcn.zze((Parcel)parcel2);
        zzbcn.zza((Parcel)parcel2, (int)2, (Parcelable)cameraPosition.target, (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)3, (float)cameraPosition.zoom);
        zzbcn.zza((Parcel)parcel2, (int)4, (float)cameraPosition.tilt);
        zzbcn.zza((Parcel)parcel2, (int)5, (float)cameraPosition.bearing);
        zzbcn.zzai((Parcel)parcel2, (int)n2);
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.target, Float.valueOf(this.zoom), Float.valueOf(this.tilt), Float.valueOf(this.bearing)});
    }

    public static final CameraPosition fromLatLngZoom(LatLng latLng, float f) {
        return new CameraPosition(latLng, f, 0.0f, 0.0f);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CameraPosition cameraPosition) {
        return new Builder(cameraPosition);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CameraPosition)) {
            return false;
        }
        CameraPosition cameraPosition = (CameraPosition)((Object)object);
        return this.target.equals((Object)cameraPosition.target) && Float.floatToIntBits(this.zoom) == Float.floatToIntBits(cameraPosition.zoom) && Float.floatToIntBits(this.tilt) == Float.floatToIntBits(cameraPosition.tilt) && Float.floatToIntBits(this.bearing) == Float.floatToIntBits(cameraPosition.bearing);
    }

    public final String toString() {
        return zzbf.zzt((Object)((Object)this)).zzg("target", (Object)this.target).zzg("zoom", (Object)Float.valueOf(this.zoom)).zzg("tilt", (Object)Float.valueOf(this.tilt)).zzg("bearing", (Object)Float.valueOf(this.bearing)).toString();
    }

    public static CameraPosition createFromAttributes(Context context, AttributeSet attributeSet) {
        if (attributeSet == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attributeSet, R.styleable.MapAttrs);
        float f = 0.0f;
        float f2 = 0.0f;
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraTargetLat)) {
            f = typedArray.getFloat(R.styleable.MapAttrs_cameraTargetLat, 0.0f);
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraTargetLng)) {
            f2 = typedArray.getFloat(R.styleable.MapAttrs_cameraTargetLng, 0.0f);
        }
        LatLng latLng = new LatLng(f, f2);
        Builder builder = CameraPosition.builder();
        builder.target(latLng);
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraZoom)) {
            builder.zoom(typedArray.getFloat(R.styleable.MapAttrs_cameraZoom, 0.0f));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraBearing)) {
            builder.bearing(typedArray.getFloat(R.styleable.MapAttrs_cameraBearing, 0.0f));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraTilt)) {
            builder.tilt(typedArray.getFloat(R.styleable.MapAttrs_cameraTilt, 0.0f));
        }
        return builder.build();
    }

    public static final class Builder {
        private LatLng zziig;
        private float zziih;
        private float zziii;
        private float zziij;

        public Builder() {
        }

        public Builder(CameraPosition cameraPosition) {
            CameraPosition cameraPosition2 = cameraPosition;
            this.zziig = cameraPosition2.target;
            this.zziih = cameraPosition2.zoom;
            this.zziii = cameraPosition2.tilt;
            this.zziij = cameraPosition2.bearing;
        }

        public final Builder target(LatLng latLng) {
            this.zziig = latLng;
            return this;
        }

        public final Builder zoom(float f) {
            this.zziih = f;
            return this;
        }

        public final Builder tilt(float f) {
            this.zziii = f;
            return this;
        }

        public final Builder bearing(float f) {
            this.zziij = f;
            return this;
        }

        public final CameraPosition build() {
            return new CameraPosition(this.zziig, this.zziih, this.zziii, this.zziij);
        }
    }
}

