/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzbcn;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PatternItem;
import com.google.android.gms.maps.model.zzk;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class PolygonOptions
extends zzbck {
    public static final Parcelable.Creator<PolygonOptions> CREATOR = new zzk();
    private final List<LatLng> zzijq;
    private final List<List<LatLng>> zzijr;
    private float mStrokeWidth = 10.0f;
    private int mStrokeColor = -16777216;
    private int mFillColor = 0;
    private float zziin = 0.0f;
    private boolean zziio = true;
    private boolean zzijs = false;
    private boolean zziip = false;
    private int zzijt = 0;
    @Nullable
    private List<PatternItem> zziiq = null;

    public PolygonOptions() {
        this.zzijq = new ArrayList<LatLng>();
        this.zzijr = new ArrayList<List<LatLng>>();
    }

    PolygonOptions(List<LatLng> list, List list2, float f, int n, int n2, float f2, boolean bl, boolean bl2, boolean bl3, int n3, @Nullable List<PatternItem> list3) {
        this.zzijq = list;
        this.zzijr = list2;
        this.mStrokeWidth = f;
        this.mStrokeColor = n;
        this.mFillColor = n2;
        this.zziin = f2;
        this.zziio = bl;
        this.zzijs = bl2;
        this.zziip = bl3;
        this.zzijt = n3;
        this.zziiq = list3;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PolygonOptions polygonOptions = this;
        int n2 = zzbcn.zze((Parcel)parcel2);
        zzbcn.zzc((Parcel)parcel2, (int)2, polygonOptions.getPoints(), (boolean)false);
        zzbcn.zzd((Parcel)parcel2, (int)3, polygonOptions.zzijr, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)4, (float)polygonOptions.getStrokeWidth());
        zzbcn.zzc((Parcel)parcel2, (int)5, (int)polygonOptions.getStrokeColor());
        zzbcn.zzc((Parcel)parcel2, (int)6, (int)polygonOptions.getFillColor());
        zzbcn.zza((Parcel)parcel2, (int)7, (float)polygonOptions.getZIndex());
        zzbcn.zza((Parcel)parcel2, (int)8, (boolean)polygonOptions.isVisible());
        zzbcn.zza((Parcel)parcel2, (int)9, (boolean)polygonOptions.isGeodesic());
        zzbcn.zza((Parcel)parcel2, (int)10, (boolean)polygonOptions.isClickable());
        zzbcn.zzc((Parcel)parcel2, (int)11, (int)polygonOptions.getStrokeJointType());
        zzbcn.zzc((Parcel)parcel2, (int)12, polygonOptions.getStrokePattern(), (boolean)false);
        zzbcn.zzai((Parcel)parcel2, (int)n2);
    }

    public final PolygonOptions add(LatLng latLng) {
        this.zzijq.add(latLng);
        return this;
    }

    public final PolygonOptions add(LatLng ... latLngArray) {
        this.zzijq.addAll(Arrays.asList(latLngArray));
        return this;
    }

    public final PolygonOptions addAll(Iterable<LatLng> iterable) {
        for (LatLng latLng : iterable) {
            this.zzijq.add(latLng);
        }
        return this;
    }

    public final PolygonOptions addHole(Iterable<LatLng> iterable) {
        ArrayList<LatLng> arrayList = new ArrayList<LatLng>();
        for (LatLng latLng : iterable) {
            arrayList.add(latLng);
        }
        this.zzijr.add(arrayList);
        return this;
    }

    public final PolygonOptions strokeWidth(float f) {
        this.mStrokeWidth = f;
        return this;
    }

    public final PolygonOptions strokeColor(int n) {
        this.mStrokeColor = n;
        return this;
    }

    public final PolygonOptions strokeJointType(int n) {
        this.zzijt = n;
        return this;
    }

    public final PolygonOptions strokePattern(@Nullable List<PatternItem> list) {
        this.zziiq = list;
        return this;
    }

    public final PolygonOptions fillColor(int n) {
        this.mFillColor = n;
        return this;
    }

    public final PolygonOptions zIndex(float f) {
        this.zziin = f;
        return this;
    }

    public final PolygonOptions visible(boolean bl) {
        this.zziio = bl;
        return this;
    }

    public final PolygonOptions geodesic(boolean bl) {
        this.zzijs = bl;
        return this;
    }

    public final PolygonOptions clickable(boolean bl) {
        this.zziip = bl;
        return this;
    }

    public final List<LatLng> getPoints() {
        return this.zzijq;
    }

    public final List<List<LatLng>> getHoles() {
        return this.zzijr;
    }

    public final float getStrokeWidth() {
        return this.mStrokeWidth;
    }

    public final int getStrokeColor() {
        return this.mStrokeColor;
    }

    public final int getStrokeJointType() {
        return this.zzijt;
    }

    @Nullable
    public final List<PatternItem> getStrokePattern() {
        return this.zziiq;
    }

    public final int getFillColor() {
        return this.mFillColor;
    }

    public final float getZIndex() {
        return this.zziin;
    }

    public final boolean isVisible() {
        return this.zziio;
    }

    public final boolean isGeodesic() {
        return this.zzijs;
    }

    public final boolean isClickable() {
        return this.zziip;
    }
}

