/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzbcn;
import com.google.android.gms.maps.internal.zza;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.zzaa;

public final class GoogleMapOptions
extends zzbck
implements ReflectedParcelable {
    public static final Parcelable.Creator<GoogleMapOptions> CREATOR = new zzaa();
    private Boolean zzigc;
    private Boolean zzigd;
    private int zzige = -1;
    private CameraPosition zzigf;
    private Boolean zzigg;
    private Boolean zzigh;
    private Boolean zzigi;
    private Boolean zzigj;
    private Boolean zzigk;
    private Boolean zzigl;
    private Boolean zzigm;
    private Boolean zzign;
    private Boolean zzigo;
    private Float zzigp = null;
    private Float zzigq = null;
    private LatLngBounds zzigr = null;

    GoogleMapOptions(byte by, byte by2, int n, CameraPosition cameraPosition, byte by3, byte by4, byte by5, byte by6, byte by7, byte by8, byte by9, byte by10, byte by11, Float f, Float f2, LatLngBounds latLngBounds) {
        this.zzigc = zza.zza(by);
        this.zzigd = zza.zza(by2);
        this.zzige = n;
        this.zzigf = cameraPosition;
        this.zzigg = zza.zza(by3);
        this.zzigh = zza.zza(by4);
        this.zzigi = zza.zza(by5);
        this.zzigj = zza.zza(by6);
        this.zzigk = zza.zza(by7);
        this.zzigl = zza.zza(by8);
        this.zzigm = zza.zza(by9);
        this.zzign = zza.zza(by10);
        this.zzigo = zza.zza(by11);
        this.zzigp = f;
        this.zzigq = f2;
        this.zzigr = latLngBounds;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GoogleMapOptions googleMapOptions = this;
        int n2 = zzbcn.zze((Parcel)parcel2);
        zzbcn.zza((Parcel)parcel2, (int)2, (byte)zza.zzb(googleMapOptions.zzigc));
        zzbcn.zza((Parcel)parcel2, (int)3, (byte)zza.zzb(googleMapOptions.zzigd));
        zzbcn.zzc((Parcel)parcel2, (int)4, (int)googleMapOptions.getMapType());
        zzbcn.zza((Parcel)parcel2, (int)5, (Parcelable)googleMapOptions.getCamera(), (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)6, (byte)zza.zzb(googleMapOptions.zzigg));
        zzbcn.zza((Parcel)parcel2, (int)7, (byte)zza.zzb(googleMapOptions.zzigh));
        zzbcn.zza((Parcel)parcel2, (int)8, (byte)zza.zzb(googleMapOptions.zzigi));
        zzbcn.zza((Parcel)parcel2, (int)9, (byte)zza.zzb(googleMapOptions.zzigj));
        zzbcn.zza((Parcel)parcel2, (int)10, (byte)zza.zzb(googleMapOptions.zzigk));
        zzbcn.zza((Parcel)parcel2, (int)11, (byte)zza.zzb(googleMapOptions.zzigl));
        zzbcn.zza((Parcel)parcel2, (int)12, (byte)zza.zzb(googleMapOptions.zzigm));
        zzbcn.zza((Parcel)parcel2, (int)14, (byte)zza.zzb(googleMapOptions.zzign));
        zzbcn.zza((Parcel)parcel2, (int)15, (byte)zza.zzb(googleMapOptions.zzigo));
        zzbcn.zza((Parcel)parcel2, (int)16, (Float)googleMapOptions.getMinZoomPreference(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)17, (Float)googleMapOptions.getMaxZoomPreference(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)18, (Parcelable)googleMapOptions.getLatLngBoundsForCameraTarget(), (int)n, (boolean)false);
        zzbcn.zzai((Parcel)parcel2, (int)n2);
    }

    public GoogleMapOptions() {
    }

    public final GoogleMapOptions zOrderOnTop(boolean bl) {
        this.zzigc = bl;
        return this;
    }

    public final GoogleMapOptions useViewLifecycleInFragment(boolean bl) {
        this.zzigd = bl;
        return this;
    }

    public final GoogleMapOptions mapType(int n) {
        this.zzige = n;
        return this;
    }

    public final GoogleMapOptions camera(CameraPosition cameraPosition) {
        this.zzigf = cameraPosition;
        return this;
    }

    public final GoogleMapOptions zoomControlsEnabled(boolean bl) {
        this.zzigg = bl;
        return this;
    }

    public final GoogleMapOptions compassEnabled(boolean bl) {
        this.zzigh = bl;
        return this;
    }

    public final GoogleMapOptions scrollGesturesEnabled(boolean bl) {
        this.zzigi = bl;
        return this;
    }

    public final GoogleMapOptions zoomGesturesEnabled(boolean bl) {
        this.zzigj = bl;
        return this;
    }

    public final GoogleMapOptions tiltGesturesEnabled(boolean bl) {
        this.zzigk = bl;
        return this;
    }

    public final GoogleMapOptions rotateGesturesEnabled(boolean bl) {
        this.zzigl = bl;
        return this;
    }

    public final GoogleMapOptions liteMode(boolean bl) {
        this.zzigm = bl;
        return this;
    }

    public final GoogleMapOptions mapToolbarEnabled(boolean bl) {
        this.zzign = bl;
        return this;
    }

    public final GoogleMapOptions ambientEnabled(boolean bl) {
        this.zzigo = bl;
        return this;
    }

    public final GoogleMapOptions minZoomPreference(float f) {
        this.zzigp = Float.valueOf(f);
        return this;
    }

    public final GoogleMapOptions maxZoomPreference(float f) {
        this.zzigq = Float.valueOf(f);
        return this;
    }

    public final GoogleMapOptions latLngBoundsForCameraTarget(LatLngBounds latLngBounds) {
        this.zzigr = latLngBounds;
        return this;
    }

    public final Boolean getZOrderOnTop() {
        return this.zzigc;
    }

    public final Boolean getUseViewLifecycleInFragment() {
        return this.zzigd;
    }

    public final int getMapType() {
        return this.zzige;
    }

    public final CameraPosition getCamera() {
        return this.zzigf;
    }

    public final Boolean getZoomControlsEnabled() {
        return this.zzigg;
    }

    public final Boolean getCompassEnabled() {
        return this.zzigh;
    }

    public final Boolean getScrollGesturesEnabled() {
        return this.zzigi;
    }

    public final Boolean getZoomGesturesEnabled() {
        return this.zzigj;
    }

    public final Boolean getTiltGesturesEnabled() {
        return this.zzigk;
    }

    public final Boolean getRotateGesturesEnabled() {
        return this.zzigl;
    }

    public final Boolean getLiteMode() {
        return this.zzigm;
    }

    public final Boolean getMapToolbarEnabled() {
        return this.zzign;
    }

    public final Boolean getAmbientEnabled() {
        return this.zzigo;
    }

    public final Float getMinZoomPreference() {
        return this.zzigp;
    }

    public final Float getMaxZoomPreference() {
        return this.zzigq;
    }

    public final LatLngBounds getLatLngBoundsForCameraTarget() {
        return this.zzigr;
    }

    public static GoogleMapOptions createFromAttributes(Context context, AttributeSet attributeSet) {
        if (attributeSet == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attributeSet, R.styleable.MapAttrs);
        GoogleMapOptions googleMapOptions = new GoogleMapOptions();
        if (typedArray.hasValue(R.styleable.MapAttrs_mapType)) {
            googleMapOptions.mapType(typedArray.getInt(R.styleable.MapAttrs_mapType, -1));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_zOrderOnTop)) {
            googleMapOptions.zOrderOnTop(typedArray.getBoolean(R.styleable.MapAttrs_zOrderOnTop, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_useViewLifecycle)) {
            googleMapOptions.useViewLifecycleInFragment(typedArray.getBoolean(R.styleable.MapAttrs_useViewLifecycle, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiCompass)) {
            googleMapOptions.compassEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiCompass, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiRotateGestures)) {
            googleMapOptions.rotateGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiRotateGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiScrollGestures)) {
            googleMapOptions.scrollGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiScrollGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiTiltGestures)) {
            googleMapOptions.tiltGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiTiltGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomGestures)) {
            googleMapOptions.zoomGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomControls)) {
            googleMapOptions.zoomControlsEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomControls, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_liteMode)) {
            googleMapOptions.liteMode(typedArray.getBoolean(R.styleable.MapAttrs_liteMode, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiMapToolbar)) {
            googleMapOptions.mapToolbarEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiMapToolbar, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_ambientEnabled)) {
            googleMapOptions.ambientEnabled(typedArray.getBoolean(R.styleable.MapAttrs_ambientEnabled, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraMinZoomPreference)) {
            googleMapOptions.minZoomPreference(typedArray.getFloat(R.styleable.MapAttrs_cameraMinZoomPreference, Float.NEGATIVE_INFINITY));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraMinZoomPreference)) {
            googleMapOptions.maxZoomPreference(typedArray.getFloat(R.styleable.MapAttrs_cameraMaxZoomPreference, Float.POSITIVE_INFINITY));
        }
        LatLngBounds latLngBounds = LatLngBounds.createFromAttributes(context, attributeSet);
        googleMapOptions.latLngBoundsForCameraTarget(latLngBounds);
        CameraPosition cameraPosition = CameraPosition.createFromAttributes(context, attributeSet);
        googleMapOptions.camera(cameraPosition);
        typedArray.recycle();
        return googleMapOptions;
    }

    public final String toString() {
        return zzbf.zzt((Object)((Object)this)).zzg("MapType", (Object)this.zzige).zzg("LiteMode", (Object)this.zzigm).zzg("Camera", (Object)this.zzigf).zzg("CompassEnabled", (Object)this.zzigh).zzg("ZoomControlsEnabled", (Object)this.zzigg).zzg("ScrollGesturesEnabled", (Object)this.zzigi).zzg("ZoomGesturesEnabled", (Object)this.zzigj).zzg("TiltGesturesEnabled", (Object)this.zzigk).zzg("RotateGesturesEnabled", (Object)this.zzigl).zzg("MapToolbarEnabled", (Object)this.zzign).zzg("AmbientEnabled", (Object)this.zzigo).zzg("MinZoomPreference", (Object)this.zzigp).zzg("MaxZoomPreference", (Object)this.zzigq).zzg("LatLngBoundsForCameraTarget", (Object)this.zzigr).zzg("ZOrderOnTop", (Object)this.zzigc).zzg("UseViewLifecycleInFragment", (Object)this.zzigd).toString();
    }
}

