/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzbcc;
import com.google.android.gms.internal.zzbcf;
import com.google.android.gms.maps.model.zzp;
import java.util.Arrays;

public class StreetViewPanoramaOrientation
extends zzbcc {
    public static final Parcelable.Creator<StreetViewPanoramaOrientation> CREATOR = new zzp();
    public final float tilt;
    public final float bearing;

    public StreetViewPanoramaOrientation(float f, float f2) {
        zzbp.zzb((-90.0f <= f && f <= 90.0f ? 1 : 0) != 0, (Object)new StringBuilder(62).append("Tilt needs to be between -90 and 90 inclusive: ").append(f).toString());
        this.tilt = f + 0.0f;
        this.bearing = ((double)f2 <= 0.0 ? f2 % 360.0f + 360.0f : f2) % 360.0f;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        StreetViewPanoramaOrientation streetViewPanoramaOrientation = this;
        int n2 = zzbcf.zze((Parcel)parcel2);
        zzbcf.zza((Parcel)parcel2, (int)2, (float)streetViewPanoramaOrientation.tilt);
        zzbcf.zza((Parcel)parcel2, (int)3, (float)streetViewPanoramaOrientation.bearing);
        zzbcf.zzai((Parcel)parcel2, (int)n2);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{Float.valueOf(this.tilt), Float.valueOf(this.bearing)});
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(StreetViewPanoramaOrientation streetViewPanoramaOrientation) {
        return new Builder(streetViewPanoramaOrientation);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof StreetViewPanoramaOrientation)) {
            return false;
        }
        StreetViewPanoramaOrientation streetViewPanoramaOrientation = (StreetViewPanoramaOrientation)((Object)object);
        return Float.floatToIntBits(this.tilt) == Float.floatToIntBits(streetViewPanoramaOrientation.tilt) && Float.floatToIntBits(this.bearing) == Float.floatToIntBits(streetViewPanoramaOrientation.bearing);
    }

    public String toString() {
        return zzbf.zzt((Object)((Object)this)).zzg("tilt", (Object)Float.valueOf(this.tilt)).zzg("bearing", (Object)Float.valueOf(this.bearing)).toString();
    }

    public static final class Builder {
        public float bearing;
        public float tilt;

        public Builder() {
        }

        public Builder(StreetViewPanoramaOrientation streetViewPanoramaOrientation) {
            StreetViewPanoramaOrientation streetViewPanoramaOrientation2 = streetViewPanoramaOrientation;
            this.bearing = streetViewPanoramaOrientation2.bearing;
            this.tilt = streetViewPanoramaOrientation2.tilt;
        }

        public final Builder tilt(float f) {
            this.tilt = f;
            return this;
        }

        public final Builder bearing(float f) {
            this.bearing = f;
            return this;
        }

        public final StreetViewPanoramaOrientation build() {
            return new StreetViewPanoramaOrientation(this.tilt, this.bearing);
        }
    }
}

