/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzbcc;
import com.google.android.gms.internal.zzbcf;
import com.google.android.gms.maps.model.ButtCap;
import com.google.android.gms.maps.model.Cap;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PatternItem;
import com.google.android.gms.maps.model.zzl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class PolylineOptions
extends zzbcc {
    public static final Parcelable.Creator<PolylineOptions> CREATOR = new zzl();
    private final List<LatLng> zzijk;
    private float zziio = 10.0f;
    private int mColor = -16777216;
    private float zziih = 0.0f;
    private boolean zziii = true;
    private boolean zzijm = false;
    private boolean zziij = false;
    @NonNull
    private Cap zzijp = new ButtCap();
    @NonNull
    private Cap zzijq = new ButtCap();
    private int zzijr = 0;
    @Nullable
    private List<PatternItem> zzijs = null;

    public PolylineOptions() {
        this.zzijk = new ArrayList<LatLng>();
    }

    PolylineOptions(List list, float f, int n, float f2, boolean bl, boolean bl2, boolean bl3, @Nullable Cap cap, @Nullable Cap cap2, int n2, @Nullable List<PatternItem> list2) {
        this.zzijk = list;
        this.zziio = f;
        this.mColor = n;
        this.zziih = f2;
        this.zziii = bl;
        this.zzijm = bl2;
        this.zziij = bl3;
        if (cap != null) {
            this.zzijp = cap;
        }
        if (cap2 != null) {
            this.zzijq = cap2;
        }
        this.zzijr = n2;
        this.zzijs = list2;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PolylineOptions polylineOptions = this;
        int n2 = zzbcf.zze((Parcel)parcel2);
        zzbcf.zzc((Parcel)parcel2, (int)2, polylineOptions.getPoints(), (boolean)false);
        zzbcf.zza((Parcel)parcel2, (int)3, (float)polylineOptions.getWidth());
        zzbcf.zzc((Parcel)parcel2, (int)4, (int)polylineOptions.getColor());
        zzbcf.zza((Parcel)parcel2, (int)5, (float)polylineOptions.getZIndex());
        zzbcf.zza((Parcel)parcel2, (int)6, (boolean)polylineOptions.isVisible());
        zzbcf.zza((Parcel)parcel2, (int)7, (boolean)polylineOptions.isGeodesic());
        zzbcf.zza((Parcel)parcel2, (int)8, (boolean)polylineOptions.isClickable());
        zzbcf.zza((Parcel)parcel2, (int)9, (Parcelable)polylineOptions.getStartCap(), (int)n, (boolean)false);
        zzbcf.zza((Parcel)parcel2, (int)10, (Parcelable)polylineOptions.getEndCap(), (int)n, (boolean)false);
        zzbcf.zzc((Parcel)parcel2, (int)11, (int)polylineOptions.getJointType());
        zzbcf.zzc((Parcel)parcel2, (int)12, polylineOptions.getPattern(), (boolean)false);
        zzbcf.zzai((Parcel)parcel2, (int)n2);
    }

    public final PolylineOptions add(LatLng latLng) {
        this.zzijk.add(latLng);
        return this;
    }

    public final PolylineOptions add(LatLng ... latLngArray) {
        this.zzijk.addAll(Arrays.asList(latLngArray));
        return this;
    }

    public final PolylineOptions addAll(Iterable<LatLng> iterable) {
        for (LatLng latLng : iterable) {
            this.zzijk.add(latLng);
        }
        return this;
    }

    public final PolylineOptions width(float f) {
        this.zziio = f;
        return this;
    }

    public final PolylineOptions color(int n) {
        this.mColor = n;
        return this;
    }

    public final PolylineOptions startCap(@NonNull Cap cap) {
        this.zzijp = (Cap)((Object)zzbp.zzb((Object)((Object)cap), (Object)"startCap must not be null"));
        return this;
    }

    public final PolylineOptions endCap(@NonNull Cap cap) {
        this.zzijq = (Cap)((Object)zzbp.zzb((Object)((Object)cap), (Object)"endCap must not be null"));
        return this;
    }

    public final PolylineOptions jointType(int n) {
        this.zzijr = n;
        return this;
    }

    public final PolylineOptions pattern(@Nullable List<PatternItem> list) {
        this.zzijs = list;
        return this;
    }

    public final PolylineOptions zIndex(float f) {
        this.zziih = f;
        return this;
    }

    public final PolylineOptions visible(boolean bl) {
        this.zziii = bl;
        return this;
    }

    public final PolylineOptions geodesic(boolean bl) {
        this.zzijm = bl;
        return this;
    }

    public final PolylineOptions clickable(boolean bl) {
        this.zziij = bl;
        return this;
    }

    public final List<LatLng> getPoints() {
        return this.zzijk;
    }

    public final float getWidth() {
        return this.zziio;
    }

    public final int getColor() {
        return this.mColor;
    }

    @NonNull
    public final Cap getStartCap() {
        return this.zzijp;
    }

    @NonNull
    public final Cap getEndCap() {
        return this.zzijq;
    }

    public final int getJointType() {
        return this.zzijr;
    }

    @Nullable
    public final List<PatternItem> getPattern() {
        return this.zzijs;
    }

    public final float getZIndex() {
        return this.zziih;
    }

    public final boolean isVisible() {
        return this.zziii;
    }

    public final boolean isGeodesic() {
        return this.zzijm;
    }

    public final boolean isClickable() {
        return this.zziij;
    }
}

