/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.internal.zzbcc;
import com.google.android.gms.internal.zzbcf;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PatternItem;
import com.google.android.gms.maps.model.zzk;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class PolygonOptions
extends zzbcc {
    public static final Parcelable.Creator<PolygonOptions> CREATOR = new zzk();
    private final List<LatLng> zzijk;
    private final List<List<LatLng>> zzijl;
    private float mStrokeWidth = 10.0f;
    private int mStrokeColor = -16777216;
    private int mFillColor = 0;
    private float zziih = 0.0f;
    private boolean zziii = true;
    private boolean zzijm = false;
    private boolean zziij = false;
    private int zzijn = 0;
    @Nullable
    private List<PatternItem> zziik = null;

    public PolygonOptions() {
        this.zzijk = new ArrayList<LatLng>();
        this.zzijl = new ArrayList<List<LatLng>>();
    }

    PolygonOptions(List<LatLng> list, List list2, float f, int n, int n2, float f2, boolean bl, boolean bl2, boolean bl3, int n3, @Nullable List<PatternItem> list3) {
        this.zzijk = list;
        this.zzijl = list2;
        this.mStrokeWidth = f;
        this.mStrokeColor = n;
        this.mFillColor = n2;
        this.zziih = f2;
        this.zziii = bl;
        this.zzijm = bl2;
        this.zziij = bl3;
        this.zzijn = n3;
        this.zziik = list3;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PolygonOptions polygonOptions = this;
        int n2 = zzbcf.zze((Parcel)parcel2);
        zzbcf.zzc((Parcel)parcel2, (int)2, polygonOptions.getPoints(), (boolean)false);
        zzbcf.zzd((Parcel)parcel2, (int)3, polygonOptions.zzijl, (boolean)false);
        zzbcf.zza((Parcel)parcel2, (int)4, (float)polygonOptions.getStrokeWidth());
        zzbcf.zzc((Parcel)parcel2, (int)5, (int)polygonOptions.getStrokeColor());
        zzbcf.zzc((Parcel)parcel2, (int)6, (int)polygonOptions.getFillColor());
        zzbcf.zza((Parcel)parcel2, (int)7, (float)polygonOptions.getZIndex());
        zzbcf.zza((Parcel)parcel2, (int)8, (boolean)polygonOptions.isVisible());
        zzbcf.zza((Parcel)parcel2, (int)9, (boolean)polygonOptions.isGeodesic());
        zzbcf.zza((Parcel)parcel2, (int)10, (boolean)polygonOptions.isClickable());
        zzbcf.zzc((Parcel)parcel2, (int)11, (int)polygonOptions.getStrokeJointType());
        zzbcf.zzc((Parcel)parcel2, (int)12, polygonOptions.getStrokePattern(), (boolean)false);
        zzbcf.zzai((Parcel)parcel2, (int)n2);
    }

    public final PolygonOptions add(LatLng latLng) {
        this.zzijk.add(latLng);
        return this;
    }

    public final PolygonOptions add(LatLng ... latLngArray) {
        this.zzijk.addAll(Arrays.asList(latLngArray));
        return this;
    }

    public final PolygonOptions addAll(Iterable<LatLng> iterable) {
        for (LatLng latLng : iterable) {
            this.zzijk.add(latLng);
        }
        return this;
    }

    public final PolygonOptions addHole(Iterable<LatLng> iterable) {
        ArrayList<LatLng> arrayList = new ArrayList<LatLng>();
        for (LatLng latLng : iterable) {
            arrayList.add(latLng);
        }
        this.zzijl.add(arrayList);
        return this;
    }

    public final PolygonOptions strokeWidth(float f) {
        this.mStrokeWidth = f;
        return this;
    }

    public final PolygonOptions strokeColor(int n) {
        this.mStrokeColor = n;
        return this;
    }

    public final PolygonOptions strokeJointType(int n) {
        this.zzijn = n;
        return this;
    }

    public final PolygonOptions strokePattern(@Nullable List<PatternItem> list) {
        this.zziik = list;
        return this;
    }

    public final PolygonOptions fillColor(int n) {
        this.mFillColor = n;
        return this;
    }

    public final PolygonOptions zIndex(float f) {
        this.zziih = f;
        return this;
    }

    public final PolygonOptions visible(boolean bl) {
        this.zziii = bl;
        return this;
    }

    public final PolygonOptions geodesic(boolean bl) {
        this.zzijm = bl;
        return this;
    }

    public final PolygonOptions clickable(boolean bl) {
        this.zziij = bl;
        return this;
    }

    public final List<LatLng> getPoints() {
        return this.zzijk;
    }

    public final List<List<LatLng>> getHoles() {
        return this.zzijl;
    }

    public final float getStrokeWidth() {
        return this.mStrokeWidth;
    }

    public final int getStrokeColor() {
        return this.mStrokeColor;
    }

    public final int getStrokeJointType() {
        return this.zzijn;
    }

    @Nullable
    public final List<PatternItem> getStrokePattern() {
        return this.zziik;
    }

    public final int getFillColor() {
        return this.mFillColor;
    }

    public final float getZIndex() {
        return this.zziih;
    }

    public final boolean isVisible() {
        return this.zziii;
    }

    public final boolean isGeodesic() {
        return this.zzijm;
    }

    public final boolean isClickable() {
        return this.zziij;
    }
}

