/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.internal.zzbcc;
import com.google.android.gms.internal.zzbcf;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.ButtCap;
import com.google.android.gms.maps.model.CustomCap;
import com.google.android.gms.maps.model.RoundCap;
import com.google.android.gms.maps.model.SquareCap;
import com.google.android.gms.maps.model.zzb;
import java.util.Arrays;

public class Cap
extends zzbcc {
    private static final String TAG = Cap.class.getSimpleName();
    public static final Parcelable.Creator<Cap> CREATOR = new zzb();
    private final int type;
    @Nullable
    private final BitmapDescriptor bitmapDescriptor;
    @Nullable
    private final Float zziid;

    private Cap(int n, @Nullable BitmapDescriptor bitmapDescriptor, @Nullable Float f) {
        boolean bl = f != null && f.floatValue() > 0.0f;
        String string = String.valueOf(bitmapDescriptor);
        String string2 = String.valueOf(f);
        zzbp.zzb((n != 3 || bitmapDescriptor != null && bl ? 1 : 0) != 0, (Object)new StringBuilder(63 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Invalid Cap: type=").append(n).append(" bitmapDescriptor=").append(string).append(" bitmapRefWidth=").append(string2).toString());
        this.type = n;
        this.bitmapDescriptor = bitmapDescriptor;
        this.zziid = f;
    }

    Cap(int n, @Nullable IBinder iBinder, @Nullable Float f) {
        BitmapDescriptor bitmapDescriptor;
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            bitmapDescriptor = null;
        } else {
            IObjectWrapper iObjectWrapper = IObjectWrapper.zza.zzao((IBinder)iBinder2);
            bitmapDescriptor = new BitmapDescriptor(iObjectWrapper);
        }
        this(n, bitmapDescriptor, f);
    }

    protected Cap(@NonNull BitmapDescriptor bitmapDescriptor, float f) {
        this(3, bitmapDescriptor, Float.valueOf(f));
    }

    protected Cap(int n) {
        this(n, (BitmapDescriptor)null, (Float)null);
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Cap cap = this;
        int n2 = zzbcf.zze((Parcel)parcel2);
        zzbcf.zzc((Parcel)parcel2, (int)2, (int)cap.type);
        Cap cap2 = cap;
        zzbcf.zza((Parcel)parcel2, (int)3, cap2.bitmapDescriptor == null ? null : cap2.bitmapDescriptor.zzatk().asBinder(), (boolean)false);
        zzbcf.zza((Parcel)parcel2, (int)4, (Float)cap.zziid, (boolean)false);
        zzbcf.zzai((Parcel)parcel2, (int)n2);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.type, this.bitmapDescriptor, this.zziid});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Cap)) {
            return false;
        }
        Cap cap = (Cap)((Object)object);
        return this.type == cap.type && zzbf.equal((Object)this.bitmapDescriptor, (Object)cap.bitmapDescriptor) && zzbf.equal((Object)this.zziid, (Object)cap.zziid);
    }

    public String toString() {
        int n = this.type;
        return new StringBuilder(23).append("[Cap: type=").append(n).append("]").toString();
    }

    final Cap zzatq() {
        switch (this.type) {
            case 0: {
                return new ButtCap();
            }
            case 1: {
                return new SquareCap();
            }
            case 2: {
                return new RoundCap();
            }
            case 3: {
                return new CustomCap(this.bitmapDescriptor, this.zziid.floatValue());
            }
        }
        int n = this.type;
        Log.w((String)TAG, (String)new StringBuilder(29).append("Unknown Cap type: ").append(n).toString());
        return this;
    }
}

