/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.dynamic.zzo;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.internal.IMapFragmentDelegate;
import com.google.android.gms.maps.internal.MapLifecycleDelegate;
import com.google.android.gms.maps.internal.zzbw;
import com.google.android.gms.maps.internal.zzbx;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import com.google.android.gms.maps.zzaa;
import java.util.ArrayList;
import java.util.List;

@TargetApi(value=11)
public class MapFragment
extends Fragment {
    private final zzb zzigm = new zzb(this);

    public static MapFragment newInstance() {
        return new MapFragment();
    }

    public static MapFragment newInstance(GoogleMapOptions googleMapOptions) {
        MapFragment mapFragment = new MapFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("MapOptions", (Parcelable)googleMapOptions);
        mapFragment.setArguments(bundle);
        return mapFragment;
    }

    public MapFragment() {
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.zzigm.setActivity(activity);
    }

    @SuppressLint(value={"NewApi"})
    public void onInflate(Activity activity, AttributeSet attributeSet, Bundle bundle) {
        super.onInflate(activity, attributeSet, bundle);
        this.zzigm.setActivity(activity);
        GoogleMapOptions googleMapOptions = GoogleMapOptions.createFromAttributes((Context)activity, attributeSet);
        Bundle bundle2 = new Bundle();
        bundle2.putParcelable("MapOptions", (Parcelable)googleMapOptions);
        this.zzigm.onInflate(activity, bundle2, bundle);
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.zzigm.onCreate(bundle);
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        View view = this.zzigm.onCreateView(layoutInflater, viewGroup, bundle);
        view.setClickable(true);
        return view;
    }

    public void onResume() {
        super.onResume();
        this.zzigm.onResume();
    }

    public void onPause() {
        this.zzigm.onPause();
        super.onPause();
    }

    public void onStart() {
        super.onStart();
        this.zzigm.onStart();
    }

    public void onStop() {
        this.zzigm.onStop();
        super.onStop();
    }

    public void onDestroyView() {
        this.zzigm.onDestroyView();
        super.onDestroyView();
    }

    public void onDestroy() {
        this.zzigm.onDestroy();
        super.onDestroy();
    }

    public void onLowMemory() {
        this.zzigm.onLowMemory();
        super.onLowMemory();
    }

    public void onActivityCreated(Bundle bundle) {
        if (bundle != null) {
            bundle.setClassLoader(MapFragment.class.getClassLoader());
        }
        super.onActivityCreated(bundle);
    }

    public void onSaveInstanceState(Bundle bundle) {
        if (bundle != null) {
            bundle.setClassLoader(MapFragment.class.getClassLoader());
        }
        super.onSaveInstanceState(bundle);
        this.zzigm.onSaveInstanceState(bundle);
    }

    public final void onEnterAmbient(Bundle bundle) {
        zzbp.zzfx((String)"onEnterAmbient must be called on the main thread.");
        Bundle bundle2 = bundle;
        zzb zzb2 = this.zzigm;
        if (zzb2.zzaoa() != null) {
            ((zza)zzb2.zzaoa()).onEnterAmbient(bundle2);
        }
    }

    public final void onExitAmbient() {
        zzbp.zzfx((String)"onExitAmbient must be called on the main thread.");
        zzb zzb2 = this.zzigm;
        if (zzb2.zzaoa() != null) {
            ((zza)zzb2.zzaoa()).onExitAmbient();
        }
    }

    public void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
        zzbp.zzfx((String)"getMapAsync must be called on the main thread.");
        this.zzigm.getMapAsync(onMapReadyCallback);
    }

    public void setArguments(Bundle bundle) {
        super.setArguments(bundle);
    }

    static final class zzb
    extends com.google.android.gms.dynamic.zza<zza> {
        private final Fragment zzgov;
        private zzo<zza> zzigp;
        private Activity mActivity;
        private final List<OnMapReadyCallback> zzigq = new ArrayList<OnMapReadyCallback>();

        zzb(Fragment fragment) {
            this.zzgov = fragment;
        }

        protected final void zza(zzo<zza> zzo2) {
            this.zzigp = zzo2;
            this.zzatm();
        }

        private final void zzatm() {
            if (this.mActivity != null && this.zzigp != null && this.zzaoa() == null) {
                try {
                    MapsInitializer.initialize((Context)this.mActivity);
                    IMapFragmentDelegate iMapFragmentDelegate = zzbx.zzdk((Context)this.mActivity).zzae(zzn.zzw((Object)this.mActivity));
                    if (iMapFragmentDelegate == null) {
                        return;
                    }
                    this.zzigp.zza((LifecycleDelegate)new zza(this.zzgov, iMapFragmentDelegate));
                    for (OnMapReadyCallback onMapReadyCallback : this.zzigq) {
                        ((zza)this.zzaoa()).getMapAsync(onMapReadyCallback);
                    }
                    this.zzigq.clear();
                    return;
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeRemoteException(remoteException);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {}
            }
        }

        private final void setActivity(Activity activity) {
            this.mActivity = activity;
            this.zzatm();
        }

        public final void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
            if (this.zzaoa() != null) {
                ((zza)this.zzaoa()).getMapAsync(onMapReadyCallback);
                return;
            }
            this.zzigq.add(onMapReadyCallback);
        }
    }

    static final class zza
    implements MapLifecycleDelegate {
        private final Fragment zzgov;
        private final IMapFragmentDelegate zzign;

        public zza(Fragment fragment, IMapFragmentDelegate iMapFragmentDelegate) {
            this.zzign = (IMapFragmentDelegate)zzbp.zzu((Object)iMapFragmentDelegate);
            this.zzgov = (Fragment)zzbp.zzu((Object)fragment);
        }

        public final void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            GoogleMapOptions googleMapOptions = (GoogleMapOptions)bundle.getParcelable("MapOptions");
            try {
                Bundle bundle3 = new Bundle();
                zzbw.zzd(bundle2, bundle3);
                this.zzign.onInflate(zzn.zzw((Object)activity), googleMapOptions, bundle3);
                zzbw.zzd(bundle3, bundle2);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onCreate(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzbw.zzd(bundle, bundle2);
                Bundle bundle3 = this.zzgov.getArguments();
                if (bundle3 != null && bundle3.containsKey("MapOptions")) {
                    zzbw.zza(bundle2, "MapOptions", bundle3.getParcelable("MapOptions"));
                }
                this.zzign.onCreate(bundle2);
                zzbw.zzd(bundle2, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            IObjectWrapper iObjectWrapper;
            try {
                Bundle bundle2 = new Bundle();
                zzbw.zzd(bundle, bundle2);
                iObjectWrapper = this.zzign.onCreateView(zzn.zzw((Object)layoutInflater), zzn.zzw((Object)viewGroup), bundle2);
                zzbw.zzd(bundle2, bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
            return (View)zzn.zzab((IObjectWrapper)iObjectWrapper);
        }

        public final void onStart() {
            try {
                this.zzign.onStart();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onResume() {
            try {
                this.zzign.onResume();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onPause() {
            try {
                this.zzign.onPause();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onStop() {
            try {
                this.zzign.onStop();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onDestroyView() {
            try {
                this.zzign.onDestroyView();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onDestroy() {
            try {
                this.zzign.onDestroy();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onLowMemory() {
            try {
                this.zzign.onLowMemory();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onSaveInstanceState(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzbw.zzd(bundle, bundle2);
                this.zzign.onSaveInstanceState(bundle2);
                zzbw.zzd(bundle2, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public final void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
            try {
                this.zzign.getMapAsync(new zzaa(this, onMapReadyCallback));
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onEnterAmbient(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzbw.zzd(bundle, bundle2);
                this.zzign.onEnterAmbient(bundle2);
                zzbw.zzd(bundle2, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onExitAmbient() {
            try {
                this.zzign.onExitAmbient();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }
    }
}

