/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.zzd;

public final class GroundOverlayOptions
extends zza {
    public static final Parcelable.Creator<GroundOverlayOptions> CREATOR = new zzd();
    public static final float NO_DIMENSION = -1.0f;
    @NonNull
    private BitmapDescriptor zzbnp;
    private LatLng zzbnq;
    private float zzbnr;
    private float zzbns;
    private LatLngBounds zzblq;
    private float zzbnf;
    private float zzbnk;
    private boolean zzbnl = true;
    private float zzbnt = 0.0f;
    private float zzbnu = 0.5f;
    private float zzbnv = 0.5f;
    private boolean zzbnm = false;

    GroundOverlayOptions(IBinder iBinder, LatLng latLng, float f, float f2, LatLngBounds latLngBounds, float f3, float f4, boolean bl, float f5, float f6, float f7, boolean bl2) {
        this.zzbnp = new BitmapDescriptor(IObjectWrapper.zza.zzM((IBinder)iBinder));
        this.zzbnq = latLng;
        this.zzbnr = f;
        this.zzbns = f2;
        this.zzblq = latLngBounds;
        this.zzbnf = f3;
        this.zzbnk = f4;
        this.zzbnl = bl;
        this.zzbnt = f5;
        this.zzbnu = f6;
        this.zzbnv = f7;
        this.zzbnm = bl2;
    }

    public GroundOverlayOptions() {
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GroundOverlayOptions groundOverlayOptions = this;
        int n2 = com.google.android.gms.common.internal.safeparcel.zzd.zze((Parcel)parcel2);
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)2, (IBinder)groundOverlayOptions.zzbnp.zzwe().asBinder(), (boolean)false);
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)3, (Parcelable)groundOverlayOptions.getLocation(), (int)n, (boolean)false);
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)4, (float)groundOverlayOptions.getWidth());
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)5, (float)groundOverlayOptions.getHeight());
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)6, (Parcelable)groundOverlayOptions.getBounds(), (int)n, (boolean)false);
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)7, (float)groundOverlayOptions.getBearing());
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)8, (float)groundOverlayOptions.getZIndex());
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)9, (boolean)groundOverlayOptions.isVisible());
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)10, (float)groundOverlayOptions.getTransparency());
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)11, (float)groundOverlayOptions.getAnchorU());
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)12, (float)groundOverlayOptions.getAnchorV());
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)13, (boolean)groundOverlayOptions.isClickable());
        com.google.android.gms.common.internal.safeparcel.zzd.zzI((Parcel)parcel2, (int)n2);
    }

    public final GroundOverlayOptions image(@NonNull BitmapDescriptor bitmapDescriptor) {
        zzbo.zzb((Object)bitmapDescriptor, (Object)"imageDescriptor must not be null");
        this.zzbnp = bitmapDescriptor;
        return this;
    }

    public final GroundOverlayOptions anchor(float f, float f2) {
        this.zzbnu = f;
        this.zzbnv = f2;
        return this;
    }

    public final GroundOverlayOptions position(LatLng latLng, float f) {
        zzbo.zza((this.zzblq == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        zzbo.zzb((latLng != null ? 1 : 0) != 0, (Object)"Location must be specified");
        zzbo.zzb((f >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        return this.zza(latLng, f, -1.0f);
    }

    public final GroundOverlayOptions position(LatLng latLng, float f, float f2) {
        zzbo.zza((this.zzblq == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        zzbo.zzb((latLng != null ? 1 : 0) != 0, (Object)"Location must be specified");
        zzbo.zzb((f >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        zzbo.zzb((f2 >= 0.0f ? 1 : 0) != 0, (Object)"Height must be non-negative");
        return this.zza(latLng, f, f2);
    }

    private final GroundOverlayOptions zza(LatLng latLng, float f, float f2) {
        this.zzbnq = latLng;
        this.zzbnr = f;
        this.zzbns = f2;
        return this;
    }

    public final GroundOverlayOptions positionFromBounds(LatLngBounds latLngBounds) {
        String string = String.valueOf((Object)this.zzbnq);
        zzbo.zza((this.zzbnq == null ? 1 : 0) != 0, (Object)new StringBuilder(46 + String.valueOf(string).length()).append("Position has already been set using position: ").append(string).toString());
        this.zzblq = latLngBounds;
        return this;
    }

    public final GroundOverlayOptions bearing(float f) {
        this.zzbnf = (f % 360.0f + 360.0f) % 360.0f;
        return this;
    }

    public final GroundOverlayOptions zIndex(float f) {
        this.zzbnk = f;
        return this;
    }

    public final GroundOverlayOptions visible(boolean bl) {
        this.zzbnl = bl;
        return this;
    }

    public final GroundOverlayOptions transparency(float f) {
        zzbo.zzb((f >= 0.0f && f <= 1.0f ? 1 : 0) != 0, (Object)"Transparency must be in the range [0..1]");
        this.zzbnt = f;
        return this;
    }

    public final GroundOverlayOptions clickable(boolean bl) {
        this.zzbnm = bl;
        return this;
    }

    public final BitmapDescriptor getImage() {
        return this.zzbnp;
    }

    public final LatLng getLocation() {
        return this.zzbnq;
    }

    public final float getWidth() {
        return this.zzbnr;
    }

    public final float getHeight() {
        return this.zzbns;
    }

    public final LatLngBounds getBounds() {
        return this.zzblq;
    }

    public final float getBearing() {
        return this.zzbnf;
    }

    public final float getZIndex() {
        return this.zzbnk;
    }

    public final float getTransparency() {
        return this.zzbnt;
    }

    public final float getAnchorU() {
        return this.zzbnu;
    }

    public final float getAnchorV() {
        return this.zzbnv;
    }

    public final boolean isVisible() {
        return this.zzbnl;
    }

    public final boolean isClickable() {
        return this.zzbnm;
    }
}

