/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbe;
import com.google.android.gms.maps.internal.zza;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.zzz;

public final class GoogleMapOptions
extends com.google.android.gms.common.internal.safeparcel.zza
implements ReflectedParcelable {
    public static final Parcelable.Creator<GoogleMapOptions> CREATOR = new zzz();
    private Boolean zzblZ;
    private Boolean zzbma;
    private int zzbmb = -1;
    private CameraPosition zzbmc;
    private Boolean zzbmd;
    private Boolean zzbme;
    private Boolean zzbmf;
    private Boolean zzbmg;
    private Boolean zzbmh;
    private Boolean zzbmi;
    private Boolean zzbmj;
    private Boolean zzbmk;
    private Boolean zzbml;
    private Float zzbmm = null;
    private Float zzbmn = null;
    private LatLngBounds zzbmo = null;

    GoogleMapOptions(byte by, byte by2, int n, CameraPosition cameraPosition, byte by3, byte by4, byte by5, byte by6, byte by7, byte by8, byte by9, byte by10, byte by11, Float f, Float f2, LatLngBounds latLngBounds) {
        this.zzblZ = zza.zza(by);
        this.zzbma = zza.zza(by2);
        this.zzbmb = n;
        this.zzbmc = cameraPosition;
        this.zzbmd = zza.zza(by3);
        this.zzbme = zza.zza(by4);
        this.zzbmf = zza.zza(by5);
        this.zzbmg = zza.zza(by6);
        this.zzbmh = zza.zza(by7);
        this.zzbmi = zza.zza(by8);
        this.zzbmj = zza.zza(by9);
        this.zzbmk = zza.zza(by10);
        this.zzbml = zza.zza(by11);
        this.zzbmm = f;
        this.zzbmn = f2;
        this.zzbmo = latLngBounds;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GoogleMapOptions googleMapOptions = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)2, (byte)zza.zzb(googleMapOptions.zzblZ));
        zzd.zza((Parcel)parcel2, (int)3, (byte)zza.zzb(googleMapOptions.zzbma));
        zzd.zzc((Parcel)parcel2, (int)4, (int)googleMapOptions.getMapType());
        zzd.zza((Parcel)parcel2, (int)5, (Parcelable)googleMapOptions.getCamera(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)6, (byte)zza.zzb(googleMapOptions.zzbmd));
        zzd.zza((Parcel)parcel2, (int)7, (byte)zza.zzb(googleMapOptions.zzbme));
        zzd.zza((Parcel)parcel2, (int)8, (byte)zza.zzb(googleMapOptions.zzbmf));
        zzd.zza((Parcel)parcel2, (int)9, (byte)zza.zzb(googleMapOptions.zzbmg));
        zzd.zza((Parcel)parcel2, (int)10, (byte)zza.zzb(googleMapOptions.zzbmh));
        zzd.zza((Parcel)parcel2, (int)11, (byte)zza.zzb(googleMapOptions.zzbmi));
        zzd.zza((Parcel)parcel2, (int)12, (byte)zza.zzb(googleMapOptions.zzbmj));
        zzd.zza((Parcel)parcel2, (int)14, (byte)zza.zzb(googleMapOptions.zzbmk));
        zzd.zza((Parcel)parcel2, (int)15, (byte)zza.zzb(googleMapOptions.zzbml));
        zzd.zza((Parcel)parcel2, (int)16, (Float)googleMapOptions.getMinZoomPreference(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)17, (Float)googleMapOptions.getMaxZoomPreference(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)18, (Parcelable)googleMapOptions.getLatLngBoundsForCameraTarget(), (int)n, (boolean)false);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    public GoogleMapOptions() {
    }

    public final GoogleMapOptions zOrderOnTop(boolean bl) {
        this.zzblZ = bl;
        return this;
    }

    public final GoogleMapOptions useViewLifecycleInFragment(boolean bl) {
        this.zzbma = bl;
        return this;
    }

    public final GoogleMapOptions mapType(int n) {
        this.zzbmb = n;
        return this;
    }

    public final GoogleMapOptions camera(CameraPosition cameraPosition) {
        this.zzbmc = cameraPosition;
        return this;
    }

    public final GoogleMapOptions zoomControlsEnabled(boolean bl) {
        this.zzbmd = bl;
        return this;
    }

    public final GoogleMapOptions compassEnabled(boolean bl) {
        this.zzbme = bl;
        return this;
    }

    public final GoogleMapOptions scrollGesturesEnabled(boolean bl) {
        this.zzbmf = bl;
        return this;
    }

    public final GoogleMapOptions zoomGesturesEnabled(boolean bl) {
        this.zzbmg = bl;
        return this;
    }

    public final GoogleMapOptions tiltGesturesEnabled(boolean bl) {
        this.zzbmh = bl;
        return this;
    }

    public final GoogleMapOptions rotateGesturesEnabled(boolean bl) {
        this.zzbmi = bl;
        return this;
    }

    public final GoogleMapOptions liteMode(boolean bl) {
        this.zzbmj = bl;
        return this;
    }

    public final GoogleMapOptions mapToolbarEnabled(boolean bl) {
        this.zzbmk = bl;
        return this;
    }

    public final GoogleMapOptions ambientEnabled(boolean bl) {
        this.zzbml = bl;
        return this;
    }

    public final GoogleMapOptions minZoomPreference(float f) {
        this.zzbmm = Float.valueOf(f);
        return this;
    }

    public final GoogleMapOptions maxZoomPreference(float f) {
        this.zzbmn = Float.valueOf(f);
        return this;
    }

    public final GoogleMapOptions latLngBoundsForCameraTarget(LatLngBounds latLngBounds) {
        this.zzbmo = latLngBounds;
        return this;
    }

    public final Boolean getZOrderOnTop() {
        return this.zzblZ;
    }

    public final Boolean getUseViewLifecycleInFragment() {
        return this.zzbma;
    }

    public final int getMapType() {
        return this.zzbmb;
    }

    public final CameraPosition getCamera() {
        return this.zzbmc;
    }

    public final Boolean getZoomControlsEnabled() {
        return this.zzbmd;
    }

    public final Boolean getCompassEnabled() {
        return this.zzbme;
    }

    public final Boolean getScrollGesturesEnabled() {
        return this.zzbmf;
    }

    public final Boolean getZoomGesturesEnabled() {
        return this.zzbmg;
    }

    public final Boolean getTiltGesturesEnabled() {
        return this.zzbmh;
    }

    public final Boolean getRotateGesturesEnabled() {
        return this.zzbmi;
    }

    public final Boolean getLiteMode() {
        return this.zzbmj;
    }

    public final Boolean getMapToolbarEnabled() {
        return this.zzbmk;
    }

    public final Boolean getAmbientEnabled() {
        return this.zzbml;
    }

    public final Float getMinZoomPreference() {
        return this.zzbmm;
    }

    public final Float getMaxZoomPreference() {
        return this.zzbmn;
    }

    public final LatLngBounds getLatLngBoundsForCameraTarget() {
        return this.zzbmo;
    }

    public static GoogleMapOptions createFromAttributes(Context context, AttributeSet attributeSet) {
        if (attributeSet == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attributeSet, R.styleable.MapAttrs);
        GoogleMapOptions googleMapOptions = new GoogleMapOptions();
        if (typedArray.hasValue(R.styleable.MapAttrs_mapType)) {
            googleMapOptions.mapType(typedArray.getInt(R.styleable.MapAttrs_mapType, -1));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_zOrderOnTop)) {
            googleMapOptions.zOrderOnTop(typedArray.getBoolean(R.styleable.MapAttrs_zOrderOnTop, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_useViewLifecycle)) {
            googleMapOptions.useViewLifecycleInFragment(typedArray.getBoolean(R.styleable.MapAttrs_useViewLifecycle, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiCompass)) {
            googleMapOptions.compassEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiCompass, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiRotateGestures)) {
            googleMapOptions.rotateGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiRotateGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiScrollGestures)) {
            googleMapOptions.scrollGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiScrollGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiTiltGestures)) {
            googleMapOptions.tiltGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiTiltGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomGestures)) {
            googleMapOptions.zoomGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomControls)) {
            googleMapOptions.zoomControlsEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomControls, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_liteMode)) {
            googleMapOptions.liteMode(typedArray.getBoolean(R.styleable.MapAttrs_liteMode, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiMapToolbar)) {
            googleMapOptions.mapToolbarEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiMapToolbar, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_ambientEnabled)) {
            googleMapOptions.ambientEnabled(typedArray.getBoolean(R.styleable.MapAttrs_ambientEnabled, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraMinZoomPreference)) {
            googleMapOptions.minZoomPreference(typedArray.getFloat(R.styleable.MapAttrs_cameraMinZoomPreference, Float.NEGATIVE_INFINITY));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraMinZoomPreference)) {
            googleMapOptions.maxZoomPreference(typedArray.getFloat(R.styleable.MapAttrs_cameraMaxZoomPreference, Float.POSITIVE_INFINITY));
        }
        LatLngBounds latLngBounds = LatLngBounds.createFromAttributes(context, attributeSet);
        googleMapOptions.latLngBoundsForCameraTarget(latLngBounds);
        CameraPosition cameraPosition = CameraPosition.createFromAttributes(context, attributeSet);
        googleMapOptions.camera(cameraPosition);
        typedArray.recycle();
        return googleMapOptions;
    }

    public final String toString() {
        return zzbe.zzt((Object)((Object)this)).zzg("MapType", (Object)this.zzbmb).zzg("LiteMode", (Object)this.zzbmj).zzg("Camera", (Object)this.zzbmc).zzg("CompassEnabled", (Object)this.zzbme).zzg("ZoomControlsEnabled", (Object)this.zzbmd).zzg("ScrollGesturesEnabled", (Object)this.zzbmf).zzg("ZoomGesturesEnabled", (Object)this.zzbmg).zzg("TiltGesturesEnabled", (Object)this.zzbmh).zzg("RotateGesturesEnabled", (Object)this.zzbmi).zzg("MapToolbarEnabled", (Object)this.zzbmk).zzg("AmbientEnabled", (Object)this.zzbml).zzg("MinZoomPreference", (Object)this.zzbmm).zzg("MaxZoomPreference", (Object)this.zzbmn).zzg("LatLngBoundsForCameraTarget", (Object)this.zzbmo).zzg("ZOrderOnTop", (Object)this.zzblZ).zzg("UseViewLifecycleInFragment", (Object)this.zzbma).toString();
    }
}

