/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.maps.model.zzp;

public class StreetViewPanoramaOrientation
extends zza {
    public static final Parcelable.Creator<StreetViewPanoramaOrientation> CREATOR = new zzp();
    public final float tilt;
    public final float bearing;

    public StreetViewPanoramaOrientation(float f, float f2) {
        zzac.zzb((-90.0f <= f && f <= 90.0f ? 1 : 0) != 0, (Object)"Tilt needs to be between -90 and 90 inclusive");
        this.tilt = f + 0.0f;
        this.bearing = ((double)f2 <= 0.0 ? f2 % 360.0f + 360.0f : f2) % 360.0f;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzp.zza(this, parcel, n);
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{Float.valueOf(this.tilt), Float.valueOf(this.bearing)});
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(StreetViewPanoramaOrientation streetViewPanoramaOrientation) {
        return new Builder(streetViewPanoramaOrientation);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof StreetViewPanoramaOrientation)) {
            return false;
        }
        StreetViewPanoramaOrientation streetViewPanoramaOrientation = (StreetViewPanoramaOrientation)((Object)object);
        return Float.floatToIntBits(this.tilt) == Float.floatToIntBits(streetViewPanoramaOrientation.tilt) && Float.floatToIntBits(this.bearing) == Float.floatToIntBits(streetViewPanoramaOrientation.bearing);
    }

    public String toString() {
        return zzaa.zzv((Object)((Object)this)).zzg("tilt", (Object)Float.valueOf(this.tilt)).zzg("bearing", (Object)Float.valueOf(this.bearing)).toString();
    }

    public static final class Builder {
        public float bearing;
        public float tilt;

        public Builder() {
        }

        public Builder(StreetViewPanoramaOrientation streetViewPanoramaOrientation) {
            StreetViewPanoramaOrientation streetViewPanoramaOrientation2 = streetViewPanoramaOrientation;
            this.bearing = streetViewPanoramaOrientation2.bearing;
            this.tilt = streetViewPanoramaOrientation2.tilt;
        }

        public Builder tilt(float f) {
            this.tilt = f;
            return this;
        }

        public Builder bearing(float f) {
            this.bearing = f;
            return this;
        }

        public StreetViewPanoramaOrientation build() {
            return new StreetViewPanoramaOrientation(this.tilt, this.bearing);
        }
    }
}

