/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.zzd;

public final class GroundOverlayOptions
extends zza {
    public static final Parcelable.Creator<GroundOverlayOptions> CREATOR = new zzd();
    public static final float NO_DIMENSION = -1.0f;
    @NonNull
    private BitmapDescriptor zzbpm;
    private LatLng zzbpn;
    private float zzbpo;
    private float zzbpp;
    private LatLngBounds zzbno;
    private float zzbpc;
    private float zzbph;
    private boolean zzbpi = true;
    private float zzbpq = 0.0f;
    private float zzbpr = 0.5f;
    private float zzbps = 0.5f;
    private boolean zzbpj = false;

    GroundOverlayOptions(IBinder iBinder, LatLng latLng, float f, float f2, LatLngBounds latLngBounds, float f3, float f4, boolean bl, float f5, float f6, float f7, boolean bl2) {
        this.zzbpm = new BitmapDescriptor(IObjectWrapper.zza.zzcd((IBinder)iBinder));
        this.zzbpn = latLng;
        this.zzbpo = f;
        this.zzbpp = f2;
        this.zzbno = latLngBounds;
        this.zzbpc = f3;
        this.zzbph = f4;
        this.zzbpi = bl;
        this.zzbpq = f5;
        this.zzbpr = f6;
        this.zzbps = f7;
        this.zzbpj = bl2;
    }

    public GroundOverlayOptions() {
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzd.zza(this, parcel, n);
    }

    IBinder zzJK() {
        IObjectWrapper iObjectWrapper = this.zzbpm.zzJm();
        return iObjectWrapper.asBinder();
    }

    public GroundOverlayOptions image(@NonNull BitmapDescriptor bitmapDescriptor) {
        zzac.zzb((Object)bitmapDescriptor, (Object)"imageDescriptor must not be null");
        this.zzbpm = bitmapDescriptor;
        return this;
    }

    public GroundOverlayOptions anchor(float f, float f2) {
        this.zzbpr = f;
        this.zzbps = f2;
        return this;
    }

    public GroundOverlayOptions position(LatLng latLng, float f) {
        zzac.zza((this.zzbno == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        zzac.zzb((latLng != null ? 1 : 0) != 0, (Object)"Location must be specified");
        zzac.zzb((f >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        return this.zza(latLng, f, -1.0f);
    }

    public GroundOverlayOptions position(LatLng latLng, float f, float f2) {
        zzac.zza((this.zzbno == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        zzac.zzb((latLng != null ? 1 : 0) != 0, (Object)"Location must be specified");
        zzac.zzb((f >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        zzac.zzb((f2 >= 0.0f ? 1 : 0) != 0, (Object)"Height must be non-negative");
        return this.zza(latLng, f, f2);
    }

    private GroundOverlayOptions zza(LatLng latLng, float f, float f2) {
        this.zzbpn = latLng;
        this.zzbpo = f;
        this.zzbpp = f2;
        return this;
    }

    public GroundOverlayOptions positionFromBounds(LatLngBounds latLngBounds) {
        String string = String.valueOf((Object)this.zzbpn);
        zzac.zza((this.zzbpn == null ? 1 : 0) != 0, (Object)new StringBuilder(46 + String.valueOf(string).length()).append("Position has already been set using position: ").append(string).toString());
        this.zzbno = latLngBounds;
        return this;
    }

    public GroundOverlayOptions bearing(float f) {
        this.zzbpc = (f % 360.0f + 360.0f) % 360.0f;
        return this;
    }

    public GroundOverlayOptions zIndex(float f) {
        this.zzbph = f;
        return this;
    }

    public GroundOverlayOptions visible(boolean bl) {
        this.zzbpi = bl;
        return this;
    }

    public GroundOverlayOptions transparency(float f) {
        zzac.zzb((f >= 0.0f && f <= 1.0f ? 1 : 0) != 0, (Object)"Transparency must be in the range [0..1]");
        this.zzbpq = f;
        return this;
    }

    public GroundOverlayOptions clickable(boolean bl) {
        this.zzbpj = bl;
        return this;
    }

    public BitmapDescriptor getImage() {
        return this.zzbpm;
    }

    public LatLng getLocation() {
        return this.zzbpn;
    }

    public float getWidth() {
        return this.zzbpo;
    }

    public float getHeight() {
        return this.zzbpp;
    }

    public LatLngBounds getBounds() {
        return this.zzbno;
    }

    public float getBearing() {
        return this.zzbpc;
    }

    public float getZIndex() {
        return this.zzbph;
    }

    public float getTransparency() {
        return this.zzbpq;
    }

    public float getAnchorU() {
        return this.zzbpr;
    }

    public float getAnchorV() {
        return this.zzbps;
    }

    public boolean isVisible() {
        return this.zzbpi;
    }

    public boolean isClickable() {
        return this.zzbpj;
    }
}

