/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.internal.IGoogleMapDelegate;
import com.google.android.gms.maps.internal.IMapViewDelegate;
import com.google.android.gms.maps.internal.MapLifecycleDelegate;
import com.google.android.gms.maps.internal.zzah;
import com.google.android.gms.maps.internal.zzai;
import com.google.android.gms.maps.internal.zzt;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import java.util.ArrayList;
import java.util.List;

public class MapView
extends FrameLayout {
    private final zzb zzbot;

    public MapView(Context context) {
        super(context);
        this.zzbot = new zzb((ViewGroup)this, context, null);
        this.zzJA();
    }

    public MapView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.zzbot = new zzb((ViewGroup)this, context, GoogleMapOptions.createFromAttributes(context, attributeSet));
        this.zzJA();
    }

    public MapView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.zzbot = new zzb((ViewGroup)this, context, GoogleMapOptions.createFromAttributes(context, attributeSet));
        this.zzJA();
    }

    public MapView(Context context, GoogleMapOptions googleMapOptions) {
        super(context);
        this.zzbot = new zzb((ViewGroup)this, context, googleMapOptions);
        this.zzJA();
    }

    private void zzJA() {
        this.setClickable(true);
    }

    public final void onCreate(Bundle bundle) {
        this.zzbot.onCreate(bundle);
        if (this.zzbot.zzBN() == null) {
            com.google.android.gms.dynamic.zza.zzb((FrameLayout)this);
        }
    }

    public final void onResume() {
        this.zzbot.onResume();
    }

    public final void onPause() {
        this.zzbot.onPause();
    }

    public final void onStart() {
        this.zzbot.onStart();
    }

    public final void onStop() {
        this.zzbot.onStop();
    }

    public final void onDestroy() {
        this.zzbot.onDestroy();
    }

    public final void onLowMemory() {
        this.zzbot.onLowMemory();
    }

    public final void onSaveInstanceState(Bundle bundle) {
        this.zzbot.onSaveInstanceState(bundle);
    }

    public void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
        zzac.zzdj((String)"getMapAsync() must be called on the main thread");
        this.zzbot.getMapAsync(onMapReadyCallback);
    }

    public final void onEnterAmbient(Bundle bundle) {
        zzac.zzdj((String)"onEnterAmbient() must be called on the main thread");
        this.zzbot.onEnterAmbient(bundle);
    }

    public final void onExitAmbient() {
        zzac.zzdj((String)"onExitAmbient() must be called on the main thread");
        this.zzbot.onExitAmbient();
    }

    static class zzb
    extends com.google.android.gms.dynamic.zza<zza> {
        private final ViewGroup zzbox;
        private final Context mContext;
        protected zze<zza> zzbor;
        private final GoogleMapOptions zzboy;
        private final List<OnMapReadyCallback> zzbos = new ArrayList<OnMapReadyCallback>();

        zzb(ViewGroup viewGroup, Context context, GoogleMapOptions googleMapOptions) {
            this.zzbox = viewGroup;
            this.mContext = context;
            this.zzboy = googleMapOptions;
        }

        protected void zza(zze<zza> zze2) {
            this.zzbor = zze2;
            this.zzJz();
        }

        public void zzJz() {
            if (this.zzbor != null && this.zzBN() == null) {
                try {
                    MapsInitializer.initialize(this.mContext);
                    IMapViewDelegate iMapViewDelegate = zzai.zzbI(this.mContext).zza(zzd.zzA((Object)this.mContext), this.zzboy);
                    if (iMapViewDelegate == null) {
                        return;
                    }
                    this.zzbor.zza((LifecycleDelegate)new zza(this.zzbox, iMapViewDelegate));
                    for (OnMapReadyCallback onMapReadyCallback : this.zzbos) {
                        ((zza)this.zzBN()).getMapAsync(onMapReadyCallback);
                    }
                    this.zzbos.clear();
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeRemoteException(remoteException);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {}
            }
        }

        public void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
            if (this.zzBN() != null) {
                ((zza)this.zzBN()).getMapAsync(onMapReadyCallback);
            } else {
                this.zzbos.add(onMapReadyCallback);
            }
        }

        public void onEnterAmbient(Bundle bundle) {
            if (this.zzBN() != null) {
                ((zza)this.zzBN()).onEnterAmbient(bundle);
            }
        }

        public void onExitAmbient() {
            if (this.zzBN() != null) {
                ((zza)this.zzBN()).onExitAmbient();
            }
        }
    }

    static class zza
    implements MapLifecycleDelegate {
        private final ViewGroup zzbou;
        private final IMapViewDelegate zzbov;
        private View zzbow;

        public zza(ViewGroup viewGroup, IMapViewDelegate iMapViewDelegate) {
            this.zzbov = (IMapViewDelegate)zzac.zzw((Object)iMapViewDelegate);
            this.zzbou = (ViewGroup)zzac.zzw((Object)viewGroup);
        }

        public void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            throw new UnsupportedOperationException("onInflate not allowed on MapViewDelegate");
        }

        public void onCreate(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzah.zzd(bundle, bundle2);
                this.zzbov.onCreate(bundle2);
                zzah.zzd(bundle2, bundle);
                this.zzbow = (View)zzd.zzF((IObjectWrapper)this.zzbov.getView());
                this.zzbou.removeAllViews();
                this.zzbou.addView(this.zzbow);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            throw new UnsupportedOperationException("onCreateView not allowed on MapViewDelegate");
        }

        public void onStart() {
            try {
                this.zzbov.onStart();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onResume() {
            try {
                this.zzbov.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onPause() {
            try {
                this.zzbov.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onStop() {
            try {
                this.zzbov.onStop();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onDestroyView() {
            throw new UnsupportedOperationException("onDestroyView not allowed on MapViewDelegate");
        }

        public void onDestroy() {
            try {
                this.zzbov.onDestroy();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onLowMemory() {
            try {
                this.zzbov.onLowMemory();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onSaveInstanceState(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzah.zzd(bundle, bundle2);
                this.zzbov.onSaveInstanceState(bundle2);
                zzah.zzd(bundle2, bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public void getMapAsync(final OnMapReadyCallback onMapReadyCallback) {
            try {
                this.zzbov.getMapAsync(new zzt.zza(this){

                    @Override
                    public void zza(IGoogleMapDelegate iGoogleMapDelegate) throws RemoteException {
                        onMapReadyCallback.onMapReady(new GoogleMap(iGoogleMapDelegate));
                    }
                });
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onEnterAmbient(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzah.zzd(bundle, bundle2);
                this.zzbov.onEnterAmbient(bundle2);
                zzah.zzd(bundle2, bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onExitAmbient() {
            try {
                this.zzbov.onExitAmbient();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }
    }
}

