/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.ButtCap;
import com.google.android.gms.maps.model.CustomCap;
import com.google.android.gms.maps.model.RoundCap;
import com.google.android.gms.maps.model.SquareCap;
import com.google.android.gms.maps.model.zzb;

public class Cap
extends zza {
    private static final String TAG = Cap.class.getSimpleName();
    public static final Parcelable.Creator<Cap> CREATOR = new zzb();
    private final int type;
    @Nullable
    private final BitmapDescriptor bitmapDescriptor;
    @Nullable
    private final Float zzbpe;

    private Cap(int n, @Nullable BitmapDescriptor bitmapDescriptor, @Nullable Float f) {
        boolean bl = f != null && f.floatValue() > 0.0f;
        String string = String.valueOf(bitmapDescriptor);
        String string2 = String.valueOf(f);
        zzac.zzb((n != 3 || bitmapDescriptor != null && bl ? 1 : 0) != 0, (Object)new StringBuilder(63 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Invalid Cap: type=").append(n).append(" bitmapDescriptor=").append(string).append(" bitmapRefWidth=").append(string2).toString());
        this.type = n;
        this.bitmapDescriptor = bitmapDescriptor;
        this.zzbpe = f;
    }

    Cap(int n, @Nullable IBinder iBinder, @Nullable Float f) {
        this(n, Cap.zzeh(iBinder), f);
    }

    protected Cap(@NonNull BitmapDescriptor bitmapDescriptor, float f) {
        this(3, bitmapDescriptor, Float.valueOf(f));
    }

    protected Cap(int n) {
        this(n, (BitmapDescriptor)null, (Float)null);
    }

    public int getType() {
        return this.type;
    }

    @Nullable
    public Float zzJH() {
        return this.zzbpe;
    }

    @Nullable
    IBinder zzJI() {
        if (this.bitmapDescriptor == null) {
            return null;
        }
        IObjectWrapper iObjectWrapper = this.bitmapDescriptor.zzJm();
        return iObjectWrapper.asBinder();
    }

    @Nullable
    private static BitmapDescriptor zzeh(@Nullable IBinder iBinder) {
        if (iBinder == null) {
            return null;
        }
        IObjectWrapper iObjectWrapper = IObjectWrapper.zza.zzcd((IBinder)iBinder);
        return new BitmapDescriptor(iObjectWrapper);
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzb.zza(this, parcel, n);
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.type, this.bitmapDescriptor, this.zzbpe});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Cap)) {
            return false;
        }
        Cap cap = (Cap)((Object)object);
        return this.type == cap.type && zzaa.equal((Object)this.bitmapDescriptor, (Object)cap.bitmapDescriptor) && zzaa.equal((Object)this.zzbpe, (Object)cap.zzbpe);
    }

    public String toString() {
        int n = this.type;
        return new StringBuilder(23).append("[Cap: type=").append(n).append("]").toString();
    }

    Cap zzJJ() {
        switch (this.type) {
            case 0: {
                return new ButtCap();
            }
            case 1: {
                return new SquareCap();
            }
            case 2: {
                return new RoundCap();
            }
            case 3: {
                return new CustomCap(this.bitmapDescriptor, this.zzbpe.floatValue());
            }
        }
        int n = this.type;
        Log.w((String)TAG, (String)new StringBuilder(29).append("Unknown Cap type: ").append(n).toString());
        return this;
    }
}

