/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.location.ActivityTransition;
import com.google.android.gms.location.zzf;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="ActivityTransitionEventCreator")
public class ActivityTransitionEvent
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<ActivityTransitionEvent> CREATOR = new zzf();
    @SafeParcelable.Field(id=1, getter="getActivityType")
    private final int zza;
    @SafeParcelable.Field(id=2, getter="getTransitionType")
    private final int zzb;
    @SafeParcelable.Field(id=3, getter="getElapsedRealTimeNanos")
    private final long zzc;

    /*
     * WARNING - void declaration
     */
    @SafeParcelable.Constructor
    public ActivityTransitionEvent(@SafeParcelable.Param(id=1) int activityType, @SafeParcelable.Param(id=2) int transitionType, @SafeParcelable.Param(id=3) long elapsedRealtimeNanos) {
        void var3_3;
        void var1_1;
        void var2_2;
        ActivityTransition.zza((int)var2_2);
        this.zza = var1_1;
        this.zzb = var2_2;
        this.zzc = var3_3;
    }

    public int getActivityType() {
        return this.zza;
    }

    public int getTransitionType() {
        return this.zzb;
    }

    public long getElapsedRealTimeNanos() {
        return this.zzc;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zza, this.zzb, this.zzc});
    }

    public boolean equals(@Nullable Object object) {
        ActivityTransitionEvent activityTransitionEvent;
        if (this == activityTransitionEvent) {
            return true;
        }
        if (!(activityTransitionEvent instanceof ActivityTransitionEvent)) {
            return false;
        }
        activityTransitionEvent = activityTransitionEvent;
        return this.zza == activityTransitionEvent.zza && this.zzb == activityTransitionEvent.zzb && this.zzc == activityTransitionEvent.zzc;
    }

    @NonNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.zza;
        int n2 = String.valueOf(n).length();
        StringBuilder stringBuilder2 = new StringBuilder(n2 + 13);
        stringBuilder2.append("ActivityType ");
        stringBuilder2.append(n);
        stringBuilder.append(stringBuilder2.toString());
        stringBuilder.append(" ");
        int n3 = this.zzb;
        n2 = String.valueOf(n3).length();
        StringBuilder stringBuilder3 = new StringBuilder(n2 + 15);
        stringBuilder3.append("TransitionType ");
        stringBuilder3.append(n3);
        stringBuilder.append(stringBuilder3.toString());
        stringBuilder.append(" ");
        long l = this.zzc;
        int n4 = String.valueOf(l).length();
        StringBuilder stringBuilder4 = new StringBuilder(n4 + 21);
        stringBuilder4.append("ElapsedRealTimeNanos ");
        stringBuilder4.append(l);
        stringBuilder.append(stringBuilder4.toString());
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel dest, int n) {
        void var1_1;
        Preconditions.checkNotNull((Object)dest);
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)var1_1);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)1, (int)this.getActivityType());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)2, (int)this.getTransitionType());
        void v1 = var1_1;
        SafeParcelWriter.writeLong((Parcel)v1, (int)3, (long)this.getElapsedRealTimeNanos());
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n2);
    }
}

