/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.location.zzbo;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="LocationRequestCreator")
public final class LocationRequest
extends AbstractSafeParcelable
implements ReflectedParcelable {
    @Deprecated
    public static final int PRIORITY_HIGH_ACCURACY = 100;
    @Deprecated
    public static final int PRIORITY_BALANCED_POWER_ACCURACY = 102;
    @Deprecated
    public static final int PRIORITY_LOW_POWER = 104;
    @Deprecated
    public static final int PRIORITY_NO_POWER = 105;
    @NonNull
    public static final Parcelable.Creator<LocationRequest> CREATOR;
    @SafeParcelable.Field(id=1, defaultValueUnchecked="Priority.PRIORITY_BALANCED_POWER_ACCURACY")
    int zza;
    @SafeParcelable.Field(id=2, defaultValueUnchecked="LocationRequest.DEFAULT_INTERVAL")
    long zzb;
    @SafeParcelable.Field(id=3, defaultValueUnchecked="LocationRequest.DEFAULT_FASTEST_INTERVAL")
    long zzc;
    @SafeParcelable.Field(id=4, defaultValue="false")
    boolean zzd;
    @SafeParcelable.Field(id=5, defaultValueUnchecked="Long.MAX_VALUE")
    long zze;
    @SafeParcelable.Field(id=6, defaultValueUnchecked="Integer.MAX_VALUE")
    int zzf;
    @SafeParcelable.Field(id=7, defaultValue="0")
    float zzg;
    @SafeParcelable.Field(id=8, defaultValue="0")
    long zzh;
    @SafeParcelable.Field(id=9, defaultValue="false")
    boolean zzi;

    public float getSmallestDisplacement() {
        return this.zzg;
    }

    public int getNumUpdates() {
        return this.zzf;
    }

    public int getPriority() {
        return this.zza;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.zza, this.zzb, Float.valueOf(this.zzg), this.zzh};
        return Objects.hashCode((Object[])objectArray);
    }

    public long getExpirationTime() {
        return this.zze;
    }

    public long getFastestInterval() {
        return this.zzc;
    }

    public long getInterval() {
        return this.zzb;
    }

    public long getMaxWaitTime() {
        long l = this.zzh;
        long l2 = this.zzb;
        if (l < l2) {
            return l2;
        }
        return l;
    }

    @NonNull
    public static LocationRequest create() {
        LocationRequest locationRequest = new LocationRequest(102, 3600000L, 600000L, false, Long.MAX_VALUE, Integer.MAX_VALUE, 0.0f, 0L, true);
        return locationRequest;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NonNull
    public LocationRequest setExpirationDuration(long millis) {
        long l;
        void var1_1;
        long l2 = SystemClock.elapsedRealtime();
        if (var1_1 > Long.MAX_VALUE - l2) {
            this.zze = Long.MAX_VALUE;
            l = Long.MAX_VALUE;
        } else {
            this.zze = l = var1_1 + l2;
        }
        if (l < 0L) {
            this.zze = 0L;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @NonNull
    public LocationRequest setExpirationTime(long millis) {
        void var1_1;
        this.zze = var1_1;
        if (var1_1 < 0L) {
            this.zze = 0L;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NonNull
    public LocationRequest setFastestInterval(long fastestIntervalMillis) {
        void var1_1;
        boolean bl = fastestIntervalMillis >= 0L;
        Object[] objectArray = new Object[]{(long)var1_1};
        Preconditions.checkArgument((boolean)bl, (String)"illegal fastest interval: %d", (Object[])objectArray);
        this.zzd = true;
        this.zzc = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NonNull
    public LocationRequest setInterval(long intervalMillis) {
        void var1_1;
        boolean bl = intervalMillis >= 0L;
        Object[] objectArray = new Object[]{(long)var1_1};
        Preconditions.checkArgument((boolean)bl, (String)"illegal interval: %d", (Object[])objectArray);
        this.zzb = var1_1;
        if (!this.zzd) {
            this.zzc = (long)((double)var1_1 / 6.0);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NonNull
    public LocationRequest setMaxWaitTime(long maxWaitTimeMillis) {
        void var1_1;
        boolean bl = maxWaitTimeMillis >= 0L;
        Object[] objectArray = new Object[]{(long)var1_1};
        Preconditions.checkArgument((boolean)bl, (String)"illegal max wait time: %d", (Object[])objectArray);
        this.zzh = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public LocationRequest setNumUpdates(int numUpdates) {
        void var1_1;
        if (numUpdates <= 0) {
            StringBuilder stringBuilder = new StringBuilder(31);
            stringBuilder.append("invalid numUpdates: ");
            stringBuilder.append((int)var1_1);
            Object object = new IllegalArgumentException(stringBuilder.toString());
            throw object;
        }
        object.zzf = var1_1;
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NonNull
    public LocationRequest setPriority(int priority) {
        boolean bl;
        int n;
        block4: {
            block5: {
                block6: {
                    if (priority == 100) break block5;
                    if (n == 102) break block6;
                    if (n != 104) {
                        if (n == 105) {
                            n = 105;
                            bl = true;
                            break block4;
                        } else {
                            bl = false;
                        }
                        break block4;
                    } else {
                        bl = true;
                    }
                    break block4;
                }
                bl = true;
                break block4;
            }
            bl = true;
        }
        Object[] objectArray = new Object[]{n};
        Preconditions.checkArgument((boolean)bl, (String)"illegal priority: %d", (Object[])objectArray);
        this.zza = n;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public LocationRequest setSmallestDisplacement(float smallestDisplacementMeters) {
        void var1_1;
        if (smallestDisplacementMeters < 0.0f) {
            StringBuilder stringBuilder = new StringBuilder(37);
            stringBuilder.append("invalid displacement: ");
            stringBuilder.append((float)var1_1);
            Object object = new IllegalArgumentException(stringBuilder.toString());
            throw object;
        }
        object.zzg = var1_1;
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public LocationRequest setWaitForAccurateLocation(boolean waitForAccurateLocation) {
        void var1_1;
        this.zzi = var1_1;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NonNull
    public String toString() {
        long l;
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Request[");
        switch (this.zza) {
            default: {
                string = "???";
                break;
            }
            case 105: {
                string = "PRIORITY_NO_POWER";
                break;
            }
            case 104: {
                string = "PRIORITY_LOW_POWER";
                break;
            }
            case 102: {
                string = "PRIORITY_BALANCED_POWER_ACCURACY";
                break;
            }
            case 100: {
                string = "PRIORITY_HIGH_ACCURACY";
            }
        }
        stringBuilder.append(string);
        if (this.zza != 105) {
            stringBuilder.append(" requested=");
            stringBuilder.append(this.zzb);
            stringBuilder.append("ms");
        }
        stringBuilder.append(" fastest=");
        stringBuilder.append(this.zzc);
        stringBuilder.append("ms");
        if (this.zzh > this.zzb) {
            stringBuilder.append(" maxWait=");
            stringBuilder.append(this.zzh);
            stringBuilder.append("ms");
        }
        if (this.zzg > 0.0f) {
            stringBuilder.append(" smallestDisplacement=");
            stringBuilder.append(this.zzg);
            stringBuilder.append("m");
        }
        if ((l = this.zze) != Long.MAX_VALUE) {
            long l2 = SystemClock.elapsedRealtime();
            stringBuilder.append(" expireIn=");
            stringBuilder.append(l - l2);
            stringBuilder.append("ms");
        }
        if (this.zzf != Integer.MAX_VALUE) {
            stringBuilder.append(" num=");
            stringBuilder.append(this.zzf);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    static {
        zzbo zzbo2;
        CREATOR = zzbo2 = new zzbo();
    }

    @Deprecated
    public LocationRequest() {
        this(102, 3600000L, 600000L, false, Long.MAX_VALUE, Integer.MAX_VALUE, 0.0f, 0L, false);
    }

    @SafeParcelable.Constructor
    LocationRequest(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) long l, @SafeParcelable.Param(id=3) long l2, @SafeParcelable.Param(id=4) boolean bl, @SafeParcelable.Param(id=5) long l3, @SafeParcelable.Param(id=6) int n2, @SafeParcelable.Param(id=7) float f, @SafeParcelable.Param(id=8) long l4, @SafeParcelable.Param(id=9) boolean bl2) {
        this.zza = n;
        this.zzb = l;
        this.zzc = l2;
        this.zzd = bl;
        this.zze = l3;
        this.zzf = n2;
        this.zzg = f;
        this.zzh = l4;
        this.zzi = bl2;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel parcel, int n) {
        void var1_1;
        n = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)1, (int)this.zza);
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)2, (long)this.zzb);
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)3, (long)this.zzc);
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)4, (boolean)this.zzd);
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)5, (long)this.zze);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)6, (int)this.zzf);
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)7, (float)this.zzg);
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)8, (long)this.zzh);
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)9, (boolean)this.zzi);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    public boolean equals(@Nullable Object object) {
        if (object instanceof LocationRequest) {
            LocationRequest locationRequest;
            locationRequest = locationRequest;
            return this.zza == locationRequest.zza && this.zzb == locationRequest.zzb && this.zzc == locationRequest.zzc && this.zzd == locationRequest.zzd && this.zze == locationRequest.zze && this.zzf == locationRequest.zzf && this.zzg == locationRequest.zzg && this.getMaxWaitTime() == locationRequest.getMaxWaitTime() && this.zzi == locationRequest.zzi;
        }
        return false;
    }

    public boolean isFastestIntervalExplicitlySet() {
        return this.zzd;
    }

    public boolean isWaitForAccurateLocation() {
        return this.zzi;
    }
}

