/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.WorkSource;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.WorkSourceUtil;
import com.google.android.gms.internal.location.zzbo;
import com.google.android.gms.location.zzbc;
import com.google.android.gms.location.zzt;

@SafeParcelable.Class(creator="CurrentLocationRequestCreator")
public final class CurrentLocationRequest
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<CurrentLocationRequest> CREATOR;
    @SafeParcelable.Field(id=1, getter="getMaxUpdateAgeMillis", defaultValueUnchecked="Long.MAX_VALUE")
    private final long zza;
    @SafeParcelable.Field(id=2, getter="getGranularity", defaultValueUnchecked="Granularity.GRANULARITY_PERMISSION_LEVEL")
    private final int zzb;
    @SafeParcelable.Field(id=3, getter="getPriority", defaultValueUnchecked="Priority.PRIORITY_BALANCED_POWER_ACCURACY")
    private final int zzc;
    @SafeParcelable.Field(id=4, getter="getDurationMillis", defaultValueUnchecked="Long.MAX_VALUE")
    private final long zzd;
    @SafeParcelable.Field(id=5, getter="isBypass", defaultValue="false")
    private final boolean zze;
    @SafeParcelable.Field(id=6, getter="getWorkSource", defaultValueUnchecked="new android.os.WorkSource()")
    private final WorkSource zzf;

    public int getGranularity() {
        return this.zzb;
    }

    public int getPriority() {
        return this.zzc;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.zza, this.zzb, this.zzc, this.zzd};
        return Objects.hashCode((Object[])objectArray);
    }

    public long getDurationMillis() {
        return this.zzd;
    }

    public long getMaxUpdateAgeMillis() {
        return this.zza;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NonNull
    public String toString() {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CurrentLocationRequest[");
        switch (this.zzc) {
            case 100: {
                string = "HIGH_ACCURACY";
                break;
            }
            case 105: {
                string = "PASSIVE";
                break;
            }
            case 104: {
                string = "LOW_POWER";
                break;
            }
            default: {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                throw illegalArgumentException;
            }
            case 102: {
                string = "BALANCED_POWER_ACCURACY";
            }
        }
        stringBuilder.append(string);
        if (this.zza != Long.MAX_VALUE) {
            stringBuilder.append(", maxAge=");
            zzbo.zza(this.zza, stringBuilder);
        }
        if (this.zzd != Long.MAX_VALUE) {
            stringBuilder.append(", duration=");
            stringBuilder.append(this.zzd);
            stringBuilder.append("ms");
        }
        if (this.zzb != 0) {
            stringBuilder.append(", ");
            stringBuilder.append(zzbc.zzb(this.zzb));
        }
        if (this.zze) {
            stringBuilder.append(", bypass");
        }
        if (!WorkSourceUtil.isEmpty((WorkSource)this.zzf)) {
            stringBuilder.append(", workSource=");
            stringBuilder.append(this.zzf);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    static {
        zzt zzt2;
        CREATOR = zzt2 = new zzt();
    }

    @SafeParcelable.Constructor
    CurrentLocationRequest(@SafeParcelable.Param(id=1) long l, @SafeParcelable.Param(id=2) int n, @SafeParcelable.Param(id=3) int n2, @SafeParcelable.Param(id=4) long l2, @SafeParcelable.Param(id=5) boolean bl, @SafeParcelable.Param(id=6) WorkSource workSource) {
        this.zza = l;
        this.zzb = n;
        this.zzc = n2;
        this.zzd = l2;
        this.zze = bl;
        this.zzf = workSource;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel parcel, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)1, (long)this.getMaxUpdateAgeMillis());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)2, (int)this.getGranularity());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)3, (int)this.getPriority());
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)4, (long)this.getDurationMillis());
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)5, (boolean)this.zze);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)6, (Parcelable)this.zzf, (int)var2_2, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    public boolean equals(@Nullable Object object) {
        CurrentLocationRequest currentLocationRequest;
        if (!(object instanceof CurrentLocationRequest)) {
            return false;
        }
        currentLocationRequest = currentLocationRequest;
        return this.zza == currentLocationRequest.zza && this.zzb == currentLocationRequest.zzb && this.zzc == currentLocationRequest.zzc && this.zzd == currentLocationRequest.zzd && this.zze == currentLocationRequest.zze && Objects.equal((Object)this.zzf, (Object)currentLocationRequest.zzf);
    }

    @NonNull
    public final WorkSource zza() {
        return this.zzf;
    }

    public final boolean zzb() {
        return this.zze;
    }

    public static class Builder {
        private long zza;
        private int zzb;
        private int zzc;
        private long zzd;
        private boolean zze;
        @Nullable
        private WorkSource zzf;

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NonNull
        public Builder setDurationMillis(long durationMillis) {
            void var1_1;
            boolean bl = durationMillis > 0L;
            Preconditions.checkArgument((boolean)bl, (Object)"durationMillis must be greater than 0");
            this.zzd = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setGranularity(int granularity) {
            void var1_1;
            zzbc.zza(granularity);
            this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NonNull
        public Builder setMaxUpdateAgeMillis(long maxUpdateAgeMillis) {
            void var1_1;
            boolean bl = maxUpdateAgeMillis >= 0L;
            Preconditions.checkArgument((boolean)bl, (Object)"maxUpdateAgeMillis must be greater than or equal to 0");
            this.zza = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NonNull
        public Builder setPriority(int priority) {
            boolean bl;
            int n;
            int n2;
            block4: {
                void var1_1;
                block5: {
                    block6: {
                        if (priority == 100) break block5;
                        if (var1_1 == 102) break block6;
                        if (var1_1 != 104) {
                            if (var1_1 == 105) {
                                n2 = 105;
                                n = 105;
                                bl = true;
                                break block4;
                            } else {
                                n2 = var1_1;
                                n = var1_1;
                                bl = false;
                            }
                            break block4;
                        } else {
                            n2 = var1_1;
                            n = var1_1;
                            bl = true;
                        }
                        break block4;
                    }
                    n2 = var1_1;
                    n = var1_1;
                    bl = true;
                    break block4;
                }
                n2 = var1_1;
                n = var1_1;
                bl = true;
            }
            Object[] objectArray = new Object[]{n};
            Preconditions.checkArgument((boolean)bl, (String)"priority %d must be a Priority.PRIORITY_* constants", (Object[])objectArray);
            this.zzc = n2;
            return this;
        }

        @NonNull
        public CurrentLocationRequest build() {
            long l = this.zza;
            int n = this.zzb;
            int n2 = this.zzc;
            long l2 = this.zzd;
            boolean bl = this.zze;
            WorkSource workSource = new WorkSource(this.zzf);
            CurrentLocationRequest currentLocationRequest = new CurrentLocationRequest(l, n, n2, l2, bl, workSource);
            return currentLocationRequest;
        }

        public Builder() {
            this.zza = 60000L;
            this.zzb = 0;
            this.zzc = 102;
            this.zzd = Long.MAX_VALUE;
            this.zze = false;
            this.zzf = null;
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull CurrentLocationRequest request) {
            WorkSource workSource;
            void var1_1;
            this.zza = var1_1.getMaxUpdateAgeMillis();
            this.zzb = var1_1.getGranularity();
            this.zzc = var1_1.getPriority();
            this.zzd = var1_1.getDurationMillis();
            this.zze = var1_1.zzb();
            this.zzf = workSource = new WorkSource(var1_1.zza());
        }

        @NonNull
        public final Builder zza(boolean bl) {
            this.zze = bl;
            return this;
        }

        @NonNull
        public final Builder zzb(@Nullable WorkSource workSource) {
            this.zzf = workSource;
            return this;
        }
    }
}

