/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.accounts.Account;
import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzi;
import com.google.android.gms.identity.intents.UserAddressRequest;
import com.google.android.gms.internal.zzkd;
import com.google.android.gms.internal.zzke;

public class zzkc
extends zzi<zzke> {
    private Activity zzpf;
    private zza zzapn;
    private final String zzKw;
    private final int mTheme;

    public zzkc(Activity activity, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String string, int n) {
        super((Context)activity, looper, 12, connectionCallbacks, onConnectionFailedListener);
        this.zzKw = string;
        this.zzpf = activity;
        this.mTheme = n;
    }

    protected String zzeq() {
        return "com.google.android.gms.identity.service.BIND";
    }

    protected String zzer() {
        return "com.google.android.gms.identity.intents.internal.IAddressService";
    }

    protected zzke zzba(IBinder iBinder) {
        return zzke.zza.zzbc(iBinder);
    }

    public void disconnect() {
        super.disconnect();
        if (this.zzapn != null) {
            this.zzapn.setActivity(null);
            this.zzapn = null;
        }
    }

    protected zzke zzsw() throws DeadObjectException {
        return (zzke)super.zzlX();
    }

    protected void zzsx() {
        super.zzlW();
    }

    public void zza(UserAddressRequest userAddressRequest, int n) {
        this.zzsx();
        this.zzapn = new zza(n, this.zzpf);
        try {
            Bundle bundle = new Bundle();
            String string = this.getContext().getPackageName();
            bundle.putString("com.google.android.gms.identity.intents.EXTRA_CALLING_PACKAGE_NAME", string);
            if (!TextUtils.isEmpty((CharSequence)this.zzKw)) {
                bundle.putParcelable("com.google.android.gms.identity.intents.EXTRA_ACCOUNT", (Parcelable)new Account(this.zzKw, "com.google"));
            }
            bundle.putInt("com.google.android.gms.identity.intents.EXTRA_THEME", this.mTheme);
            this.zzsw().zza(this.zzapn, userAddressRequest, bundle);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"AddressClientImpl", (String)"Exception requesting user address", (Throwable)remoteException);
            Bundle bundle = new Bundle();
            bundle.putInt("com.google.android.gms.identity.intents.EXTRA_ERROR_CODE", 555);
            this.zzapn.zzi(1, bundle);
        }
    }

    protected /* synthetic */ IInterface zzD(IBinder iBinder) {
        return this.zzba(iBinder);
    }

    public static final class zza
    extends zzkd.zza {
        private final int zzTc;
        private Activity zzpf;

        public zza(int n, Activity activity) {
            this.zzTc = n;
            this.zzpf = activity;
        }

        @Override
        public void zzi(int n, Bundle bundle) {
            ConnectionResult connectionResult;
            if (n == 1) {
                Intent intent = new Intent();
                intent.putExtras(bundle);
                PendingIntent pendingIntent = this.zzpf.createPendingResult(this.zzTc, intent, 0x40000000);
                if (pendingIntent == null) {
                    return;
                }
                try {
                    pendingIntent.send(1);
                }
                catch (PendingIntent.CanceledException canceledException) {
                    Log.w((String)"AddressClientImpl", (String)"Exception settng pending result", (Throwable)canceledException);
                }
                return;
            }
            PendingIntent pendingIntent = null;
            if (bundle != null) {
                pendingIntent = (PendingIntent)bundle.getParcelable("com.google.android.gms.identity.intents.EXTRA_PENDING_INTENT");
            }
            if ((connectionResult = new ConnectionResult(n, pendingIntent)).hasResolution()) {
                try {
                    connectionResult.startResolutionForResult(this.zzpf, this.zzTc);
                }
                catch (IntentSender.SendIntentException sendIntentException) {
                    Log.w((String)"AddressClientImpl", (String)"Exception starting pending intent", (Throwable)sendIntentException);
                }
            } else {
                try {
                    PendingIntent pendingIntent2 = this.zzpf.createPendingResult(this.zzTc, new Intent(), 0x40000000);
                    if (pendingIntent2 != null) {
                        pendingIntent2.send(1);
                    }
                }
                catch (PendingIntent.CanceledException canceledException) {
                    Log.w((String)"AddressClientImpl", (String)"Exception setting pending result", (Throwable)canceledException);
                }
            }
        }

        private void setActivity(Activity activity) {
            this.zzpf = activity;
        }
    }
}

