/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.identity;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.GmsClient;
import com.google.android.gms.identity.intents.UserAddressRequest;
import com.google.android.gms.internal.identity.zzf;
import com.google.android.gms.internal.identity.zzi;
import com.google.android.gms.internal.identity.zzj;

public final class zze
extends GmsClient<zzi> {
    private Activity mActivity;
    private zzf zzh;
    private final String zzi;
    private final int mTheme;

    public zze(Activity activity, Looper looper, ClientSettings clientSettings, int n, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super((Context)activity, looper, 12, clientSettings, connectionCallbacks, onConnectionFailedListener);
        this.zzi = clientSettings.getAccountName();
        this.mActivity = activity;
        this.mTheme = n;
    }

    public final boolean requiresAccount() {
        return true;
    }

    protected final String getStartServiceAction() {
        return "com.google.android.gms.identity.service.BIND";
    }

    protected final String getServiceDescriptor() {
        return "com.google.android.gms.identity.intents.internal.IAddressService";
    }

    public final void disconnect() {
        super.disconnect();
        if (this.zzh != null) {
            zzf.zza(this.zzh, null);
            this.zzh = null;
        }
    }

    public final void zza(UserAddressRequest userAddressRequest, int n) {
        super.checkConnected();
        this.zzh = new zzf(n, this.mActivity);
        try {
            Bundle bundle = new Bundle();
            String string = this.getContext().getPackageName();
            bundle.putString("com.google.android.gms.identity.intents.EXTRA_CALLING_PACKAGE_NAME", string);
            if (!TextUtils.isEmpty((CharSequence)this.zzi)) {
                bundle.putParcelable("com.google.android.gms.identity.intents.EXTRA_ACCOUNT", (Parcelable)new Account(this.zzi, "com.google"));
            }
            bundle.putInt("com.google.android.gms.identity.intents.EXTRA_THEME", this.mTheme);
            ((zzi)super.getService()).zza(this.zzh, userAddressRequest, bundle);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"AddressClientImpl", (String)"Exception requesting user address", (Throwable)remoteException);
            Bundle bundle = new Bundle();
            bundle.putInt("com.google.android.gms.identity.intents.EXTRA_ERROR_CODE", 555);
            this.zzh.zza(1, bundle);
            return;
        }
    }

    public final int getMinApkVersion() {
        return 12451000;
    }

    protected final /* synthetic */ IInterface createServiceInterface(IBinder iBinder) {
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            return null;
        }
        IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.identity.intents.internal.IAddressService");
        if (iInterface instanceof zzi) {
            return (zzi)iInterface;
        }
        return new zzj(iBinder2);
    }
}

