/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.flags;

import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.internal.stable.zza;
import com.google.android.gms.internal.stable.zzb;
import com.google.android.gms.internal.stable.zzc;

public interface IFlagProvider
extends IInterface {
    public void init(IObjectWrapper var1) throws RemoteException;

    public boolean getBooleanFlagValue(String var1, boolean var2, int var3) throws RemoteException;

    public int getIntFlagValue(String var1, int var2, int var3) throws RemoteException;

    public long getLongFlagValue(String var1, long var2, int var4) throws RemoteException;

    public String getStringFlagValue(String var1, String var2, int var3) throws RemoteException;

    public static abstract class Stub
    extends zzb
    implements IFlagProvider {
        public Stub() {
            super("com.google.android.gms.flags.IFlagProvider");
        }

        public static IFlagProvider asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface("com.google.android.gms.flags.IFlagProvider");
            if (iInterface instanceof IFlagProvider) {
                return (IFlagProvider)iInterface;
            }
            return new Proxy(iBinder);
        }

        protected boolean dispatchTransaction(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                case 1: {
                    IObjectWrapper iObjectWrapper = IObjectWrapper.Stub.asInterface((IBinder)parcel.readStrongBinder());
                    this.init(iObjectWrapper);
                    parcel2.writeNoException();
                    break;
                }
                case 2: {
                    String string = parcel.readString();
                    boolean bl = zzc.zza((Parcel)parcel);
                    int n3 = parcel.readInt();
                    boolean bl2 = this.getBooleanFlagValue(string, bl, n3);
                    parcel2.writeNoException();
                    zzc.zza((Parcel)parcel2, (boolean)bl2);
                    break;
                }
                case 3: {
                    String string = parcel.readString();
                    int n4 = parcel.readInt();
                    int n5 = parcel.readInt();
                    int n6 = this.getIntFlagValue(string, n4, n5);
                    parcel2.writeNoException();
                    parcel2.writeInt(n6);
                    break;
                }
                case 4: {
                    String string = parcel.readString();
                    long l = parcel.readLong();
                    int n7 = parcel.readInt();
                    long l2 = this.getLongFlagValue(string, l, n7);
                    parcel2.writeNoException();
                    parcel2.writeLong(l2);
                    break;
                }
                case 5: {
                    String string = parcel.readString();
                    String string2 = parcel.readString();
                    int n8 = parcel.readInt();
                    String string3 = this.getStringFlagValue(string, string2, n8);
                    parcel2.writeNoException();
                    parcel2.writeString(string3);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }

        public static class Proxy
        extends zza
        implements IFlagProvider {
            Proxy(IBinder iBinder) {
                super(iBinder, "com.google.android.gms.flags.IFlagProvider");
            }

            @Override
            public void init(IObjectWrapper iObjectWrapper) throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                zzc.zza((Parcel)parcel, (IInterface)iObjectWrapper);
                this.transactAndReadExceptionReturnVoid(1, parcel);
            }

            @Override
            public boolean getBooleanFlagValue(String string, boolean bl, int n) throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                parcel.writeString(string);
                zzc.zza((Parcel)parcel, (boolean)bl);
                parcel.writeInt(n);
                Parcel parcel2 = this.transactAndReadException(2, parcel);
                boolean bl2 = zzc.zza((Parcel)parcel2);
                parcel2.recycle();
                return bl2;
            }

            @Override
            public int getIntFlagValue(String string, int n, int n2) throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                parcel.writeString(string);
                parcel.writeInt(n);
                parcel.writeInt(n2);
                Parcel parcel2 = this.transactAndReadException(3, parcel);
                int n3 = parcel2.readInt();
                parcel2.recycle();
                return n3;
            }

            @Override
            public long getLongFlagValue(String string, long l, int n) throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                parcel.writeString(string);
                parcel.writeLong(l);
                parcel.writeInt(n);
                Parcel parcel2 = this.transactAndReadException(4, parcel);
                long l2 = parcel2.readLong();
                parcel2.recycle();
                return l2;
            }

            @Override
            public String getStringFlagValue(String string, String string2, int n) throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                parcel.writeString(string);
                parcel.writeString(string2);
                parcel.writeInt(n);
                Parcel parcel2 = this.transactAndReadException(5, parcel);
                String string3 = parcel2.readString();
                parcel2.recycle();
                return string3;
            }
        }
    }
}

